// KEHOME/src/mkrGetData.java
// Aug/22/2003
// usage: java -DKBDATA=kbdata mkrGetData subject predicate flags

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;

public class mkrGetData
{
    public static void main(String argv[])
    {
	String info      = "  # INFO: GetData: ";
	String tapuri    = "http://tap.stanford.edu/data/";
	String Subflag   = "includeSubClasses=yes";
	String Superflag = "includeSuperClasses=yes";
	String debug     = "no";

	String kbdata    = System.getProperty("KBDATA");
	String subject   = argv[0];
	String predicate = argv[1];
	String flags     = argv[2];

	if (!Abbrev.IsStandardTag(subject)) {
	    subject = tapuri + subject;
	}
	if (!Abbrev.IsStandardTag(predicate)) {
	    predicate = tapuri + predicate;
	}
	if (debug == "yes") {
	  System.out.println(info + "tapuri = "    + tapuri);
	  System.out.println(info + "kbdata = "    + kbdata);
	  System.out.println(info + "subject = "   + subject);
	  System.out.println(info + "predicate = " + predicate);
	  System.out.println(info + "flags = "     + flags);
	}

	Client tap = new Client(kbdata);
	Resource answer = tap.GetData(subject,predicate,flags);
	if (answer.count() == 0) {
		System.out.println(info + "count = " + answer.count());
	}
	for(int x = 0; x < answer.count(); ++x) {
	    String tapAnswer = answer.item(x).value;
	    String mkrAnswer = XML.SplitNamespace(tapAnswer).tag;
	    //System.out.println("  " + "# " + tapAnswer);
	    System.out.println("  " + mkrAnswer);
	}
    }
}
