#ifndef __STDLIB_H
#define __STDLIB_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#ifndef NULL
#define NULL 0
#endif


#ifndef _PTRDIFF_T
#define _PTRDIFF_T
typedef long    ptrdiff_t;
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

#define offsetof( s_name, m_name )  (size_t)&(((s_name *)0)->m_name)

#ifndef __cplusplus
#ifndef _WCHAR_T_DEFINED
#define _WCHAR_T_DEFINED
typedef unsigned short wchar_t;
#endif
#endif

#ifndef _DIV_T
#define _DIV_T
typedef struct {
        int     quot;
        int     rem;
} div_t;
#endif

#ifndef _LDIV_T
#define _LDIV_T
typedef struct {
        long    quot;
        long    rem;
} ldiv_t;
#endif

#define MB_CUR_MAX 18

/* Maximum value returned by "rand" function
*/
#define RAND_MAX 0x7FFFU

#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1

#ifdef __cplusplus
extern "C" {
#endif

typedef void (* atexit_t)(void);


void         abort(void);

#if !defined(__ABS_DEFINED)
#define __ABS_DEFINED

int         _RTL_INTRINS abs(int __x);

#endif /* __ABS_DEFINED */

int         _RTL_NORM atexit(void (*__func)(void));
double      _RTL_NORM atof(const char *__s);
int         _RTL_NORM atoi(const char *__s);
long        _RTL_NORM atol(const char *__s);
void *      _RTL_NORM bsearch(const void *__key, const void *__base,
                           size_t __nelem, size_t __width,
                           int (*fcmp)(const void *,
                           const void *));
void *      _RTL_NORM calloc(size_t __nitems, size_t __size);
div_t       _RTL_INTRINS div(int __numer, int __denom);
ldiv_t      _RTL_INTRINS ldiv(long __numer, long __denom);
void        _RTL_NORM exit(int __status);
void        _RTL_NORM free(void *__block);
char *      _RTL_NORM getenv(const char *__name);
void *      _RTL_NORM malloc(size_t __size);
int         _RTL_NORM mblen(const char *__s, size_t __n);
size_t      _RTL_NORM mbstowcs(wchar_t *__pwcs, const char *__s,
                                    size_t __n);
int         _RTL_NORM mbtowc(wchar_t *__pwc, const char *__s, size_t __n);
void        _RTL_NORM qsort(void *__base, size_t __nelem, size_t __width,
                       int (* __fcmp)(const void *, const void *));
int         _RTL_NORM rand(void);
void  *     _RTL_NORM realloc(void *__block, size_t __size);
void        _RTL_NORM srand(unsigned __seed);
char *      _RTL_NORM strdup(const char *string);
double      _RTL_NORM strtod(const char *__s, char **__endptr);
long        _RTL_NORM strtol(const char *__s, char **__endptr,
                                    int __radix);
long double _RTL_NORM _strtold(const char *__s, char **__endptr);
unsigned long   _RTL_NORM strtoul(const char *__s, char **__endptr,
                                       int __radix);
int         _RTL_NORM system(const char *__command);
size_t      _RTL_NORM wcstombs(char *__s, const wchar_t *__pwcs,
                                    size_t __n);
int         _RTL_NORM wctomb(char *__s, wchar_t __wc);
int         _RTL_NORM wctombflush(char *__s);


extern  char          ** _environ;
extern  int              _fmode;
extern  unsigned char    _osmajor;
extern  unsigned char    _osminor;


#define atoi(s)     ((int) atol(s))

/* Constants for MSC pathname functions */

#define _MAX_PATH       80
#define _MAX_DRIVE      3
#define _MAX_DIR        66
#define _MAX_FNAME      9
#define _MAX_EXT        5

long double     _RTL_NORM _atold(const char *__s);
unsigned char   _RTL_INTRINS _crotl(unsigned char __value, int __count);
unsigned char   _RTL_INTRINS _crotr(unsigned char __value, int __count);
char     *  _RTL_NORM ecvt(double __value, int __ndig, int *__dec,
                           int *__sign);
void            _exit(int __status);
char     *  _RTL_NORM fcvt(double __value, int __ndig, int *__dec,
                           int *__sign);
char     *  _RTL_NORM _fullpath( char *__buf,
                                 const char *__path,
                                 size_t __maxlen );
char     *  _RTL_NORM gcvt(double __value, int __ndec, char *__buf);
char     *  _RTL_NORM itoa(int __value, char *__string, int __radix);
void     *  _RTL_NORM lfind(const void *__key, const void *__base,
                                 size_t *__num, size_t __width,
                                 int (* __fcmp)(const void *,
                                 const void *));

void     *  _RTL_NORM lsearch(const void *__key, void *__base,
                                 size_t *__num, size_t __width,
                           int (* __fcmp)(const void *, const void *));
char     *  _RTL_NORM ltoa(long __value, char *__string, int __radix);
void        _RTL_NORM      _makepath( char *__path,
                                 const char *__drive,
                                 const char *__dir,
                                 const char *__name,
                                 const char *__ext );
int         _RTL_NORM      putenv(const char *__name);

//#ifndef __STDC__
unsigned    _RTL_INTRINS _rotl(unsigned __value, int __count);
unsigned    _RTL_INTRINS _rotr(unsigned __value, int __count);
//#endif

void        _RTL_NORM _searchenv(const char *__file,
                                 const char *__varname,
                                 char *__pathname);
void        _RTL_NORM _searchstr(const char *__file,
                                 const char *__ipath,
                                 char *__pathname);
void        _RTL_NORM _splitpath( const char *__path,
                                 char *__drive,
                                 char *__dir,
                                 char *__name,
                                 char *__ext );
void        _RTL_NORM swab(char *__from, char *__to, int __nbytes);
char     *  _RTL_NORM ultoa(unsigned long __value, char *__string,
                                 int __radix);

#ifdef __cplusplus
};
#endif


#define sys_nerr _sys_nerr
extern int _sys_nerr ;

#define sys_errlist _sys_errlist
extern char *_sys_errlist[] ;

#define random(num)((rand()*(num))/((RAND_MAX+1))



#define randomize() srand((unsigned)time(NULL))
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))

#define _itoa(__value, __string, __radix) itoa(__value, __string, __radix)

#endif  /* __STDLIB_H */