; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
	;MASM MODE
	.386
	.model use32 small


include  prints.ase 
include  input.ase 
include  mtrap.ase 

	PUBLIC	entry

	.data
inquote	db	0

	.code
;
; Input function for a number
;
InputNumber	PROC	
	mov	[inquote],0
	push	edx
	push	ecx
	push	ebx
	sub	ecx,ecx 		; Number of digits = 0
	sub	ebx,ebx			; Data = 0
lp:
	call	GetKey
	mov	ah,al			; AH = data
	cmp	al,' '			; Space, data is complete
	jz	space		;
	cmp	al,13			;
	jz	isenter		; ENTER = quit entering data
	cmp	al,8			; BACKSPACE or RUBOUT, handle it
	jz	bckspc		;
	cmp	al,7fh			;
	jz	bckspc		;
	cmp	al,'"'
	jz	quote
	cmp	al,"'"
	jz	quote
	test	[inquote],1
	jnz	isquote
	cmp	al,60h
	jc	notlower
	and	al,NOT 20h
notlower:
	sub	al,'0'			; Convert to binary, ignore if not valid
	jc	lp			;
	cmp	al,10			;
	jc	gotdigit		;
	sub	al,7			;
	cmp	al,10			;
	jc	lp			;
	cmp	al,16			;
	jnc	lp			;
gotdigit:
	cmp	cl,2			; If got two digits don't accept
	jz	lp
	shl	bl,4			; Add in the digit
	or	bl,al			;
writechar:
	mov	dl,ah			;
	call	PutChar
	inc	ecx			; Inc digit count
	jmp	lp			; Next digit
isquote:
	cmp	cl,2
	jz	lp
	mov	bl,al
	jmp	writechar
bckspc:
	or	ecx,ecx			; Get next digit if nothing in buffer
	jz	lp			;
	test	[inquote],1
	jz	delnoquote
	cmp	cl,2
	jz	delnoquote
	xor	[inquote],1
delnoquote:
	shr	bl,4
	mov	dl,8			; Erase echoed char
	call	PutChar
	mov	dl,' '			;
	call	PutChar
	mov	dl,8			; Point at next echo space
	call	PutChar
	dec	ecx			; Dec digit count
	jmp	lp
isenter:
	or	ecx,ecx			; Enter key, set carry and get out
	stc				;
	jmp	getout
quote:
	test	[inquote],1
	jnz	lp
	xor	[inquote],1
	jmp	writechar
space:
	or	cl,cl			; Space key, clear carry and get out
getout:
	pushfd
	mov	al,3			; Space to line up in columns
	sub	al,cl			;
	mov	cl,al			;
pslp:			
	call	PrintSpace		;
	loop	pslp			;
	popfd				;
	mov	ax,bx			; AX = number input
	pop	ebx
	pop	ecx
	pop	edx
	ret
InputNumber	ENDP	
;
; Number entry with prompt
;
entry	PROC	
	call	WadeSpace		; Wade through commad spaces
	jz	enterr
	call	ReadAddress		; Read the address
	jc	enterr			; Bad address ,error
	mov	edi,ebx
	mov	ecx,-1			;
	call	WadeSpace		; Wade through spaces
	jz	promptx		; Go do prompt version
readlp:
	call	ReadNumber		; Else read number off command line
	jc	enterr2			; Quit if error
	mov	[edi],al		; Save value
	inc	edi			; Point to next input pos
	call	WadeSpace		; Wade through spaces
	jz	retok		;
	jmp	readlp			; Else get next value
promptx:
	call	crlf
	mov	eax,ebx                 ;
	call	PrintDword	; Print address
elp:
	call	PrintSpace		; Space over two spaces
	call	PrintSpace		;
	mov	al,[edi]		; Print current value
	call	PrintByte		;
	push	edx			;
	mov	dl,'.'			; Print '.'
	call	PutChar
	pop	edx			;
	push	ecx
	call	InputNumber		; Get a number
	pop	ecx
	jz	nextitem		; No number, go do next
	mov	[edi],al		; Save value
nextitem:
	jc	retok		; Quit if ENTER key pressed
	dec	ecx			; Quit if end of segment
	jz	retok		;
	inc	edi			; Point at next value
	inc	ebx			; Next address
	test	ebx,7			; If address mod 7 = 0
	jz	promptx			; Do another prompt
	jmp	elp
retok:
	clc				; No errors
	ret
enterr2:
enterr:		
	stc     			; Errors
dudone:
	ret
entry	ENDP	
END