; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
	.386p
	.model use32 small

	PUBLIC	TableDispatch, nofunction

	.code
;
; Core dispatch routine.  Calls the subfunction indicated in AL
; and then set the return address to after the dispatch table
; This expects a subfunction code to be on the stack
;
TableDispatch	PROC	
	ENTER	0,0
	xchg	ebx,[ebp+4]		; xchg ret address & ebx
	cmp	al,[ebx]		; Limit check
	ja	short noaction		; Error if too big
	; Here we call the routine
	push	offset finishup		; Return address
	sub	ah,ah			; Make key a dword
	cwde				;
	push	DWORD PTR [ebx + 4 * eax + 4]	; Get code address to stack
	xchg	ebx,[ebp+4]		; put things as they were
	mov	eax,[ebp + 8]		; Get the subkey
	cld				; Assume move dir up
	ret				; Go to subroutine
	
noaction:
	xchg	ebx,[ebp+4]		; Put things as they were
	call	nofunction		; Register bad function error
finishup:
	; Now we have to find the return address
	xchg	ebx,[ebp+4]		; Get return address
	push	eax
	mov	eax,[ebx]
	lea	ebx,[ebx + 4 * eax + 8]	; Get offset to return address
	pop	eax
	xchg	ebx,[ebp+4]		; Xchg with orig value of ebx
	LEAVE
	ret	4
TableDispatch	ENDP	
nofunction	PROC	
	mov	eax,-1			; Ill function error
	stc				; Set carry flag
	ret
nofunction	ENDP	
END
	
	
	
	
	
	
