/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <libp.h>

int fseek (FILE *stream, long offset, int origin)
{
	if (stream->token != FILTOK)
		return EOF;
	if (!(stream->flags & _F_APPEND)) {
		switch (origin) {
			case SEEK_CUR:
			case SEEK_SET:
			case SEEK_END:
				if (fflush(stream)) {
					stream->flags |= _F_ERR;
					return EOF;
				}
				if (_ll_seek(stream->fd,offset,origin)) {
					stream->flags |= _F_ERR;
					errno = EIO;
					return EOF;
				}
				
				break;
			default:
				return EOF;
		}
	}
	return 0;
}