/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#ifndef _CMDLINE_H
#define _CMDLINE_H

#include "utype.h"
#define VMSG(ms) ms" Version %d.%02d  Copyright (c) 1994-2002 LADsoft",(VERSION)/100,(VERSION)%100

/* Directory buffer size */
#define DIR_BUFFER 256

/* Directory errors */
#define DIR_OK 0
#define DIR_BADFORMAT 2
#define DIR_INVALID 3
#define DRIVE_INVALID 4

/* Mode values for ARGLIST */
#define ARG_CONCATSTRING 1
#define ARG_NOCONCATSTRING 2
#define ARG_BOOL 3
#define ARG_SWITCH 4
#define ARG_SWITCHSTRING 5

/* Valid arg separators */
#define ARG_SEPSWITCH '/'
#define ARG_SEPFALSE '-'
#define ARG_SEPTRUE '+'

/* Return values for dispatch routine */
#define ARG_NEXTCHAR 1
#define ARG_NEXTARG 2
#define ARG_NEXTNOCAT 3
#define ARG_NOMATCH 4
#define ARG_NOARG 5

typedef void (*FILEFUNC)(FILE *input, FILE *output, char *fname);

typedef struct {
  char id;
  uchar mode;
  void (*routine)(char, char *);
} ARGLIST;

#ifdef __cplusplus
extern "C" {
#endif
#include "cmdline.p"
#ifdef __cplusplus
};
#endif

#endif /* _CMDLINE_H */