/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <io.h>
#include <dos.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <libp.h>

extern int _uiflags[HANDLE_MAX],_uimodes[HANDLE_MAX] ;

int read(int __handle, void *__buf, unsigned __len)
{
   char *pos=__buf ;
   char *dest = __buf ;
   int readlen ;
   int ohand = __handle ;
   __handle = _uiohandle(__handle) ;
   if (__handle == -1)
      return -1 ;
   if (_uimodes[HANDLE_MAX] & O_WRONLY) {
      errno = EACCES ;
      return -1 ;
   }
   if (_uiflags [ohand] & UIF_EOF)
      return 0 ;
   if (_uimodes[ohand] & O_BINARY) {
      int i ;
      for (i=0 ; i < 3; i++) {
         readlen = _ll_read(__handle,dest,__len) ;
         if (readlen >= 0)
            break ;
         sleep(1) ;
      }
      if (readlen == -1)
         return -1 ;
      if (readlen < __len) 
         _uiflags[ohand] |= UIF_EOF ;
      return readlen ;
         
   } else {
      int i ;
      for (i=0 ; i < 3; i++) {
         readlen = _ll_read(__handle,dest,__len) ;
         if (readlen >= 0)
            break ;
         sleep(1) ;
      }
      if (readlen == -1)
         return -1 ;
      if (readlen < __len)
         _uiflags[ohand] |= UIF_EOF ;
      for (i=0; i < readlen; i++) {
         switch (*pos) {
            case '\x1a':
               _uiflags[ohand] |= UIF_EOF ;
               return dest - __buf ;
            case '\r':
               pos++ ;
               break ;
            default:
               *dest++ = *pos++ ;
               break ;
         }
      }
      return dest - __buf ;
   }
}