; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
	;MASM MODE
	.386
	.MODEL use32 small


include  prints.ase 
include  input.ase 
include  mtrap.ase 
include  breaks.ase 
	PUBLIC domath

	.CODE
;
; Do math
;
domath	PROC	
	Call	WadeSpace	; Wade till address
	jc	readerr
	call	ReadNumber	; first number
	jc	readerr
	mov	edx,eax
	call	WadeSpace	; get operator
	jz	readerr
	sub	ebx,ebx
	cmp	al,'*'
	jz	got
	inc	bl
	cmp	al,'/'
	jz	got
	inc	bl
	cmp	al,'+'
	jz	got
	inc	bl
	cmp	al,'-'
	jz	got
	inc	bl
	cmp	al,'%'
	jz	got
	dec	esi
	mov	bl,2		; default operator = +
got:
	inc	esi
	call	WadeSpace
	jz	readerr
	call	ReadNumber	; second number
	jc	readerr
	mov	ecx,eax
	call	WadeSpace
	jnz	readerr
	mov	eax,edx
	call	[ebx*4 + jumptab]
	push	eax
	call	crlf
	pop	eax
	call	PrintDword		; print result
	clc
	ret
jumptab	dd	xmul,xdiv,xxadd,xsub,xmod
xmul:
	mul	ecx
	ret
xmod:
	call	xdiv
	mov	eax,edx
	ret
xdiv:
	or	eax,eax
	jz	nodiv
	sub	edx,edx
	div	ecx
nodiv:
	ret
xxadd:
	add	eax,ecx
	ret
xsub:
	sub	eax,ecx
	ret
readerr:
	stc
	ret
domath	ENDP
end