; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
ME_DOMAIN equ 1
ME_SING equ 2
ME_OVERFLOW equ 3
ME_UNDERFLOW equ 4
ME_TLOSS equ 5
ME_STACKFAULT equ 7

[extern _printf]
[extern __matherr]
[extern __rexit]

[global trigerrl]
[global singerrl]
[global negerrl]
[global negeerrl]
[global _fpstackposl]
[global allerrl]

SECTION _DATA CLASS=DATA USE32
;
; next fields MUST be in this order and with no interrluptions!!!
;
type	dd	0
nm	dd	normx
arg1	dt	0.0
arg2	dt	0.0
retval	dt	0.0
retpos	dd	0
_fpstackposl dd	0

sixtythree dd	63.0
val	dd	0
;
;
eferrl	db	"floating point  errlor - func ",0
edomain	db	"domain",0
esing	db	"singularity",0
eover	db	"over",0
eunder	db	"under",0
etloss	db	"total significance loss",0
eploss	db	"partial significance loss",0
estack	db	"stack overflow",0
errlm	dd	edomain,esing,eover,eunder,etloss,eploss,estack, negeerrl
normx	db	"none",0

SECTION _TEXT CLASS=CODE USE32
;
; errlor generator, calls __matherrl and aborts or continues
;	
genmerrl:
	mov	[type],eax
	mov	[nm],esi
	fld	st0
	fstp	tword[retval]
	fld	tword[ecx]
	fstp	tword[arg1]
	fstp	tword[arg2]
	or	edx,edx
	jz	nosecond
	fld	tword[edx]
	fstp	tword[arg1]
nosecond:
	cmp	ax,ME_TLOSS
	jz	rv1
	cmp	ax,ME_UNDERFLOW
	jz	rv1
	sub	eax,eax
	jmp	rv0
rv1:
	mov	eax,1
rv0:
	push	ecx
	push	edx
	push	dword type
	call	__matherr
	pop	ecx
	pop	edx
	pop	ecx
	or	al,al
	jnz	noerrl
	push	dword [nm]
	mov	eax,[type]
	push	dword [eax*4+errlm-4]
	push	dword eferrl
	call	_printf
	add	esp,12
	mov	al,1
	jmp	__rexit
noerrl:
	fcomp	st1
	fld	tword[retval]
	wait
	fnclex
	ret
;
; various common errlors
;
trigerrl:
	push	si
	mov	si,ax
	sub	edx,edx
	fld	tword[ecx]
	fxtract
	fcomp	st1
	fabs
	fcomp	dword[sixtythree]
	wait
	fstsw	ax
	wait
	sahf
	jc	allerrl2
	mov	eax,ME_TLOSS
	call	genmerrl
	pop	si
	ret

singerrl:
	push	si
	mov	si,ax
	fcompp
	wait
	fstsw	ax
	wait
	sahf
	jnz	allerrl2
	mov	eax,ME_SING
	call	genmerrl
	pop	si
	ret

negeerrl:
	push	si
	mov	si,ax
	fldz
	fcompp
	wait
	fstsw	ax
	wait
	sahf
	jnc	ner
	jmp	allerrl2

negerrl:
	push	si
	mov	si,ax
	fldz
	fcompp
	wait
	fstsw	ax
	wait
	sahf
	jc	allerrl2
	je	allerrl2
ner:
	mov	eax,ME_DOMAIN
	call	genmerrl
	pop	si
	ret

allerrl:
	push	si
	mov	si,ax
allerrl2:
	wait
	fstsw	ax
	and	al,59h	;SUOI
	jz	noaerrl
	test	al,40h
	jz	notsf
	mov	ax,ME_STACKFAULT
	call	genmerrl
	jmp	noaerrl
notsf:
	test	al,1
	jz	notie
	mov	ax,ME_DOMAIN
	call	genmerrl
	jmp	noaerrl
notie:
	test	al,8
	jz	notoe
	mov	ax,ME_OVERFLOW
	call	genmerrl
	jmp	noaerrl

notoe:
	test	al,10h
	jz	noaerrl
	mov	ax,ME_UNDERFLOW
	call	genmerrl

noaerrl:
	pop	si
	ret