; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
ME_DOMAIN equ 1
ME_SING equ 2
ME_OVERFLOW equ 3
ME_UNDERFLOW equ 4
ME_TLOSS equ 5
ME_STACKFAULT equ 7

[extern _printf]
[extern __matherr]
[extern __rexit]

[global trigerr]
[global singerr]
[global negerr]
[global negeerr]
[global _fpstackpos]
[global allerr]

SECTION _DATA CLASS=DATA USE32
;
; next fields MUST be in this order and with no interruptions!!!
;
type	dd	0
nm	dd	normx
arg1	dq	0.0
arg2	dq	0.0
retval	dq	0.0
retpos	dd	0
_fpstackpos dd	0

sixtythree dd	63.0
val	dd	0
;
;
eferr	db	"floating point  error - func ",0
edomain	db	"domain",0
esing	db	"singularity",0
eover	db	"over",0
eunder	db	"under",0
etloss	db	"total significance loss",0
eploss	db	"partial significance loss",0
estack	db	"stack overflow",0
errm	dd	edomain,esing,eover,eunder,etloss,eploss,estack, negeerr
normx	db	"none",0

SECTION _TEXT CLASS=CODE USE32
;
; error generator, calls __matherr and aborts or continues
;	
genmerr:
	mov	[type],eax
	mov	[nm],esi
	fst	qword[retval]
	fld	qword[ecx]
	fstp	qword[arg1]
	fstp	qword[arg2]
	or	edx,edx
	jz	nosecond
	fld	qword[edx]
	fstp	qword[arg1]
nosecond:
	cmp	ax,ME_TLOSS
	jz	rv1
	cmp	ax,ME_UNDERFLOW
	jz	rv1
	sub	eax,eax
	jmp	rv0
rv1:
	mov	eax,1
rv0:
	push	ecx
	push	edx
	push	dword type
	call	__matherr
	pop	ecx
	pop	edx
	pop	ecx
	or	al,al
	jnz	noerr
	push	dword [nm]
	mov	eax,[type]
	push	dword [eax*4+errm-4]
	push	dword eferr
	call	_printf
	add	esp,12
	mov	al,1
	jmp	__rexit
noerr:
	fcomp	st1
	fld	qword[retval]
	wait
	fnclex
	ret
;
; various common errors
;
trigerr:
	push	esi
	mov	esi,eax
	sub	edx,edx
	fld	qword[ecx]
	fxtract
	fcomp  	st1
	fabs
	fcomp	dword[sixtythree]
	wait
	fstsw	ax
	wait
	sahf
	jc	allerr2
	mov	eax,ME_TLOSS
	call	genmerr
	pop	esi
	ret

singerr:
	push	esi
	mov	esi,eax
	fcompp
	wait
	fstsw	ax
	wait
	sahf
	jnz	allerr2
	mov	eax,ME_SING
	call	genmerr
	pop	esi
	ret

negeerr:
	push	esi
	mov	esi,eax
	fldz
	fcompp
	wait
	fstsw	ax
	wait
	sahf
	jnc	ner
	jmp	allerr2

negerr:
	push	esi
	mov	esi,eax
	fldz
	fcompp
	wait
	fstsw	ax
	wait
	sahf
	jc	allerr2
	je	allerr2
ner:
	mov	eax,ME_DOMAIN
	call	genmerr
	pop	esi
	ret

allerr:
	push	esi
	mov	esi,eax
allerr2:
	wait
	fstsw	ax
	and	al,59h	;SUOI
	jz	noaerr
	test	al,40h
	jz	notsf
	mov	ax,ME_STACKFAULT
	call	genmerr
	jmp	noaerr
notsf:
	test	al,1
	jz	notie
	mov	ax,ME_DOMAIN
	call	genmerr
	jmp	noaerr
notie:
	test	al,8
	jz	notoe
	mov	ax,ME_OVERFLOW
	call	genmerr
	jmp	noaerr

notoe:
	test	al,10h
	jz	noaerr
	mov	ax,ME_UNDERFLOW
	call	genmerr

noaerr:
	pop	esi
	ret