// TFINTRO.h
// Intro for game
// Also makes settings ajustments and displays score.


#include <windows.h>
#include <stdlib.h>
#include <time.h>



void DoIntro (int &SleepTime,int &DifLevel,bool &ShowSmoke,bool &ShowDebris)
// Intro displays Title screen,
// Then options are displayed for ajusting difficulty and graphics.
// Several for loop groups are used to create line fading effects.
{
   SetFillColorRGB(BLACK);                   // Set fill to black.
   PutBitmap(GetBitmapFile("intro.bmp"),0,0);// Select and display the picture.
   PutText(" ",0,0);                         // This needs to be displayed in
   														// order to make the bitmap visible
                                             // This is due to an EZGDI bug.
   cKeyPressed = 0;
   while(cKeyPressed == 0);						// This code DOES have effect!
   cKeyPressed = 0;                          // Clear the key value.
   for(int g = 0;g<=150;g+=30){              // Large fading loop
   	for(int i = 1;i<=5;i++){               	// Small fading loop
   		for(int y = 1;y<=480;y+=5){            	// Loop covers top to bottom.
      		Line(0,y+i,640,y+i,RGB(g+random(g/6),g+random(g/6),g+random(g/6)));
            // Line drawn with a randomly adjusted gray color and position.
   		}
      	if (cKeyPressed == 0) Sleep(20);         	// if User wants to go faster
   	}                                         // End Small fading loop.
   }                                         // End Large fading loop.

   for(double i = 1;i<100;i+=.5){            // This loop creates a black box.
   	Rect(320-i*1.5,200-i,320+i*1.5,200+i,BLACK);
      if (cKeyPressed == 0) Sleep(3);        	// if User wants to go faster.
   }
   for(int i = -10;i<15;i++){                // This loop creates a gray faded
   														// border to the previous black box.
   	Rect(180+i,110+i,460-i,290-i,RGB(255-abs(i)*15,255-abs(i)*15,255-abs(i)*15));
      if (cKeyPressed == 0) Sleep(20);       	// if User wants to go faster.
   }

   Text(250,270,"Level",WHITE);              // Some things to display inside
   Text(320,270,": Normal",WHITE);				// the black box.
   Text(250,240,"Speed",WHITE);
   Text(250,210,"Debree",WHITE);
	Text(320,210,": On",WHITE);
	Text(320,180,": On",WHITE);               // Some more things to display
   Text(250,180,"Clouds",WHITE);             // inside the black box.
	Text(320,240,": Normal",WHITE);
   Text(220,150,"Press Space Bar To Start!",WHITE);
   int y;                                    // Temp variable.
   SleepTime=30;                             // Default Sleeptime.
   DifLevel=2;                               // Default Difficulty.
   cKeyPressed = 0;                          // Reset the Key value.
   SetFillColorRGB(BLACK);                   // Set Fill to Black.
   while(cKeyPressed != 32){              // While spacebar hasn't been pressed
      if (cKeyPressed == 's'){            	// if 's',
      	cKeyPressed = 0;                    	// Reset.
         SleepTime-=10;                         // Lower SleepTime.
         if (SleepTime<=10) SleepTime = 40;     // Adjust if too low.
         Rect(320,240,400,220,BLACK);           // Clear previous text.
   		if (SleepTime == 20) Text(320,240,": Fast",WHITE);
   		if (SleepTime == 30) Text(320,240,": Normal",WHITE);  // Text according
   		if (SleepTime == 40) Text(320,240,": Slow",WHITE);		// to SleepTime.

      }
      if (cKeyPressed == 'l'){            	// if 'l',
      	cKeyPressed = 0;								// Reset.
         DifLevel++;                            // Increment Difficulty.
         if (DifLevel>=4) DifLevel = 1;         // Adjust if too high.
         Rect(320,270,400,250,BLACK);           // Clear previous text.
   		if (DifLevel == 1) Text(320,270,": Easy",BLUE);
   		if (DifLevel == 2) Text(320,270,": Normal",WHITE);   	// Text according
   		if (DifLevel == 3) Text(320,270,": Hard",RED);        // to DifLevel.

      }
      if (cKeyPressed == 'd'){             	// if 'd',
      	cKeyPressed = 0;								// Reset.
         ShowDebris = !ShowDebris;              // Set to oppisite.
         Rect(320,210,400,190,BLACK);           // Clear previous text.
   		if (ShowDebris) Text(320,210,": On",WHITE);          	// Text according
   		if (!ShowDebris) Text(320,210,": Off",WHITE);         // to ShowDebris.

      }
      if (cKeyPressed == 'c'){               // if 'c',
      	cKeyPressed = 0;                    	// Reset.
         ShowSmoke = !ShowSmoke;                // Set to oppisite.
         Rect(320,180,400,160,BLACK);           // Clear previous text.
   		if (ShowSmoke) Text(320,180,": On",WHITE);          	// Text according
   		if (!ShowSmoke) Text(320,180,": Off",WHITE);          // to ShowSmoke.

      }






      y = random(481);                     	// random value.
      if ((y < 100) || (y > 300))          	// if above or below black box,
   		Line(0,y,640,y,RGB(150+random(25),150+random(25),150+random(25)));
         												// Draw a line randomly adjusted
      y = random(481);                       // random value.
      if ((y >= 100) && (y <= 300)){         // if above or below black box,
      	Line(0,y,170,y,RGB(150+random(25),150+random(25),150+random(25)));
      	Line(470,y,640,y,RGB(150+random(25),150+random(25),150+random(25)));
         // Draw 2 lines randomly adjusted on either side of the black box.
      }
   }

   if (SleepTime == 40) SleepTime = 60;      // if "slow" make slower.
   cKeyPressed = 0;                          // Reset key.
   for(int g = 150;g>=0;g-=30){              // Large fading loop
   	for(int i = 5;i>=1;i--){               	// Small fading loop
   		for(int y = 480;y>=1;y-=5){
      		Line(0,y+i,640,y+i,RGB(g+random(g/6),g+random(g/6),g+random(g/6)));
            // Line drawn with a randomly adjusted gray color and position.
         }
      	if (cKeyPressed == 0) Sleep(30);       // if User wants to go faster.
   	}                                      	// End small fading loop
   }                                         // End large fading loop
   ClearScreen();                            // Clear Screen when done

}

void DoHighScore (int &UserScore)
{
   SetFillColorRGB(BLACK);
   cKeyPressed = 0;                          // Clear the key value.
   for(int g = 0;g<=150;g+=30){              // Large fading loop
   	for(int i = 1;i<=5;i++){               	// Small fading loop
   		for(int y = 1;y<=480;y+=5){            	// Loop covers top to bottom.
      		Line(0,y+i,640,y+i,RGB(g+random(g/6),g+random(g/6),g+random(g/6)));
            // Line drawn with a randomly adjusted gray color and position.
   		}
      	if (cKeyPressed == 0) Sleep(20);         	// if User wants to go faster
   	}                                         // End Small fading loop.
   }                                         // End Large fading loop.

   for(double i = 1;i<100;i+=.5){            // This loop creates a black box.
   	Rect(320-i*1.5,200-i,320+i*1.5,200+i,BLACK);
      if (cKeyPressed == 0) Sleep(3);        	// if User wants to go faster.
   }
   for(int i = -10;i<15;i++){                // This loop creates a gray faded
   														// border to the previos black box.
   	Rect(180+i,110+i,460-i,290-i,RGB(255-abs(i)*15,255-abs(i)*15,255-abs(i)*15));
      if (cKeyPressed == 0) Sleep(20);       	// if User wants to go faster.
   }

   char str[10];                                // temp string
   Text(205,150,"Press Space Bar To Continue",WHITE);  // some things to display
   Text(230,250,"Your Score:",WHITE);
   itoa(UserScore, str, 10);     					// Score # is converted here.
   ChangeFont(64,64,false,false,false,"");      // Change font
   Text(235,220,str,WHITE);                     // Show score.


   cKeyPressed = 0;                             // Reset score.
   SetFillColorRGB(BLACK);                      // Set Fill
   int y;                                       // temp variable.
   while(cKeyPressed != 32){                    // if not Spacebar

   	Text(235,220,str,RGB(150+random(55),150+random(55),150+random(55)));
      													// Display score in random color.
      y = random(481);                     	// random value.
      if ((y < 100) || (y > 300))          	// if above or below black box,
   		Line(0,y,640,y,RGB(150+random(25),150+random(25),150+random(25)));
         												// Draw a line randomly adjusted
      y = random(481);                       // random value.
      if ((y >= 100) && (y <= 300)){         // if above or below black box,
      	Line(0,y,170,y,RGB(150+random(25),150+random(25),150+random(25)));
      	Line(470,y,640,y,RGB(150+random(25),150+random(25),150+random(25)));
         // Draw 2 lines randomly adjusted on either side of the black box.
      }
   }
   ChangeFont(20,20,false,false,false,"Arial");		// Restore font.


   cKeyPressed = 0;                                // Reset Key
   for(int g = 150;g>=0;g-=30){                    // Large fading loop
   	for(int i = 5;i>=1;i--){                     	// Small fading loop
   		for(int y = 480;y>=1;y-=5){
      		Line(0,y+i,640,y+i,RGB(g+random(g/6),g+random(g/6),g+random(g/6)));
            // Line drawn with a randomly adjusted gray color and position.
   		}
      	if (cKeyPressed == 0) Sleep(30);              	// Faster if user wants
   	}                                            	// End Small fading loop
   }                                               // End Large fading loop
   ClearScreen();                                  // Clear Screen.

}

