

/*  EZGdi v1.10 BETA                                         */
/* A simple interface to the Win32 GDI.						 */
/* This file should be included in the in the drawing code.	 */
/* This file contains the the prototypes and macros for easy */
/* access to the GDI.													 */

/* written and copyrighted by Peter Neubauer (1998)          */
/* updated by Peter Neubauer (1999)							 */

// Define this if you are not using Borland C++
// #define NO_BCC


#define STRICT
#include <windows.h>
#include <stdlib.h>
#include <time.h>


//user entrypoints
void KeyCallBack(char c);
DWORD WINAPI DrawThread( LPVOID );



//extern'ed vars
extern DWORD hThread;
extern HDC hBuffer;
extern HWND hWnd;
extern COLORREF crColor;
extern char cKeyPressed;

// defines for Borland style random functions 
#ifdef NO_BCC
inline void randomize() 
	{srand( (unsigned)time( NULL ) );}
inline int  random(int max) 
	{return (int)((float)rand()/RAND_MAX*(max-1));};
#endif


// Back-Compatibility Hacks
#define FlipPage() ;
#define ClearBuffer() ClearScreen()

//prototypes
void DrawLine_(int x1, int y1, int x2, int y2);
void SetPixel_(int x, int y);
void SetColor_(BYTE r, BYTE g, BYTE b);
void SetFillColor_(BYTE r, BYTE g, BYTE b, UINT style = BS_SOLID, LONG hatch = 0);
void FloodFill_(int x, int y, COLORREF Boundary = crColor);
void Ellipse_(int Left, int Top, int Right, int Bottom);
void Rectangle_(int Left, int Top, int Right, int Bottom);
HBITMAP GetBitmap_(LPCSTR fname);
void PutBitmap_(HBITMAP hBmp, int x, int y);
void SetLineStyle_( int fnPenStyle, int nWidth);
void PutText_(LPCSTR str, int x, int y);
int GetMaxY_();
int GetMaxX_();
COLORREF GetPixel_(int x, int y);
void SetTitle_(LPCSTR title);
void ChangeFont_(int nHeight, int fnWeight, bool fdwItalic, bool fdwUnderline,
                bool fdwStrikeOut, LPCSTR lpszFace);
HBITMAP CaptureBitmap(int x, int y, int width, int height);
HBITMAP GetBitmapFile(LPCSTR fname);
void ClearScreen();

class MouseInfo {
   public:
   int xpos, ypos;
   char mousemove;
   char lbutton, rbutton, mbutton;
   char dclickl;
   char was_dclickl;

};

extern MouseInfo Mouse;

//some of the above names may conflict with the win gdi
//use a macro to avoid problems
//most of these are uneccesary, but keep them all for consistancy
#define DrawLine(x1, y1, x2, y2) DrawLine_(x1, y1, x2, y2)
#define SetPixel(x, y) SetPixel_(x, y)
#define SetColor(r, g, b) SetColor_(r, g, b)
#define FloodFill(x, y) FloodFill_(x, y)
#define SetFillColor(r, g, b) SetFillColor_(r, g, b)
#define Ellipse(x1, y1, x2, y2) Ellipse_(x1, y1, x2, y2)
#define Rectangle(x1, y1, x2, y2) Rectangle_(x1, y1, x2, y2)
#define GetBitmap(path) GetBitmap_(path)
#define PutBitmap(bmp, x, y) PutBitmap_(bmp, x, y)
#define SetLineStyle(style, width) SetLineStyle_(style, width)
#define PutText(str, x, y) PutText_(str, x, y)
#define GetMaxX() GetMaxX_()
#define GetMaxY() GetMaxY_()
#define GetPixel(x, y) GetPixel_(x, y)
#define SetTitle(title) SetTitle_(title)
#define ChangeFont(a, b, c, d, e, f) ChangeFont_(a, b, c, d, e, f)
#define SetColorRGB(rgb) SetColor_(GetRValue(rgb), GetGValue(rgb), GetBValue(rgb))
#define SetFillColorRGB(rgb) SetFillColor_(GetRValue(rgb), GetGValue(rgb), GetBValue(rgb))


//color constants
#define BLACK 				RGB(0, 0, 0)
#define BLUE  				RGB(0, 0, 255)
#define GREEN 				RGB(0, 255, 0)
#define CYAN  				RGB(0, 255, 255)
#define RED   				RGB(255, 0, 0)
#define MAGENTA 			RGB(255, 0, 255)
#define BROWN  				RGB(128, 128, 0)
#define LIGHTGRAY 			RGB(192, 192, 192)
#define DARKGRAY 			RGB(128, 128, 128)
#define LIGHTBLUE 			RGB(64, 64, 255)
#define LIGHTGREEN 			RGB(91, 255, 91)
#define LIGHTCYAN 			RGB(128, 255, 255)
#define LIGHTRED 			RGB(255, 130, 130)
#define LIGHTMAGENTA 		RGB(255, 128, 255)
#define YELLOW 				RGB(255, 255, 0)
#define WHITE 				RGB(255, 255, 255)
