<HTML>
<HEAD>
<TITLE></TITLE>
<STYLE TYPE="text/css" MEDIA=screen >
<!--
 BODY { font-family: "Courrier New", Courrier, mono, Monospaced, Arial }
 .toc { font-family: "Courrier New", Courrier, mono, Monospaced, Arial  }
 H3  { font-size: 18pt; color: #333399 }
 H4  { font-size: 16pt; color: #333399 }
 H5  { font-size: 14pt; color: #333399 }
 H6  { font-size: 12pt; color: #333399 }
 H7  { font-size: 11pt; color: #333399 }
 PRE { font-size: "14pt"; font-family: "Courrier New", Courrier, mono, Monospaced, Arial;  color: "#000000" }
 A:link { text-decoration: none; color: #0000cc }
 A:visited { text-decoration: none; color: #0000ff }
 A:hover { text-decoration: none; color: #ff00ff }
-->
</STYLE>
</HEAD>
<BODY bgcolor=#FFFFFF>
<table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_array.php" target="_self"><img src="simprev.gif" border="0"></a></td>
          <td width="105" height="40"><a href="en_array.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_struc.php" target="_self"><img src="simup.gif" border="0"></a></td>
          <td width="65" height="40"> <a href="en_struc.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_fun.php" target="_self"><img src="simnext.gif" border="0"></a></td>
          <td width="64" height="40"> <a href="en_fun.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_array.php" target="_self">VI Arrays and dict</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_fun.php" target="_self">VIII Functions</a>

<h3><a name="title0"></a>
VII Control structures</h3> <pre>

 Control structures allow to process conditionally a block of statements, or to
process them repetitively.
 They have been redesigned in Scriptol to suppress the frequent causes of errors,
the most common being the infinite loops, and to apply the principle of
pattern-matching that is appraised by programmers...

</pre>
<h4><a name="title1"></a>
  If then else</h4> <pre>

 A conditional statement has the form:
    if condition then action else alternate-action
 Scriptol writes the "then" keyword, either "?" when the action is a single
statement or ":" when it is a block of statements.
 If the block of statement starts on the following line, the end of line
terminates the condition, and the ":" becomes optional.

 Example...
 if name = "pussycat"
   print "this is a cat"
   print "it seems hurted"
 else
   print"this is another animal"
 /if

 The else part is optional. Thus, a if structure is a condition, followed by one
or several statements (this may be others if) and ended by /if.
 The "/" symbol is a shortcut for "end", and is used to terminate any control
structure. "/if" means "end of if structure".
 The condition may be a comparison as above, or any kind of test. The "in" test
already viewed, a boolean test, or anything that evaluate to a boolean value,
true or false.
 This is the simple format for the if, there are other one, but for now, let us
examine the for loop.

</pre>
<h4><a name="title2"></a>
  For</h4> <pre>

 We are returning to list with the for loop, the goal of which being to set one
by one into a variable, each element of a list or a range of values.

 We have an array a.
 for text t in a
   ... statements ...
 /for
 We can do the block of statements processing the element stored in t.
 The compiler knows the first line of the control structure is terminated as it
encounters the end of line. If you want to put a statement on this first line, a
colon is required to terminate the header of the "for" structure:
 for text t in a : print t
 /for
 You can put also the /for on the same line, but in this case the compiler needs
for a semicolon to terminate the statement:
 for text in a : print t; /for

 These conventions are the same for the if and any other Scriptol's control
structures.

 We can loop also in values and use each value as index of an array. If one wants
to write into the array, this is required.
  for int i in 1..10
    a[i] = 0
  /for

</pre>
<h4><a name="title3"></a>
  While</h4> <pre>

 The while control structure is a loop associated with a if.
  while condition
    ... statements ...
  /while

  Example:
  int x = 10
  while x < 20
    print x
    x + 1
  /while

 Along with the while, I must to introduce two special statement, that are
useful within any kind of loops.

</pre>
<h4><a name="title4"></a>
  Break</h4> <pre>

 This command exits the loop when a condition is verified and may be a means to
move the condition inside the loop.
 A better example is given if one uses the "forever" keyword that lead to a
deliberate infinite loop:
  int x = 0
  while forever
   print x
   if x > 100
     break
   /if
   x + 1
 /while
 When x reaches the value 100, the break statement lets the program continue
on the statement following the while structure.

</pre>
<h4><a name="title5"></a>
  Continue</h4> <pre>

 This second command allow to pass the statement from the current position to
the /while, and thus to restart a new loop.
  int x = -1
  while x < 20
    x + 1
    if (x mod 2) = 0
      continue
    /if
   print x
  /while
 This example displays only the even values of x, as when we encounter an odd
value, the condition of if is verified and a continue command is performed.
 In this example, I have inserted the incrementing of x on the first line. If
you have already programmed, you guess the reason. If it was put before the
/while, as in previous examples, the continue statement would have resulted in
an infinite loop, since the incrementing would be skiped.
 To avoid this kind of error, an option exists in Scriptol.

</pre>
<h5><a name="title6"></a>
   While let</h5> <pre>

 This variant prevents the programmer to be leaded in bugs by the deficient
design of the while structure (I don't know who has inventend it... No it is
false, I know who he is, but I want not to denounce it ;-)
 The let option allow to move the incrementing beyond the point where the
continue statement restarts the processing.
  int x = 0
  while x < 20
    if (x mod 2) = 0
      continue
    /if
    print x
  /while let x + 1

 This is the conventional form. A simplifed one exist, and you are greatly
encouraged to use it for any while control structure you write:
  int x = 0
  while x < 20
    if (x mod 2) = 0
      continue
    /if
    print x
  let x + 1

</pre>
<h4><a name="title7"></a>
  Do while</h4> <pre>

 If you want to perform the processing at least one time, you have to move the
test of the condition to the end of the control structure.
  int x = 0
  do
    print x
    x + 1
  /do while x < 20
 Here also one can use the "forever" keyword along with a break command.

</pre>
<h4><a name="title8"></a>
  Do until</h4> <pre>

 And if you want to test rather if a condition is reached, then use the until
variant:
  do
    print x
    x + 1
  until x = 10

 Maybe you wonder why one have to write simply until here, and /do while
otherwise. There is a reason in the compilation process: as while may starts
another control structure, the compiler would be confused, that is not the case
with until, and another reason due to the construct itself, as the while is only
an option of a more general structure.

</pre>
<h4><a name="title9"></a>
  Do case</h4> <pre>

 The content of a do statement may be splitted into several conditional cases
that are selected by the computer, and a single one processed.
 do
 case name = "pussycat":   print "this is a cat"
 case name = "flipper":    print "this is a dolphin"
 case name = "mobby dick": print "this is a whale"
 else
  print "this is another animal"
 /do

 The while condition has disappeared here, but one can keep it if needed, this
will result just in a finite-state automata!
 To make a such automata, one need for some processing inside the control
structure, and that is allowed by the "always" option.

 int state = ... (some value)
 do
  case state = ON:  counter + 1
  case state = OFF: break
  always
    state = getState()     ` some function
 /do while forever
 We have just designed a kind of automata that gets its state from some function,
and continue to work until the OFF state is encountered.

</pre>
<h4><a name="title10"></a>
  Scan</h4> <pre>

 "scan .. by" is another powerful control structure invented with Scriptol and
it can replace by two or three lines, a page of code in an old language as C++
or Pascal.
 The first syntax is:
 scan a, b, ... by somefunction

 Each element of the array a, b, etc... are given as parameters to a function
and processed together by this function.
 When the last element of one of the arrays has been reached, the process is
terminated.

 The second syntax is:
 scan a, b, ...
   ... statements...
 /scan
 The elements of the array are not processed by a function, but rather by a
block of statements that follows up.

 Example:
 array a = (1,2,3,4,5,6)
 array b = ("a","b","c","d")
 array c = ()
 scan a,b
   c.push(b[] + str(a[]))
 /scan
 The content of c should be:  ("a1", "b2", "c3", "d4")
 The empty index designate the currently pointed out element in a list. We can
also use it in assignement:
 scan a
  a[] * 10
 /scan
 The content of a should be now: (10,20,30,40,50,60)

</pre>
<h4><a name="title11"></a>
  One-statement</h4> <pre>

 Often the if statement is used to perform conditionally a single statement.
and this syntax would have to be simpler in a such case. And also, when a
statement exits the processing, it seems not convenient for the code to add
anything after it.
 For example:
 if condition : break; /if   or
 if condition : return; /if
 The /if seems to be useless since we don't reach it, and Scriptol just allows
it to be removed, providing the compiler is informed it is a simplified
structure, that is done thanks either to the "?" symbol or the "let" keyword.
 The word "let" means for Last, Execute, Terminate. The let statement is always
the last part of a control structure. Use either "?" or "let" according to what
seems you the more appropriate.

 When the condition is followed by ? rather than by : or an end of line, that
means that the body of the if structure is a single statement, and can't be more
than one statement.
 This syntax applies to all other control structures, but the "do" ... one.
 Syntax:
 if condition ? statement
 if condition ? statement; else statement
 while condition ? statement; let incrementing
 while condition let statement
 for range let statement
 scan arrays let statement

 This can't apply to the do .. /do control structure, because it has no
condition at the beginning.

 Examples:
 if x < 10 ? break
 if (x + y) = 0 ? print "some text"
 if a < 10 ? print "less"; else print "more"
 for w in array1 let print w
 scan a,b let a[] * b[]

</pre>
<h4><a name="title12"></a>
  Composite if</h4> <pre>

 We have just studied above the simplest form of the if control structure.
 In fact, it is in Scriptol a very powerful structure that mays perform several
comparisons or other kinds of tests in alternative blocks, and is suitable for
pattern-matching.

 Supposing you want to compare a variable (number, text, array) with several
values successively, the if structure can have this form:
  if variable
  = value: statements
  = value: statements
  = value: statements
  else statements
  /if

 Only the statements which follow the value matching the variable will be
processed. In no value is matched, the statements following "else" will be
processed.
 One may also compare if the variable is < to a value, > to a value, and so one.
 Example:
 if a
 < 10 : print "less"
 = 10 : print "equal"
 > 10 : print "more
 /if

 One may also test if the variable is "in" an array.
 Example:
 if x
 in (1,2,3): print "first"
 in (4,5,6): print "second"
 in (7,8)  : print "third"
 else print "other"
 /if

 On can use these operators and mix them all together:
  =, <, >, <=, >=, !=, <>, in, match.

 The composite if adds to computer language (Scriptol only for now) the
principle of pronoun of human language, without the ambiguities of it.

</pre>
<h4><a name="title13"></a>
  Enum</h4> <pre>

 Enum, is a mean to assign automatically successive values to constants, when
one needs only for them having different values to transmit messages with
significant names rather than with numbers.
 For example the different parts of a painter have to deal with brush, pencil,
fill, shadow, etc...
 Rather than to give to each of them a number and use this number in messages
between components of the program, one may create an enum:
 enum
   BRUSH, PENCIL, FILL, SHADOW, etc...
 /enum

 The enum structure may have also the simplified syntax:
 enum BRUSH, PENCIL, FILL, SHADOWN, etc...
 The question mark or "let" is useless in fact and may be omitted since there is
no condition after the "enum" keyword.

 The identifiers are assigned the value from 0 to n - 1, if their number is n.
 The enum above is equivalent to:
 constant integer BRUSH = 0
 constant integer PENCIL = 1
 constant integer FILL = 2
 constant integer SHADOW = 3
 etc...

 If is possible to restart the numbering, at any position in the list:
 Example:
 enum BRUSH, PENCIL = 4, FILL, SHADOW, etc..
 The values of the constants become:
 BRUSH  0
 PENCIL 4
 FILL   5
 SHADOW 6

 The constants may be literal integer, real or text. If they are no integer,
one must associate a value to them, with a semicolon and if no value is
associated, an integer is assigned starting from 0.
 Example:
 enum
  ZERO : "a0" ,
  ONE  : "a1" ,
  THREE ,
  FOUR : 3.15 ,
  FIVE
 /enum

 The values are:
 ZERO   "a0"
 ONE    "a1"
 THREE   0
 FOUR    3.15
 FIVE    1

 A more explicit example...
 enum READ:"r", WRITE:"w", APPEND:"a"
 file f = fopen("infile", READ)
 file g = fopen("outfile", WRITE)

 Use enums to make your programs more readable. This cost nothing: each name
will be replaced by the value in the generated Php or C++ target file...
 Of course this doesn't the generated code more readable ;-)

</pre>
<h4><a name="title14"></a>
  Scope</h4> <pre>

 The scoping rule are those used in most high-level programming languages.
They are not those of Php.
 They are four level of scopes: the global one, the one a a class, the one of
a function, and the one of the body of a control structure.
 Variables declared inside a scope are visible in any inner scope. They can't be
redeclared inside an inner scope.
 Variables declared in the global level are usable inside functions, and inside
body of control structures.
 This is the same for variables declared in the body a a class, and each class
is equivalent to a separate global level.

 Variables declared in the body of a function are usable inside the body of a
control structure, and a variable that is declared or visible inside the body of
a control structure is visible inside embedded control structures.
 You can't redeclare a variable where it is visible. You can only redeclare it
when its scope is closed, in successive functions of successive control
structures.

 The headers of control structures are considered as part of the outer scope and
the variables remains visible after the end of the block of statements.
 Example:
 for int i in 1..5
   print i
 /for
 print i
 This should display 1 2 3 4 5 6

 The scope of the let statement that ends a while control structure is a part of
the body of the structure, and one can use in this statement a variable declared
inside the body.

 Since the rules of Scriptol and Php are different, the global operator has to
be added to variables in most case, but this is entirely managed by the Scriptol
compiler and you don't have to deal with that at all.
 More on scopes in the chapter about classes.


 Conclusion
 If you already have used others programming languages, you have been surprised
by the differences with their control structure, and the powerful of the
Scriptol's ones. The if structure, not only merge the power of the if and the
switch case of C++ for example, but is allows to test cases of various types,
and to use different operators... Scriptol's control structures has been
designed for a more intuitive programming and for the human thought expressed
directly into programs.
</pre>
<br><br><table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_array.php" target="_self"><img src="simprev.gif" border="0"></a></td>
          <td width="105" height="40"><a href="en_array.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_struc.php" target="_self"><img src="simup.gif" border="0"></a></td>
          <td width="65" height="40"> <a href="en_struc.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_fun.php" target="_self"><img src="simnext.gif" border="0"></a></td>
          <td width="64" height="40"> <a href="en_fun.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_array.php" target="_self">VI Arrays and dict</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_fun.php" target="_self">VIII Functions</a>
</BODY>
</HTML>
