REBOL[
	Title:   "REBOL Extended Definitions"
	Date:    cvs-date "$Date: 1999/05/22 00:10:40 $"
	;Version: "$Revision: 1.1 $"
	Rights: "Copyright (C) REBOL Technologies 1997-1999"
]

set-user: func [
	"Create a default user.r preferences file."
	/local result ask-set
][
	result: trim ask "What is your email address? "
	if (length? result) > 0 [system/user/email: to-email result]

	result: trim ask "What is the name of your email server? "
	if (length? result) > 0 [system/schemes/default/host: result]

	if find/match ask "Do you want to set a proxy server? " "y" [

		result: trim ask "What is the proxy host name? "
		if (length? result) > 0 [system/schemes/default/proxy/host: result]

		result: trim ask "What is the proxy port number? "
		if (length? result) > 0 [system/schemes/default/proxy/port-id: to-integer result]
	]		
	if any [not exists? %user.r 
		find/match ask "Overwrite current user.r file? " "y"] [
			print "Creating user.r"
			write %user.r trim/auto reform [{
				REBOL [
				    Title: "User Preferences"
				    Date: } now {
				]

				set-net [}
					system/user/email
					system/schemes/default/host
					none
					system/schemes/default/proxy/host
					system/schemes/default/proxy/port-id
				{]
				}
			]
	]
]

if all [not exists? %user.r not system/options/quiet] [
	print "You have no user preferences file (user.r)."
	if find/match ask "Would you like to create one now? " "y" [
		set-user
	]
]

