// gksCursor.cpp : implementation of the CgksCursor class
//

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "gksCursor.h"
#include "OzGKS.h"
#include "OzFTN.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



CgksCursor::CgksCursor(long type, float* initialData, long handle, BOOL callback)
{
	m_type = type;
	m_extra = 0.0;
	m_handle = handle;
	m_drawing = FALSE;
	m_doCallback = callback;
	oznotbusy();	// remove any busy cursor
}

CgksCursor::~CgksCursor()
{
}



void CgksCursor::ButtonDown(CClientDC* pDC, CPoint point)
{
	m_screenPoint.RemoveAll();
	SetCursor(AfxGetApp()->LoadStandardCursor(IDC_CROSS));
}

void CgksCursor::ButtonUp(CClientDC* pDC, CPoint point)
{
	//SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));

	m_screenPoint.Add(point);
	this->GKScallback();
}

void CgksCursor::MouseMove(CClientDC* pDC, CPoint point)
{
	SetCursor(AfxGetApp()->LoadStandardCursor(IDC_CROSS));
}


// pass results back either to callback or one hit function

void CgksCursor::GKScallback()
{
	long num;
	static float* x;
	static float* y;

	num = m_screenPoint.GetSize();
	x = new float[num];
	y = new float[num];
	for (int i=0; i<num; i++)
	{
		xdev2w (&x[i], m_screenPoint[i].x); // screen to world coords
		ydev2w (&y[i], m_screenPoint[i].y);
	}
	if (m_doCallback)
	{
		OZCURSCB (&m_type, &num, x, y, &m_extra, &m_handle);
		delete [] x;
		delete [] y;
	}
	else
		GKScursorResults(num, x, y, m_extra);  // single call
}
