// OzGKS.h :  header file for graphics
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols


#ifndef __OZGIS_H__
#define __OZGIS_H__

#define	NUM_SEGS	100
#define PALSIZE 256
#define	NUM_FONTS	10

void GKSfatalError (char* text);
void MoveFloat (float* in, float* out, int num);



void  xw2dev (float x, long* xdev);
void  xdev2w (float* x, long xdev);
void  yw2dev (float y, long* ydev);
void  ydev2w (float* y, long ydev);
void  World2Pixels(float* xScale, float* yScale);

void	GKSinit (COzAPIDoc* pDoc);
void	GKSonDraw ( COzAPIDoc* pDoc, COzAPIView* pView, CDC* pDC, BOOL m_firstDraw);
void	GKSonPrint ( COzAPIDoc* pDoc, COzAPIView* pView, CDC* pDC, CPrintInfo *pInfo);
void	CreateGKSPalette(CPalette* gksPalette);
COLORREF GKScolour(int index);
void  GKSpen(CDC* pDC, int lineType, int lineWidth, int lineColour);
int	GKStext(CDC* pDC, float charHt, float charExpand, int horizontal, int vertical, 
				int font, int colour, BOOL ndc);
void  GKSbrush(CDC* pDC, int fillType, int fillColour);
void  GKStransf(CDC* pDC, float* viewport, float* window, BOOL clipOn);
void InitLocator (long newType, float* initial, long handle, BOOL doCallback);
void GKScursorResults(long num, float* x, float* y, float extra);
void GKSonLButtonDown(CPoint point);
void GKSonLButtonUp(CPoint point);
void GKSonMouseMove(CPoint point);

#endif
