
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: cobject.h,v 1.2 1999/07/06 19:48:08 stes Exp $
 */

#ifndef __CAOBJECT_HEADER__
#define __CAOBJECT_HEADER__

#include "stdio.h"

/*
 * stdio.h is necessary for FILE*
 * stuff like string.h and assert.h might give portability problems
 */

#include "config.h"		/* .h file names */
#include "stdlib.h"
#include "string.h"
#include "assert.h"
#include "limits.h"
#include "float.h"

#ifndef __OBJECT_INCLUDED__
#define __OBJECT_INCLUDED__
#include "Object.h"
#endif

typedef id obj_t;

typedef id *objseq_t;
typedef id obj_c;
typedef struct
  {
    id proto;
  }
obj_args;

#define obj_isvalue	0
#define obj_pervalue	1

@interface CAObject : Object
{
  STR _str;
}

+ (STR) cakitRevision;
- new;
+ str:(STR)aString;
+ int:(int)intValue;
+ stringValue:(const char *)aString;
- clone;
- copy;
- deepCopy;
- check;
- invalidate;
- release;

- set;
- (BOOL) sameClass:a;
- (BOOL) differentClass:a;
- errorSetEqual;
- checkSetEqual:a;
- checkSameClass:a;
- (BOOL) isKindOfSequence;
- class_vector;
- class_varspsrecdegsps_polynomial;
- class_varspsrecdegdns_polynomial;
- class_varspsexpdegsps_polynomial;
- class_varspsexpdegdns_polynomial;
- class_vardnsrecdegsps_polynomial;
- class_vardnsrecdegdns_polynomial;
- class_vardnsexpdegsps_polynomial;
- class_vardnsexpdegdns_polynomial;

- (STR) str;
- (const char *) stringValue;
- str:(STR)aString;
- (int) intValue;
- intValue:(int)i;
- asModp:(unsigned short)p;
- (BOOL) isFloatingPoint;
- asNumerical;
- (float) floatValue;
- floatValue:(float)f;
- asTotalFraction;
- asScalar;
- scalar:aScalar;
- asSymbol;
- symbol:aSymbol;

- (BOOL) isEqual:a;
- (BOOL) notEqual:a;

- (BOOL) inOrderedSet;
- (int) compare:b;
- (int) sign;
- (BOOL) isLess:a;
- (BOOL) isGreater:a;
- (BOOL) isLessEqual:a;
- (BOOL) isGreaterEqual:a;
- absValue;
- absValueSelf;

- (BOOL) inAdditiveSemiGroup;
- (BOOL) inAdditiveMonoid;
- (BOOL) inAdditiveGroup;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- zero;
- negate;
- negateSelf;
- _negate:(int)v;
- _negateSelf:(int)v;
- add:b;
- addSelf:b;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- subtract:b;
- subtractSelf:b;
- subtractSelfLeft:b;
- increment;
- incrementSelf;
- decrement;
- decrementSelf;
- multiplyIntValue:(int)b;
- multiplySelfIntValue:(int)b;
- double;
- doubleSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- quadruple;
- quadrupleSelf;
- divideIntValue:(int)b;
- divideSelfIntValue:(int)b;
- half;
- halfSelf;
- quarter;
- quarterSelf;

- (BOOL) commutes;
- (BOOL) commutesWith:b;
- (BOOL) inSemiGroup;
- (BOOL) inMonoid;
- (BOOL) inGroup;
- one;
- minusOne;
- (BOOL) isOne;
- (BOOL) notOne;
- (BOOL) isMinusOne;
- (BOOL) notMinusOne;
- square;
- squareSelf;
- _square:(int)w;
- _squareSelf:(int)w;
- multiply:b;
- multiplySelf:b;
- multiplySelfLeft:b;
- _multiply:b:(int)w;
- _multiplySelf:b:(int)w;
- power:(int)n;
- powerSelf:(int)n;
- inverse;
- inverseSelf;
- (BOOL) isUnit;
- (BOOL) notUnit;
- divide:b;
- divideSelf:b;
- divideSelfLeft:b;

- remainder:b quotient:(id *)q;
- remainderSelf:b quotient:(id*)q;
- remainder:b;
- remainderSelf:b;
- quotient:b;
- quotientSelf:b;

- (BOOL) inEuclideanDomain;
- (BOOL) isCoprime:b;
- (BOOL) notCoprime:b;
- (BOOL) isGcd:a:b;
- (BOOL) isLcm:a:b;
- gcd:b;
- gcdSelf:b;
- bezout:b gcd:(id *)gcd;
- lcm:b;
- lcmSelf:b;

- modulo:m;
- moduloSelf:m;
- multiply:b modulo:m;
- multiplySelf:b modulo:m;
- squareModulo:m;
- squareSelfModulo:m;
- power:(int)n modulo:m;
- powerSelf:(int)n modulo:m;
- inverseModulo:m;
- inverseSelfModulo:m;

- random;

- (int) characteristic;
- (BOOL) isCharacteristicZero;
- (BOOL) notCharacteristicZero;
- (BOOL) isCharacteristicTwo;
- (BOOL) notCharacteristicTwo;
- frobenius;
- frobeniusSelf;
- frobeniusInverse;
- frobeniusInverseSelf;
- (int) dimensionOverPrimeField;

- (BOOL) inRing;
- (BOOL) inIntegralDomain;
- (BOOL) inField;
- (BOOL) inFieldOfFractions;
- _addSquare:(int)v:b:(int)w;
- _addSelfSquare:(int)v:b:(int)w;
- _add:(int)v:B multiply:b:(int)w;
- _addSelf:(int)v:B multiply:b:(int)w;
- _multiply:a:(int)v add:B:(int)w;
- _multiplySelf:a:(int)v add:B:(int)w;
- _multiply:a:(int)v add:B multiply:b:(int)w;
- _multiplySelf:a:(int)v add:B multiply:b:(int)w;
- _multiply:a:(int)v divide:d;
- _multiplySelf:a:(int)v divide:d;
- _multiply:a:(int)v add:B multiply:b:(int)w divide:d;
- _multiplySelf:a:(int)v add:B multiply:b:(int)w divide:d;

- scalarZero;
- scalarContent;
- divideScalarContent;
- divideSelfScalarContent;
- multiplyScalar:s;
- multiplySelfScalar:s;
- _multiplyScalar:s:(int)v;
- _multiplySelfScalar:s:(int)v;
- divideScalar:s;
- divideSelfScalar:s;
- addScalar:s;
- addSelfScalar:s;
- subtractScalar:s;
- subtractSelfScalar:s;
- _add:(int)v:B multiplyScalar:b:(int)w;
- _addSelf:(int)v:B multiplyScalar:b:(int)w;
- _multiplyScalar:a:(int)v add:B:(int)w;
- _multiplySelfScalar:a:(int)v add:B:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- _multiplyScalar:a:(int)v divideScalar:d;
- _multiplySelfScalar:a:(int)v divideScalar:d;
- _multiplyScalar:a:(int)v add:B multiplyScalar:b:(int)w divideScalar:d;
- _multiplySelfScalar:a:(int)v add:B multiplyScalar:b:(int)w divideScalar:d;
- subtractSelf:r multiplyScalar:q;
- multiplySelfScalar:p subtract:r multiplyScalar:q divideScalar:d;
- multiplySelfScalar:p divideScalar:d;
- multiplyCoefficient:s;
- multiplySelfCoefficient:s;
- _multiplyCoefficient:s:(int)v;
- _multiplySelfCoefficient:s:(int)v;
- divideCoefficient:s;
- divideSelfCoefficient:s;
- _add:(int)v:B multiplyCoefficient:b:(int)w;
- _addSelf:(int)v:B multiplyCoefficient:b:(int)w;
- _multiplyCoefficient:a:(int)v add:B:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B:(int)w;
- _multiplyCoefficient:a:(int)v add:B multiplyCoefficient:b:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B multiplyCoefficient:b:(int)w;
- _multiplyCoefficient:a:(int)v divideCoefficient:d;
- _multiplySelfCoefficient:a:(int)v divideCoefficient:d;
- _multiplyCoefficient:a:(int)v add:B multiplyCoefficient:b:(int)w divideCoefficient:d;
- _multiplySelfCoefficient:a:(int)v add:B multiplyCoefficient:b:(int)w divideCoefficient:d;
- multiplyTerm:s;
- multiplySelfTerm:s;
- _multiplyTerm:s:(int)v;
- _multiplySelfTerm:s:(int)v;
- divideTerm:s;
- divideSelfTerm:s;
- _add:(int)v:B multiplyTerm:b:(int)w;
- _addSelf:(int)v:B multiplyTerm:b:(int)w;
- _multiplyCoefficient:a:(int)v add:B multiplyTerm:b:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B multiplyTerm:b:(int)w;
- addSelf:r multiplyTerm:q;
- subtractSelf:r multiplyTerm:q;
- multiplySelfCoefficient:p subtract:r multiplyTerm:q;
- multiplyMonomial:s;
- multiplySelfMonomial:s;
- _multiplyMonomial:s:(int)v;
- _multiplySelfMonomial:s:(int)v;
- divideMonomial:s;
- divideSelfMonomial:s;
- _add:(int)v:B multiplyMonomial:b:(int)w;
- _addSelf:(int)v:B multiplyMonomial:b:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyMonomial:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyMonomial:b:(int)w;
- addSelf:r multiplyMonomial:q;
- subtractSelf:r multiplyMonomial:q;
- multiplySelfScalar:p subtract:r multiplyMonomial:q;

- (BOOL) printsLeadingSign;
- (BOOL) printsSum;
- (BOOL) printsProduct;
- printOn:(IOD)aFile;
@end

#endif /* __CAOBJECT_HEADER__ */
 
