
/*
 * Computer Algebra Kit (c) 1994,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: ccltn.h,v 1.8 1998/08/29 10:22:52 stes Exp $
 */

#ifndef __CACOLLECTION_HEADER__
#define __CACOLLECTION_HEADER__

#include "cobject.h"

typedef id *mmbs_t;

typedef struct cltn {
  int count;
  int capacity;
  mmbs_t members;
} *cltn_t;

@interface CACollection : CAObject
{
  struct cltn value;
}

+ new;
+ new:(unsigned)aCapacity;
- empty;
- copy;
- deepCopy;
- clear;

- (BOOL) isEqual:aCollection;
- (unsigned) hash;
- (BOOL) isEmpty;
- (BOOL) notEmpty;
- (unsigned) size;

- add:anObject;
- addIfAbsent:anObject;
- at:(unsigned)i insert:anObject;

- removeLast;
- removeAt:(int)i;
- remove:anObject;

- at:(unsigned)i put:anObject;
- swapElementsAt:(int)i:(int)j;

- eachElement;
- eachElementReversed;
- at:(unsigned)i;
- (float) floatValueAt:(int)i;
- (int) intValueAt:(int)i;
- lastElement;
- (int) offsetOf:anObject;

- merge:aCltn;
- union:aCltn;

- printOn:(IOD)aFile;
@end

#endif				/* __CACOLLECTION_HEADER__ */

