
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: fraction.h,v 1.5 1998/06/14 12:23:59 stes Exp $
 */

#ifndef __CAFRACTION_HEADER__
#define __CAFRACTION_HEADER__

#include "cobject.h"

@interface Fraction : CAObject
{
  id numerator;
  id denominator;
}

+ totalFraction:aNumerator;
+ numerator:aNumerator denominator:aDenominator;
- copy;
- deepCopy;
- clear;

- numerator;
- denominator;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (int) compare:b;

- asNumerical;
- asModp:(unsigned short)p;
- asIntegral;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;

- one;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- square;
- inverse;
- multiply:b;
- divide:b;
- power:(int)n;

- intValue:(int)intValue;
- (int) intValue;
- multiplyIntValue:(int)intValue;
- divideIntValue:(int)intValue;

- (BOOL) printsLeadingSign;
- (BOOL) printsSum;
- (BOOL) printsProduct;
- printOn:(IOD)aFile;
@end

#endif				/* __CAFRACTION_HEADER__ */

