#ifndef _WINIOCTL_H
#define _WINIOCTL_H
#ifdef __cplusplus
extern "C" {
#endif
#define HIST_NO_OF_BUCKETS 24
#define HISTOGRAM_BUCKET_SIZE sizeof(HISTOGRAM_BUCKET)
#define DISK_HISTOGRAM_SIZE sizeof(DISK_HISTOGRAM)
#define CTL_CODE(t,f,m,a) (((t)<<16)|((a)<<14)|((f)<<2)|(m))
#define IOCTL_DISK_BASE FILE_DEVICE_DISK
#define IOCTL_DISK_GET_DRIVE_GEOMETRY CTL_CODE(IOCTL_DISK_BASE,0,METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_GET_PARTITION_INFO CTL_CODE(IOCTL_DISK_BASE,1,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_SET_PARTITION_INFO CTL_CODE(IOCTL_DISK_BASE,2,METHOD_BUFFERED,FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_DRIVE_LAYOUT	CTL_CODE(IOCTL_DISK_BASE,3,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_SET_DRIVE_LAYOUT CTL_CODE(IOCTL_DISK_BASE,4,METHOD_BUFFERED,FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_DISK_VERIFY CTL_CODE(IOCTL_DISK_BASE,5,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_FORMAT_TRACKS CTL_CODE(IOCTL_DISK_BASE,6,METHOD_BUFFERED,FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_DISK_REASSIGN_BLOCKS CTL_CODE(IOCTL_DISK_BASE,7,METHOD_BUFFERED,FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_DISK_PERFORMANCE CTL_CODE(IOCTL_DISK_BASE,8,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_IS_WRITABLE CTL_CODE(IOCTL_DISK_BASE,9,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_LOGGING CTL_CODE(IOCTL_DISK_BASE,10,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_FORMAT_TRACKS_EX CTL_CODE(IOCTL_DISK_BASE,11,METHOD_BUFFERED,FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_DISK_HISTOGRAM_STRUCTURE CTL_CODE(IOCTL_DISK_BASE,12,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_HISTOGRAM_DATA CTL_CODE(IOCTL_DISK_BASE,13,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_HISTOGRAM_RESET CTL_CODE(IOCTL_DISK_BASE,14,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_REQUEST_STRUCTURE CTL_CODE(IOCTL_DISK_BASE,15,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_REQUEST_DATA CTL_CODE(IOCTL_DISK_BASE,16,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_CHECK_VERIFY CTL_CODE(IOCTL_DISK_BASE,0x200,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_MEDIA_REMOVAL CTL_CODE(IOCTL_DISK_BASE,0x201,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_EJECT_MEDIA CTL_CODE(IOCTL_DISK_BASE,0x202,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_LOAD_MEDIA CTL_CODE(IOCTL_DISK_BASE,0x203,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_RESERVE CTL_CODE(IOCTL_DISK_BASE,0x204,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_RELEASE CTL_CODE(IOCTL_DISK_BASE,0x205,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_FIND_NEW_DEVICES CTL_CODE(IOCTL_DISK_BASE,0x206,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_REMOVE_DEVICE CTL_CODE(IOCTL_DISK_BASE,0x207,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_GET_MEDIA_TYPES CTL_CODE(IOCTL_DISK_BASE,0x300,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define DEVICE_TYPE DWORD
#define FILE_DEVICE_BEEP	1
#define FILE_DEVICE_CD_ROM	2
#define FILE_DEVICE_CD_ROM_FILE_SYSTEM	3
#define FILE_DEVICE_CONTROLLER	4
#define FILE_DEVICE_DATALINK	5
#define FILE_DEVICE_DFS	6
#define FILE_DEVICE_DISK	7
#define FILE_DEVICE_DISK_FILE_SYSTEM	8
#define FILE_DEVICE_FILE_SYSTEM	9
#define FILE_DEVICE_INPORT_PORT	10
#define FILE_DEVICE_KEYBOARD	11
#define FILE_DEVICE_MAILSLOT	12
#define FILE_DEVICE_MIDI_IN	13
#define FILE_DEVICE_MIDI_OUT	14
#define FILE_DEVICE_MOUSE	15
#define FILE_DEVICE_MULTI_UNC_PROVIDER 16
#define FILE_DEVICE_NAMED_PIPE	17
#define FILE_DEVICE_NETWORK	18
#define FILE_DEVICE_NETWORK_BROWSER	19
#define FILE_DEVICE_NETWORK_FILE_SYSTEM	20
#define FILE_DEVICE_NULL	21
#define FILE_DEVICE_PARALLEL_PORT	22
#define FILE_DEVICE_PHYSICAL_NETCARD	23
#define FILE_DEVICE_PRINTER	24
#define FILE_DEVICE_SCANNER	25
#define FILE_DEVICE_SERIAL_MOUSE_PORT	26
#define FILE_DEVICE_SERIAL_PORT	27
#define FILE_DEVICE_SCREEN	28
#define FILE_DEVICE_SOUND	29
#define FILE_DEVICE_STREAMS	30
#define FILE_DEVICE_TAPE	31
#define FILE_DEVICE_TAPE_FILE_SYSTEM	32
#define FILE_DEVICE_TRANSPORT	33
#define FILE_DEVICE_UNKNOWN	34
#define FILE_DEVICE_VIDEO	35
#define FILE_DEVICE_VIRTUAL_DISK	36
#define FILE_DEVICE_WAVE_IN	37
#define FILE_DEVICE_WAVE_OUT	38
#define FILE_DEVICE_8042_PORT	39
#define FILE_DEVICE_NETWORK_REDIRECTOR	40
#define FILE_DEVICE_BATTERY	41
#define FILE_DEVICE_BUS_EXTENDER	41
#define PARTITION_ENTRY_UNUSED	0
#define PARTITION_FAT_12	1
#define PARTITION_XENIX_1	2
#define PARTITION_XENIX_2	3
#define PARTITION_FAT_16	4
#define PARTITION_EXTENDED	5
#define PARTITION_HUGE	6
#define PARTITION_IFS	7
#define PARTITION_PREP	0x41
#define PARTITION_UNIX	0x63
#define PARTITION_NTFT	128
#define VALID_NTFT	0xC0
#define METHOD_BUFFERED	0
#define METHOD_IN_DIRECT	1
#define METHOD_OUT_DIRECT	2
#define METHOD_NEITHER	3
#define IOCTL_SERIAL_LSRMST_INSERT	CTL_CODE(FILE_DEVICE_SERIAL_PORT,31,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define SERIAL_LSRMST_ESCAPE	0
#define SERIAL_LSRMST_LSR_DATA	1
#define SERIAL_LSRMST_LSR_NODATA	2
#define SERIAL_LSRMST_MST	3
#define FILE_ANY_ACCESS	0
#define FILE_READ_ACCESS	1
#define FILE_WRITE_ACCESS	2
#define DISK_LOGGING_START	0
#define DISK_LOGGING_STOP	1
#define DISK_LOGGING_DUMP	2
#define DISK_BINNING	3
#define FSCTL_LOCK_VOLUME	CTL_CODE(FILE_DEVICE_FILE_SYSTEM,6,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_UNLOCK_VOLUME	CTL_CODE(FILE_DEVICE_FILE_SYSTEM,7,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_DISMOUNT_VOLUME	CTL_CODE(FILE_DEVICE_FILE_SYSTEM,8,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_MOUNT_DBLS_VOLUME	CTL_CODE(FILE_DEVICE_FILE_SYSTEM,13,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_GET_COMPRESSION	CTL_CODE(FILE_DEVICE_FILE_SYSTEM,15,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_SET_COMPRESSION	CTL_CODE(FILE_DEVICE_FILE_SYSTEM,16,METHOD_BUFFERED,FILE_READ_DATA|FILE_WRITE_DATA)
#define FSCTL_READ_COMPRESSION	CTL_CODE(FILE_DEVICE_FILE_SYSTEM,17,METHOD_NEITHER,FILE_READ_DATA)
#define FSCTL_WRITE_COMPRESSION	CTL_CODE(FILE_DEVICE_FILE_SYSTEM,18,METHOD_NEITHER,FILE_WRITE_DATA)
typedef WORD BAD_TRACK_NUMBER,*PBAD_TRACK_NUMBER;
typedef enum _BIN_TYPES {RequestSize,RequestLocation} BIN_TYPES;
typedef struct _BIN_RANGE {
	LARGE_INTEGER StartValue;
	LARGE_INTEGER Length;
} BIN_RANGE,*PBIN_RANGE;
typedef struct _BIN_COUNT {
	BIN_RANGE BinRange;
	DWORD BinCount;
} BIN_COUNT,*PBIN_COUNT;
typedef struct _BIN_RESULTS {
	DWORD NumberOfBins;
	BIN_COUNT BinCounts[1];
} BIN_RESULTS,*PBIN_RESULTS;
typedef enum _MEDIA_TYPE {
	Unknown,
	F5_1Pt2_512,
	F3_1Pt44_512,
	F3_2Pt88_512,
	F3_20Pt8_512,
	F3_720_512,
	F5_360_512,
	F5_320_512,
	F5_320_1024,
	F5_180_512,
	F5_160_512,
	RemovableMedia,
	FixedMedia
} MEDIA_TYPE;
typedef struct _DISK_GEOMETRY {
	LARGE_INTEGER Cylinders;
	MEDIA_TYPE MediaType;
	DWORD TracksPerCylinder;
	DWORD SectorsPerTrack;
	DWORD BytesPerSector;
} DISK_GEOMETRY;
typedef struct _DISK_PERFORMANCE {
        LARGE_INTEGER BytesRead;
        LARGE_INTEGER BytesWritten;
        LARGE_INTEGER ReadTime;
        LARGE_INTEGER WriteTime;
        DWORD ReadCount;
        DWORD WriteCount;
        DWORD QueueDepth;
} DISK_PERFORMANCE;
typedef struct _DISK_RECORD {
	LARGE_INTEGER ByteOffset;
	LARGE_INTEGER StartTime;
	LARGE_INTEGER EndTime;
	PVOID VirtualAddress;
	DWORD NumberOfBytes;
	BYTE DeviceNumber;
	BOOLEAN ReadRequest;
} DISK_RECORD,*PDISK_RECORD;
typedef struct _DISK_LOGGING {
	BYTE Function;
	PVOID BufferAddress;
	DWORD BufferSize;
} DISK_LOGGING,*PDISK_LOGGING;
typedef struct _FORMAT_PARAMETERS {
	MEDIA_TYPE MediaType;
	DWORD StartCylinderNumber;
	DWORD EndCylinderNumber;
	DWORD StartHeadNumber;
	DWORD EndHeadNumber;
} FORMAT_PARAMETERS,*PFORMAT_PARAMETERS;
typedef struct _FORMAT_EX_PARAMETERS {
	MEDIA_TYPE MediaType;
	DWORD StartCylinderNumber;
	DWORD EndCylinderNumber;
	DWORD StartHeadNumber;
	DWORD EndHeadNumber;
	WORD FormatGapLength;
	WORD SectorsPerTrack;
	WORD SectorNumber[1];
} FORMAT_EX_PARAMETERS,*PFORMAT_EX_PARAMETERS;
typedef struct _HISTOGRAM_BUCKET {
	DWORD Reads;
	DWORD Writes;
} HISTOGRAM_BUCKET,*PHISTOGRAM_BUCKET;
typedef struct _DISK_HISTOGRAM {
	LARGE_INTEGER DiskSize;
	LARGE_INTEGER Start;
	LARGE_INTEGER End;
	LARGE_INTEGER Average;
	LARGE_INTEGER AverageRead;
	LARGE_INTEGER AverageWrite;
	DWORD Granularity;
	DWORD Size;
	DWORD ReadCount;
	DWORD WriteCount;
	PHISTOGRAM_BUCKET Histogram;
} DISK_HISTOGRAM,*PDISK_HISTOGRAM;
typedef struct _PARTITION_INFORMATION {
	LARGE_INTEGER StartingOffset;
	LARGE_INTEGER PartitionLength;
	DWORD HiddenSectors;
	DWORD PartitionNumber;
	BYTE PartitionType;
	BOOLEAN BootIndicator;
	BOOLEAN RecognizedPartition;
	BOOLEAN RewritePartition;
} PARTITION_INFORMATION,*PPARTITION_INFORMATION;
typedef struct _DRIVE_LAYOUT_INFORMATION {
	DWORD PartitionCount;
	DWORD Signature;
	PARTITION_INFORMATION PartitionEntry[1];
} DRIVE_LAYOUT_INFORMATION;
typedef struct _PERF_BIN {
	DWORD NumberOfBins;
	DWORD TypeOfBin;
	BIN_RANGE BinsRanges[1];
} PERF_BIN,*PPERF_BIN;
typedef struct _PREVENT_MEDIA_REMOVAL {
	BOOLEAN PreventMediaRemoval;
} PREVENT_MEDIA_REMOVAL,*PPREVENT_MEDIA_REMOVAL;
typedef struct _REASSIGN_BLOCKS {
	WORD Reserved;
	WORD Count;
	DWORD BlockNumber[1];
} REASSIGN_BLOCKS,*PREASSIGN_BLOCKS;
typedef struct _SET_PARTITION_INFORMATION {
	BYTE PartitionType;
} SET_PARTITION_INFORMATION,*PSET_PARTITION_INFORMATION;
typedef struct _VERIFY_INFORMATION {
	LARGE_INTEGER StartingOffset;
	DWORD Length;
} VERIFY_INFORMATION,*PVERIFY_INFORMATION;
#define IsRecognizedPartition(t) (((t&PARTITION_NTFT)&&((t&~0xC0)==PARTITION_FAT_12))||\
	((t&PARTITION_NTFT)&&((t&~0xC0)==PARTITION_FAT_16))||\
	((t&PARTITION_NTFT)&&((t&~0xC0)==PARTITION_IFS))||\
	((t&PARTITION_NTFT)&&((t&~0xC0)==PARTITION_HUGE))||\
	((t&~PARTITION_NTFT)==PARTITION_FAT_12)||\
	((t&~PARTITION_NTFT)==PARTITION_FAT_16)||\
	((t&~PARTITION_NTFT)==PARTITION_IFS)||\
	((t&~PARTITION_NTFT)==PARTITION_HUGE))
#ifdef __cplusplus
}
#endif
#endif
