#ifndef __WORD_LINKAGE_H

#define __WORD_LINKAGE_H

class GCS_CLASS_DECL WordLinkage
{
public:
	CString strWordL;
	CString strWordC;
	CString strWordR;
	int nPosL;
	int nPosR;
public:
	WordLinkage(CString LinkL, CString LinkC, CString LinkR, int l, int r) 
	{
		strWordL = LinkL;
		strWordC = LinkC;
		strWordR = LinkR;
		nPosL = l;
		nPosR = r;
	}

	WordLinkage(const WordLinkage &WL) 
	{
		strWordL = WL.strWordL;
		strWordC = WL.strWordC;
		strWordR = WL.strWordR;
		nPosL = WL.nPosL;
		nPosR = WL.nPosR;
	}

	WordLinkage() 
	{
	}

	BOOL operator < ( const WordLinkage &WL) const
	{
		return (nPosL < WL.nPosL) ? TRUE : FALSE;
	}

	BOOL operator == ( const WordLinkage &WL) const
	{
		return (nPosL == WL.nPosL) ? TRUE : FALSE;
	}
};

int GCS_CLASS_DECL FindLinkage(vector<WordLinkage> *vecWordLinks, CString strLinkType, LPCSTR const cstrObjList[], int nNumObjList, BOOL bScanLeft, BOOL bScanRight, BOOL &bFoundOnLeft, int &nMatchedWord, int nFirstLink = 0, int nLastLink = -1);
int GCS_CLASS_DECL CompareLinkWord(WordLinkage *WordLink, LPCSTR cstrObjList[], int nNumObjList, BOOL bScanLeft, BOOL bScanRight);
CString GCS_CLASS_DECL BuildParameter(const CString &strOrig);
int GCS_CLASS_DECL FindChainedLinkage(vector<WordLinkage> *vecWordLinks, int nWord, CString strLinkType, BOOL bPlusLink = TRUE);
int GCS_CLASS_DECL FindFullLink(vector<WordLinkage> *vecWordLinks, CString strLinkType, LPCSTR const cstrObjListL[], int nNumObjListL, LPCSTR cstrObjListR[], int nNumObjListR, BOOL bReturnLinkage = FALSE);
CString GCS_CLASS_DECL PrintLinkages(vector<WordLinkage> *vecWordLinks);


#endif