// GCSTRACE() works like TRACE() in MFC and is a direct replacment, however, 
// it writes traces to "ErrorLog.txt" as well as the trace window.
void GCS_CLASS_DECL GCSTrace(LPCTSTR lpszFormat, ...);

#ifdef _DEBUG
#define GCSTRACE	GCSTrace
#else
#define GCSTRACE	(void)0
#endif

void InitGCSMalloc(size_t max);
void *GCSMalloc (size_t size);
void GCSFree(void *block);
void KillGCSMalloc(void);

inline void memset_I(void const *dest, const int c, const size_t count)
{
 _asm {
	mov 	ecx, count
	jecxz	memset_I_1
	mov		eax, c
	mov		ah, al
	mov		edx, eax
	ror		eax, 0x10
	mov		ax, dx
	mov		edi, dest
	mov		edx, edi
	neg		dx
	and		edx, 3
	jz		memset_I_2
	cmp		ecx, edx
	jb		memset_I_3
	sub		ecx, edx
	xchg	edx, ecx
	rep		stosb
	mov		ecx, edx
memset_I_2:
	mov		edx, ecx
	shr		ecx, 2
	rep		stosd
	mov		ecx, edx
memset_I_3:
	and		ecx, 3
	rep		stosb
memset_I_1:
 }
}


void GCS_CLASS_DECL MemCpyFl(void* pDest, const void* pData, UINT dwByteCount);
inline void GCSmemcpy(void *dest, const void *src, size_t size)
{
#ifdef _USE_FPU_OPT
	MemCpyFl(dest, src, size);
#else
	memcpy(dest, src, size);
#endif
}

void GCS_CLASS_DECL MemSetFl(void* pDest, unsigned char val, UINT dwByteCount);
inline void GCSmemset(void *dest, unsigned char val, size_t size)
{
#ifdef _USE_FPU_OPT
	MemSetFl(dest, val, size);
#else
	memset_I(dest, val, size);
#endif
}

