#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "htmlhelp.h"
#include "header.h"
char szHelpPath[256] ;
int HelpMode ;
extern HWND hwndFrame ;
static char htmlFile[256] ;
HMODULE htmlLib ;
static FARPROC HelpFunc ;
int FindColFile(char *buf)
{
   HANDLE h ;
   WIN32_FIND_DATA str ;
   char findstr[256] ;
   strcpy(findstr,buf) ;
   strcat(findstr,"*.col") ;
   h = FindFirstFile(findstr,&str) ;
   if (h != INVALID_HANDLE_VALUE) {
      CloseHandle(h) ;
      strcat(buf,str.cFileName) ;
      return TRUE ;
   }
   return FALSE ;
}
int MSDNHelpFile(char *buf)
{
   HKEY key ;
   if (HelpMode > HELP_MSDN)
      return FALSE ;
   if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,"software\\microsoft\\visualstudio",
         0,KEY_READ,&key) == ERROR_SUCCESS) {
      int index = 0 ;
      char name[1024] ;
      int size = 256 ;
      FILETIME t ;
      int rv ;
      do {
         memset(name,0,1024) ;
         size = 256 ;
         rv = RegEnumKeyEx(key,index++,name,&size,0,NULL,NULL,&t) ;
         if (rv == ERROR_SUCCESS || rv == ERROR_MORE_DATA) {
            HKEY key2 ;
            strcat(name,"\\setup") ;
            if (RegOpenKeyEx(key,name,0,KEY_READ, &key2) == ERROR_SUCCESS) {
               int index = 0 ;
               int rv ;
               do {
                  memset(name,0,1024) ;
                  size = 256 ;
                  rv = RegEnumKeyEx(key2,index++,name,&size,0,NULL,NULL,&t) ;
                  if (rv == ERROR_SUCCESS || rv == ERROR_MORE_DATA) {
                     if (!strncmp(name,"MSDN Library",12)) {
                        HKEY key3 ;
                        if (RegOpenKeyEx(key2,name,0,KEY_READ, &key3) == ERROR_SUCCESS) {
                           size = 256 ;
                           if (RegQueryValueEx(key3,"ProductDir",0,NULL,buf,&size) == ERROR_SUCCESS) {
                              RegCloseKey(key3) ;
                              RegCloseKey(key2) ;
                              RegCloseKey(key) ;
                              if (buf[strlen(buf)-1] != '\\')
                                 strcat(buf,"\\") ;
                              return FindColFile(buf) ;
                           }
                           RegCloseKey(key3) ;
                        }
                     }
                  }
               } while (rv == ERROR_SUCCESS || rv == ERROR_MORE_DATA) ;
               RegCloseKey(key2) ;
            }
         }
      } while (rv == ERROR_SUCCESS || rv == ERROR_MORE_DATA) ;
      RegCloseKey(key) ;
   }
   return FALSE ;
}
int PlatformSDKHelpFile(char *buf)
{
   HKEY key ;
   int size = 256 ;

   if (HelpMode > HELP_SDK)
      return FALSE ;
   if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,"software\\microsoft\\platformsdk\\directories",
         0,KEY_READ,&key) == ERROR_SUCCESS) {
      if (RegQueryValueEx(key,"Install Dir",0,NULL,buf,&size) == ERROR_SUCCESS) {
         RegCloseKey(key) ;
         if (buf[strlen(buf)-1] != '\\')
            strcat(buf,"\\") ;
         strcat(buf,"help\\platsdk.col") ;
         return TRUE ;
      }
      RegCloseKey(key) ;
   }
   return FALSE ;

}
int SpecifiedHelpFile(char *buf)
{
   FILE *fil = fopen(szHelpPath,"r") ;
   if (fil) {
      strcpy(buf,szHelpPath) ;
      fclose(fil) ;
      return TRUE ;
   }
   return FALSE ;
}
int InitHelp(void)
{
   if (htmlLib)
      return TRUE ;
   strcpy(szHelpPath,(char *)ProfileToString("HELP PATH","")) ;
   HelpMode = ProfileToInt("HelpMode",HELP_MSDN) ;
   if (!MSDNHelpFile(htmlFile))
      if (!PlatformSDKHelpFile(htmlFile))
         if (!SpecifiedHelpFile(htmlFile))
            return FALSE ;
   htmlLib = LoadLibrary("hhctrl.ocx") ;
   if (htmlLib) {
      HelpFunc = GetProcAddress(htmlLib,"HtmlHelpA") ;
      return TRUE ;
   }

   return FALSE ;
}
void RundownHelp(void)
{
   if (htmlLib) {
      FreeLibrary(htmlLib) ;
      htmlLib = 0 ;
   }
      StringToProfile("HelpPath",szHelpPath) ;
      IntToProfile("HelpMode", HelpMode) ;
}
int ShowHelp(char *string)
{
   HH_AKLINK hl ;
   HMODULE lib ;
   if (!InitHelp())
      return FALSE ;
   if (HelpMode == HELP_SPECIFIED && (strstr(htmlFile,".HLP") || strstr(htmlFile,".hlp"))) {
      WinHelp(hwndFrame,htmlFile,HELP_KEY,(DWORD)string) ;
      return TRUE ;
   }
   HelpFunc(GetDesktopWindow(),htmlFile,HH_DISPLAY_TOPIC, 0) ;
   hl.cbStruct = sizeof(HH_AKLINK) ;
   hl.fReserved = FALSE ;
   hl.pszKeywords = string ;
   hl.pszUrl = NULL ;
   hl.pszMsgText = NULL ;
   hl.pszMsgTitle = NULL ;
   hl.pszWindow = NULL ;
   hl.fIndexOnFail = TRUE ;
   HelpFunc(GetDesktopWindow(),htmlFile,HH_KEYWORD_LOOKUP, &hl) ;
   return TRUE ;
}