#include <windows.h>                             
#include <commctrl.h>
#include <stdio.h>
#include "header.h"
#include "dir.h"

extern HWND hwndFrame, hwndClient, hwndProject, hwndRegister, hwndError, hwndWatch ;
extern HINSTANCE hInstance ;
extern int docking ;

HWND hwndTab ;
static HWND hwndTabCtrl ;
static char szTabClassName[] = "xccTabClass" ;
static char szTabTitle[] = "" ;
static HFONT tabBoldFont, tabNormalFont ;
static char *nameTags[] = { "Project", "Register" } ;
static HBITMAP projBitmap, regsBitmap ;
static HBITMAP *bitmaps[] = { &projBitmap, &regsBitmap } ;
static HWND hwndCtrl ;

static LOGFONT Boldfontdata = {
   14,0,0,0,FW_BOLD,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
   CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_DONTCARE,
   "Helvetica"
} ;
static LOGFONT Normalfontdata = {
   14,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
   CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_DONTCARE,
   "Helvetica"
} ;
void GetRelativeRect( HWND parent, HWND self, RECT *r)
{
   POINT pt ;
   GetWindowRect(self,r) ;
   pt.x = r->left ;
   pt.y = r->top ;
   ScreenToClient(parent,&pt) ;
   r->bottom = r->bottom- r->top + pt.y ;
   r->right = r->right - r->left + pt.x ;
   r->left = pt.x ;
   r->top = pt.y ;
}
void GetTabRect ( RECT *rect )
{
   GetClientRect(hwndTab,rect) ;
   SendMessage(hwndCtrl,LCF_ADJUSTRECT,0,(LPARAM)rect) ;
   TabCtrl_AdjustRect(hwndTabCtrl,FALSE, rect) ;
}
LRESULT  CALLBACK _export TabWndProc( HWND hwnd, UINT iMessage, WPARAM wParam,
                                 LPARAM lParam )
{
   static int selected, sizingbottom ;
   RECT r, *pr ;
   TC_ITEM tie ;
   NMHDR *h ;
   DRAWITEMSTRUCT *dr ;
   HFONT font ;
   HBITMAP hbmp ;
   HDC hMemDC ;
   HDWP deferstruct ;
   switch(iMessage) {
      case WM_SYSCOMMAND:
         if (wParam == SC_CLOSE) {
            PostMessage(hwnd,WM_CLOSE,0,0) ;
            return 0 ;
         }
         break ;
		case WM_NOTIFY:
         h = (NMHDR *)lParam ;
         switch(h->code) {
            case TCN_SELCHANGE:
               switch(selected = TabCtrl_GetCurSel(hwndTabCtrl)) {
                  case 0:
                     ShowWindow(hwndRegister, SW_HIDE) ;
                     ShowWindow(hwndProject, SW_SHOW) ;
                     break ;
                  case 1:
                     ShowWindow(hwndProject, SW_HIDE) ;
                     ShowWindow(hwndRegister, SW_SHOW) ;
                     break ;
               }
         }
			break ;
      case WM_DRAWITEM:
         dr = (DRAWITEMSTRUCT *)lParam ;
         if (dr->itemState & ODS_SELECTED)
            font = tabBoldFont ;
         else
            font = tabNormalFont ;
         hMemDC = CreateCompatibleDC(dr->hDC) ;
         hbmp = SelectObject(hMemDC,*bitmaps[dr->itemID]) ;
         BitBlt(dr->hDC,dr->rcItem.left+2,dr->rcItem.top+2,16,16,hMemDC,0,0,SRCCOPY) ;
         font = SelectObject(dr->hDC,font) ;
         TextOut(dr->hDC,dr->rcItem.left+18,dr->rcItem.top+2,nameTags[dr->itemID],strlen(nameTags[dr->itemID])) ;
         font = SelectObject(dr->hDC,font) ;
         SelectObject(dr->hDC,hbmp) ;
         DeleteDC(hMemDC) ;
         break ;
		case WM_CREATE :
         hwndTab = hwnd ;
         GetClientRect(hwnd,&r) ;
         hwndCtrl = CreateControlWindow(hwndFrame,hwnd,&r,FALSE) ;
         GetClientRect(hwnd,&r) ;
         SendMessage(hwndCtrl,LCF_ADJUSTRECT,0,(LPARAM)&r) ;
         hwndTabCtrl = CreateWindow(WC_TABCONTROL, 0,
            WS_CHILD + WS_CLIPSIBLINGS + WS_VISIBLE + TCS_OWNERDRAWFIXED + TCS_FOCUSNEVER, 
            r.left,r.top,r.right-r.left,r.bottom-r.top,
            hwndCtrl, 0 ,hInstance,0)  ;
         tabBoldFont = CreateFontIndirect(&Boldfontdata) ;
         tabNormalFont = CreateFontIndirect(&Normalfontdata) ;
         projBitmap = LoadBitmap(hInstance, "ID_PROJBMP") ;
         regsBitmap = LoadBitmap(hInstance, "ID_REGSBMP") ;
         ChangeBitmapColor(projBitmap,0x00ffff,GetSysColor(COLOR_3DFACE)) ;
         ChangeBitmapColor(regsBitmap,0x00ffff,GetSysColor(COLOR_3DFACE)) ;
//         SendMessage(hwndTabCtrl,WM_SETFONT,(WPARAM)tabBoldFont,0) ;
         CreateProjectWindow(1, hwndCtrl) ;
         CreateRegisterWindow(TRUE, hwndCtrl) ;
         tie.mask = TCIF_TEXT | TCIF_IMAGE ;
         tie.iImage = -1 ;
         tie.pszText  = nameTags[0] ;
         TabCtrl_InsertItem(hwndTabCtrl,0, &tie) ;
         tie.mask = TCIF_TEXT | TCIF_IMAGE ;
         tie.iImage = -1 ;
         tie.pszText  = nameTags[1] ;
         TabCtrl_InsertItem(hwndTabCtrl,1, &tie) ;
         ShowWindow(hwndRegister,SW_HIDE) ;
         PostMessage(hwndFrame,WM_REDOSIZING,0,0) ;
			return 0 ;
		case WM_COMMAND:
         break ;
		case WM_DESTROY:
         DestroyWindow(hwndCtrl) ;
         DestroyWindow(hwndRegister) ;
         DestroyWindow(hwndProject) ;
         DestroyWindow(hwndTabCtrl) ;
         DeleteObject(projBitmap) ;
         DeleteObject(regsBitmap) ;
         DeleteObject(tabNormalFont) ;
         DeleteObject(tabBoldFont) ;
         hwndTab = 0 ;
         break ;
      case WM_SIZING:
         if (docking & DF_PROJECT) {
            if (wParam == WMSZ_BOTTOMLEFT || wParam == WMSZ_TOPLEFT ||
                  wParam == WMSZ_TOP || wParam == WMSZ_LEFT) {
               GetRelativeRect(hwndFrame,hwnd, (RECT *)lParam) ;
            } else if (wParam == WMSZ_BOTTOM || wParam == WMSZ_BOTTOMRIGHT)
               sizingbottom = TRUE ;
         }
         break ;
      case WM_SIZE :
         r.right = LOWORD(lParam) ;
         r.bottom = HIWORD(lParam) ;
         r.left = r.top = 0 ;
#ifdef XXXXX
         deferstruct = BeginDeferWindowPos(4) ;
         deferstruct = DeferWindowPos(deferstruct,hwndCtrl,HWND_TOP,0,0,r.right, r.bottom, 0) ;
         SendMessage(hwndCtrl, LCF_ADJUSTRECT, 0 , (LPARAM)&r ) ;
         deferstruct = DeferWindowPos(deferstruct,hwndTabCtrl,hwndCtrl,r.left,r.top,r.right-r.left,r.bottom-r.top, 0) ;
         TabCtrl_AdjustRect(hwndTabCtrl,FALSE, &r) ;
         deferstruct = DeferWindowPos(deferstruct,hwndProject,hwndCtrl,r.left,r.top,r.right-r.left,r.bottom-r.top,0) ;
         deferstruct = DeferWindowPos(deferstruct, hwndRegister,hwndCtrl,r.left,r.top,r.right-r.left,r.bottom-r.top,0) ;
         EndDeferWindowPos(deferstruct) ;
#endif
         MoveWindow(hwndCtrl,0,0,r.right, r.bottom, TRUE) ;
         SendMessage(hwndCtrl, LCF_ADJUSTRECT, 0 , (LPARAM)&r ) ;
         MoveWindow(hwndTabCtrl,r.left,r.top,r.right-r.left,r.bottom-r.top, TRUE) ;
         TabCtrl_AdjustRect(hwndTabCtrl,FALSE, &r) ;
         MoveWindow(hwndProject,r.left,r.top,r.right-r.left,r.bottom-r.top,TRUE) ;
         MoveWindow( hwndRegister,r.left,r.top,r.right-r.left,r.bottom-r.top,TRUE) ;
         PostMessage(hwndFrame, WM_REDOSIZING, 0, 0) ;
         break;
		case WM_CLOSE:
         ShowWindow(hwndTab,SW_HIDE) ;
         docking |= HF_PROJECT ;
         PostMessage(hwndFrame,WM_REDOSIZING,0,0) ;
         return 0 ;
      case WM_MOVE:
         break ;
      case WN_ENDMOVE:
         pr = (RECT *)lParam ;
         GetRelativeRect(hwndFrame,hwnd,&r) ;
         if (!memcmp(pr,&r,sizeof(r)))
            break ;
         if (pr->left == 0 ) {
            docking |= DF_PROJECT ;
         } else {
            docking &= ~DF_PROJECT ;
            GetFrameInternalRect(&r) ;
            pr->left -= r.left ;
            pr->right -= r.left ;
            pr->top -= r.top ;
            pr->bottom -= r.top ;
         }
         SendMessage(hwndFrame, WM_REDOSIZING, 0, 0) ;
         MoveWindow(hwnd,pr->left, pr->top, pr->right-pr->left, pr->bottom-pr->top, TRUE) ;
         if ((docking & DF_PROJECT) && (docking & DF_ERROR) && sizingbottom) {
            RECT r1 ;
            GetRelativeRect(hwndFrame,hwnd,&r1) ;
            GetRelativeRect(hwndError,hwnd,&r) ;
            if (r.top != r1.bottom) {
               GetFrameInternalRect(&r) ;
               r.top = r1.bottom ;
               MoveWindow(hwndError,r.left,r.top,r.right-r.left,r.bottom-r.top, TRUE) ;
            }
         }
         if ((docking & DF_WATCH) && (docking & DF_ERROR) && sizingbottom) {
            RECT r1 ;
            GetRelativeRect(hwndFrame,hwndWatch,&r1) ;
            r1.bottom = pr->bottom ;
            MoveWindow(hwndWatch,r1.left,r1.top,r1.right-r1.left,r1.bottom-r1.top, TRUE) ;
         }
         InvalidateRect(hwndProject,0,FALSE) ;
         InvalidateRect(hwndRegister,0,FALSE) ;
         sizingbottom = FALSE ;
         break ;
      case WM_MOVING:
         pr = (RECT *)lParam ;
         if (pr->left > 5) {
            GetFrameInternalRect(&r) ;
            if (r.top > pr->top) {
               pr->top = r.top ;
            }
            pr->bottom = pr->top + 160 ;
         } else {
               GetFrameInternalRect(&r) ;
               pr->top = r.top ;
               pr->right -= pr->left ;
               pr->left = 0 ;
               if ((docking & DF_ERROR) && !(docking & HF_ERROR)) {
                  GetRelativeRect(hwndFrame,hwndError,&r) ;
                  pr->bottom = r.top ;
               } else
                  pr->bottom = r.bottom ;
         }
         return 0 ;
	}
   return DefMDIChildProc(hwnd, iMessage, wParam, lParam) ;
}

void RegisterTabWindow(void)
{
		WNDCLASS wc ;
      wc.style = 0;
      wc.lpfnWndProc = &TabWndProc ;
		wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
		wc.hInstance = hInstance ;
		wc.hIcon = LoadIcon(0,IDI_APPLICATION) ;
		wc.hCursor = LoadCursor(0,IDC_ARROW) ;
		wc.hbrBackground = GetStockObject(WHITE_BRUSH) ;
		wc.lpszMenuName = 0 ;
      wc.lpszClassName = szTabClassName ;
		RegisterClass(&wc) ;

}
void CreateTabWindow(void)
{
   RECT r,r1 ;
   GetFrameInternalRect(&r) ;
   GetRelativeRect(hwndFrame,hwndError,&r1) ;
   r.bottom = r1.top ;
   r.right = 200 ;
   
         hwndTab = CreateWindowEx( 0, szTabClassName, szTabTitle,
            WS_VISIBLE | WS_CHILD | WS_CLIPSIBLINGS | WS_DLGFRAME,
            r.left,r.top,r.right-r.left,r.bottom-r.top, hwndFrame, 0 ,hInstance, 0) ;

   
}