#ifndef __STDLIB_H
#define __STDLIB_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#ifndef NULL
#define NULL 0
#endif


#ifndef _PTRDIFF_T
#define _PTRDIFF_T
typedef long    ptrdiff_t;
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

#define offsetof( s_name, m_name )  (size_t)&(((s_name *)0)->m_name)

#ifndef _WCHAR_T
#define _WCHAR_T
typedef unsigned wchar_t;
#endif

#ifndef _DIV_T
#define _DIV_T
typedef struct {
        int     quot;
        int     rem;
} div_t;
#endif

#ifndef _LDIV_T
#define _LDIV_T
typedef struct {
        long    quot;
        long    rem;
} ldiv_t;
#endif

#define MB_CUR_MAX 18

/* Maximum value returned by "rand" function
*/
#define RAND_MAX 0x7FFFU

#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1

#ifdef __cplusplus
extern "C" {
#endif

typedef void (* atexit_t)(void);


void         abort(void);

#if !defined(__ABS_DEFINED)
#define __ABS_DEFINED

int         RTL_INTRINS abs(int __x);

#endif /* __ABS_DEFINED */

int         RTL_NORM atexit(void (*__func)(void));
double      RTL_NORM atof(const char *__s);
int         RTL_NORM atoi(const char *__s);
long        RTL_NORM atol(const char *__s);
void *      RTL_NORM bsearch(const void *__key, const void *__base,
                           size_t __nelem, size_t __width,
                           int (*fcmp)(const void *,
                           const void *));
void *      RTL_NORM calloc(size_t __nitems, size_t __size);
div_t       RTL_INTRINS div(int __numer, int __denom);
ldiv_t      RTL_INTRINS ldiv(long __numer, long __denom);
void        RTL_NORM exit(int __status);
void        RTL_NORM free(void *__block);
char *      RTL_NORM getenv(const char *__name);
void *      RTL_NORM malloc(size_t __size);
int         RTL_NORM mblen(const char *__s, size_t __n);
size_t      RTL_NORM mbstowcs(wchar_t *__pwcs, const char *__s,
                                    size_t __n);
int         RTL_NORM mbtowc(wchar_t *__pwc, const char *__s, size_t __n);
void        RTL_NORM qsort(void *__base, size_t __nelem, size_t __width,
                       int (* __fcmp)(const void *, const void *));
int         RTL_NORM rand(void);
void  *     RTL_NORM realloc(void *__block, size_t __size);
void        RTL_NORM srand(unsigned __seed);
char *      RTL_NORM strdup(const char *string);
double      RTL_NORM strtod(const char *__s, char **__endptr);
long        RTL_NORM strtol(const char *__s, char **__endptr,
                                    int __radix);
long double RTL_NORM _strtold(const char *__s, char **__endptr);
unsigned long   RTL_NORM strtoul(const char *__s, char **__endptr,
                                       int __radix);
int         RTL_NORM system(const char *__command);
size_t      RTL_NORM wcstombs(char *__s, const wchar_t *__pwcs,
                                    size_t __n);
int         RTL_NORM wctomb(char *__s, wchar_t __wc);
int         RTL_NORM wctombflush(char *__s);


extern  char          ** _environ;
extern  int              _fmode;
extern  unsigned char    _osmajor;
extern  unsigned char    _osminor;
extern  unsigned int     _version;


#define atoi(s)     ((int) atol(s))

/* Constants for MSC pathname functions */

#define _MAX_PATH       80
#define _MAX_DRIVE      3
#define _MAX_DIR        66
#define _MAX_FNAME      9
#define _MAX_EXT        5

long double     RTL_NORM _atold(const char *__s);
unsigned char   RTL_INTRINS _crotl(unsigned char __value, int __count);
unsigned char   RTL_INTRINS _crotr(unsigned char __value, int __count);
char     *  RTL_NORM ecvt(double __value, int __ndig, int *__dec,
                           int *__sign);
void            _exit(int __status);
char     *  RTL_NORM fcvt(double __value, int __ndig, int *__dec,
                           int *__sign);
char     *  RTL_NORM _fullpath( char *__buf,
                                 const char *__path,
                                 size_t __maxlen );
char     *  RTL_NORM gcvt(double __value, int __ndec, char *__buf);
char     *  RTL_NORM itoa(int __value, char *__string, int __radix);
void     *  RTL_NORM lfind(const void *__key, const void *__base,
                                 size_t *__num, size_t __width,
                                 int (* __fcmp)(const void *,
                                 const void *));

void     *  RTL_NORM lsearch(const void *__key, void *__base,
                                 size_t *__num, size_t __width,
                           int (* __fcmp)(const void *, const void *));
char     *  RTL_NORM ltoa(long __value, char *__string, int __radix);
void        RTL_NORM      _makepath( char *__path,
                                 const char *__drive,
                                 const char *__dir,
                                 const char *__name,
                                 const char *__ext );
int         RTL_NORM      putenv(const char *__name);

#ifndef __STDC__
unsigned    RTL_INTRINS _rotl(unsigned __value, int __count);
unsigned    RTL_INTRINS _rotr(unsigned __value, int __count);
#endif

void        RTL_NORM _searchenv(const char *__file,
                                 const char *__varname,
                                 char *__pathname);
void        RTL_NORM _searchstr(const char *__file,
                                 const char *__ipath,
                                 char *__pathname);
void        RTL_NORM _splitpath( const char *__path,
                                 char *__drive,
                                 char *__dir,
                                 char *__name,
                                 char *__ext );
void        RTL_NORM swab(char *__from, char *__to, int __nbytes);
char     *  RTL_NORM ultoa(unsigned long __value, char *__string,
                                 int __radix);

#ifdef __cplusplus
};
#endif


#define random(num)((rand()*(num))/((RAND_MAX+1))



#define randomize() srand((unsigned)time(NULL))
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))

#define _itoa(__value, __string, __radix) itoa(__value, __string, __radix)

#endif  /* __STDLIB_H */