1.1.1. Introduccin
1.2.1. Descripcin operacional de Imake
1.3.1. Componentes de un fichero make
2.1.1. Comentarios y extensiones de lnea
2.2.1. Macros
2.2.2. Macros por defecto
2.3.1. Secuencias de escape
2.3.2. !include
2.3.3. Condicionales
2.4.1. Especificaciones del Path
2.5.1. Reglas
2.5.2. Reglas explcitas
2.5.3. Reglas implcitas
2.6.1. Construcciones de comandos miscelneos
3.1.1. Formato de la lnea de comandos
4.1.1. Itouch

1.1.1. Introduccin

Este documento describe Imake, un intrprete de ficheros make, e Itouch, usado
para poner la hora de un fichero igual que la hora actual del sistema.

Imake procesa una lista de dependencias de ficheros. Si un fichero depende de
otro y la hora del segundo fichero es posterior a la hora del primero, Imake
ejecuta una lista de comandos para actualizar el primer fichero. Esto es til
por ejemplo para asegurarse de que un ejecutable es reconstruido tras haber
cambiado los fuentes que lo generan, o para asegurarse de que cualquier fuente
que depende de un fichero include es recompilado or reensamblado despus que
el fichero include haya cambiado.

1.2.1. Descripcin operacional del Imake

Imake primero busca el fichero "BUILTINS.MAK". Si no lo encuentra en el
directorio actual Imake buscar en el Path especificado en la variable de
entorno PHI. Si todava no lo encuentra Imake busca en el directorio en el que
est IMAKE.EXE . Si lo encuentra ser cargado como fichero make. Se ignorar
BUILTINS.MAK si se especifica el parmetro -r en la lnea de comandos.

Imake va a buscar "MAKEFILE" y luego "MAKEFILE.MAK". Si encuentra cualquiera de
estos, lo cargar. Slo se podr cargar uno de los dos. Este nombre podra
sobreescribirse por el parmetro -fNAME. En este caso Imake no buscar
"MAKEFILE" ni "MAKEFILE.MAK" y buscar en su lugar "NAME" y "NAME.MAK".
Nuevamente, slo uno de los dos ser cargado.

Se interpretar el fichero cargado. Se compararn las dependencias del fuente
con la hora actual del sistema y se ejecutan las reglas para actualizar
cualquier fuente antiguo.

1.3.1. Componentes de un fichero make

Los componentes de un fichero make son:

1) Comentarios
2) Definiciones de macro
3) Secuencias de escape
4) Especificaciones del Path
5) Reglas implcitas
6) Reglas explcitas

2.1.1. Comentarios y extensiones de lnea

Los comentarios comienzan y finalizan con un '#' o pueden encerrarse en cajas
de caracteres Ftext. La primera aparicin de un carcter de comentario har que
el texto se ignore; la siguiente aparicin har que el texto se vuelva a usar.
Una marca de final de lnea finaliza el comentario si es que lo haba.

Comentarios vlidos incluyen:

        # Esto es un comentario

Los caracteres de extensin se pueden usar al final de una lnea para decirle
al Imake que concatene dos o ms lneas juntas. Los caracteres de extensin
son '\'.

2.2.1. Macros

La definiciones de macro deben comenzar en la columna ms a la izquierda. La
sintaxis es:

MACRONAME = cadena

Los espacios en blancos sern cribados desde los lados izquierdo y derecho de la
cadena. Los macros pueden ser usados en cualquier punto en el fichero make en
lugar de un texto directo y estos sern expandidos antes de usarse. Para usar
un macro sta es la sintaxis:

$(MACRONAME)

Los macros sern expandidos completamente, incluyendo cualesquiera macros que
puedan contener en l. Algunas veces esto es conveniente para ser capaz de
cambiar texto en un macro; la sintaxis es:

$(MACRONAME:texto_antiguo=nuevo_texto)

donde 'nuevo_texto' sustituye a 'texto_antiguo' en cualquier sitio en que
aparezca en el macro. esta sustitucin se hace antes de sustituir cualquier
macro que pueda aparecer como parte de la definicin de macro de MACRONAME.
Los macros se pueden redefinir en cualquier momento con algunas excepciones; sin
embargo, tal y como es explicado ms tarde, la reutilizacin de macros puede
llevar a confusiones.

2.2.2. Macros por defecto

Todas las variables de entorno son importadas como macros. Si un macro tiene
el mismo nombre que una variable de entorno, el valor de la variable de entorno
se perder a menos que se use -e en la lnea de comandos.

Puedes usar los parmetros -D y -U para sobreescribir definiciones de macros en
los fichero make. -DMACRONAME=VALOR o -DMACRONAME definen un macro con o sin
valor. -U hace que MACRONAME sea indefinible. Estas opciones tienen total
precedencia sobre las definiciones de macros de otras formas.

Por defecto estn definidos los siguientes macros adicionales:

       +---------------------------------------------------------------+
       |Nombre          Se expande a                                   |
       +------------+--------------------------------------------------+
       |MAKE        |   el nombre del programa make (normalmente       |
       |            |      IMAKE.EXE)                                  |
       |MAKEDIR     |   el path desde el que se ha cargado Imake       |
       |MAKEFLAGS   |   argumentos especificados en la lnea de        |
       |            |      comando de Imake                            |
       |__MAKE__    |   Versin del Imake                              |
       |__MSDOS__   |   "1" - ste es un programa make para MS-DOS     |
       |__PHIDOS__  |   "1" - sta es una utilidad F corriendo bajo DOS|
       +------------+--------------------------------------------------+

Adicionalmente se pueden usar los siguientes macros en comandos en reglas
implcitas y explcitas:

       +------------------------------------------------------------------+
       |macro   Se expande en Implcita         Se expande en Explcita   |
       +------+------------------------------+----------------------------+
       |$*    | path\dependent file          |  path\target file          |
       |$<    | path\dependent file+ext      |  path\target file +ext     |
       |$:    | path for dependents          |  path for target           |
       |$.    | dependent file +ext          |  target file +ext          |
       |$&    | dependent file               |  target file               |
       |$@    | path\target file +ext        |  path\target file +ext     |
       |$**   | path\dependent file+ext      |  files from dependents line|
       |$?    | path\dependent file+ext      |  undefined                 |
       +------+------------------------------+----------------------------+

2.3.1. Secuencia de escape

Las secuencias de escape se usan para controlar la interpretacin de un fichero
make. Las secuencias de escape existen para incluir un fichero include para
interpretaciones condicionales.

Las secuencias de escape comienzan con un carcter '!'. Si se usa una secuencia
de escape, se puede indentar con cualquier cantidad de espacios. Las secuecias
de escape distinguen entre maysculas y minsculas y deben estar en minsculas.

2.3.2. !include

!include "nombre_de_fichero"

Se buscar 'nombre_de_fichero' a lo largo del path de include (parmetro -I).
Si se encuentra se cargar. Los comandos y las definiciones de macro pueden
extender los lmites de los ficheros; ten esto en mente.

2.3.3. Condicionales

Las condicionales slo comprueban la presencia o ausencia de un macro. No hay
implementadas en Imake clculos matemticos o comparaciones.

!ifdef $(MACRO)
o
!ifdef {MACRO}

Empiezan un bloque 'if'. Si MACRO no est definido, las lneas no sern
interpretadas hasta la siguiente secuencia de escape.

!ifndef $(MACRO)
o
!ifndef {MACRO}

Comienzan un bloque 'if'. Si MACRO est definido las lneas no sern
interpretadas hasta la siguiente secuencia de escape.

!else

Si la omisin de lneas est activa, comienza a interpretar lneas de nuevo,
de otra forma detiene la interpretacin.

!endif

Cierra este bloque 'if' y comienza la interpretacin si el 'if' anidado lo
permite.

Ntese que la bsqueda de MACRO en una secuencia de escape se hace a la vez
que la lnea es encontrada en el fichero de entrada. Por eso, si el macro fue
definido en cualquier lugar anterior, la secuencia de escape ser localizada.
Por contra, los macros en los comandos no son expandidos hasta que haya sido
ledo por completo el fichero make... por eso la definicin ltima de un
determinado macro es aquella que permanece en este caso.

2.4.1. Especificaciones de Path

Los nombres de los ficheros fuente pueden aparecer en directorios alternativos.
Cuando se busca un fuente (dependencia) Imake primero mira en el directorio
actual. Entonces examina la extensin del fichero y determina si ha sido
especificado algn directorio alternativo; si es as, buscar el fichero en
el directorio alternativo. Si no puede encontrar un fichero fuente que ha sido
especificado como dependiente y no puede encontrar una regla para construirlo,
Imake generar un mensaje de error.

La especificacin de Path debe comenzar en la primera columna de una lnea y
tener la siguiente forma:

.path.EXE = searchpath[;searchpath[;searchpath ...]]

Por ejemplo:

.path.asm = ..\source

Le dice a Imake que busque los ficheros fuente en el directorio 'source'. Las
declaraciones de Path deben hacerse en letras minsculas.

2.5.1. Reglas

Las reglas le dicen a Imake qu ficheros son dependientes de otros. Tambin le
dicen cmo construir, o actualizar, cualquier fichero que sea ms antiguo que
sus dependientes.

Hay dos tipos de reglas: reglas explcitas y reglas implcitas.

El formato bsico de una regla es como sigue:

target:   lista de dependencias
  (cualquier nmero de espacios en blanco) comando1
  (cualquier nmero de espacios en blando) comando2
        ...

La necesidad de los espacios en blanco para indicar un comando es por lo que
los macros y las especificaciones de Path y 'targets' deben empezar en la
primera columna.

Imake aceptar nombres de 'target' para construir en la lnea de comandos; estos
deben ser nombres de 'targets' explcitos y opcionalmente tener caracteres
comodn en ellos. Si no se especifica ningn nombre de 'target' en la lnea de
comandos, Imake procesa la primera regla explcita que encuentre, descomponiendo
las otras reglas segn lo necesite para mantener actualizados los ficheros
dependientes.

Los comandos pueden ser cualquier comando del MS-DOS, incluyendo ficheros .EXE
y .COM . Imake no soporta los ficheros .BAT

2.5.2. Reglas explcitas

Para una regla explcita, se comprueban todos los ficheros en la lista de
dependencias para asegurarse de que son ms nuevos que cualquiera de los
ficheros requeridos para construirlos. Se hace una comprobacin recursiva en
cada uno de los ficheros de la lista de dependencia para asegurarse de que est
actualizado respecto de sus propias dependencias. La recursividad contina
hasta que todas las listas de dependencias consisten en ficheros que existen o
pueden ser construidos con una regla. Si un fichero no existe e Imake no puede
encontrar una regla para construirlo, Imake genera un mensaje de error.

Imake entonces comienza con el nivel ms bajo de las dependencias y comienza
construyendo cualesquiera ficheros que estn anticuados. Si un fichero est
anticuado, todos los ficheros que dependan de l estn tambin anticuados y
son reconstruidos.

Para las reglas explcitas, no es necesario tener una lista de comandos. Imake
aceptar un nombre de 'target' con dependencias como una manera sencilla de
obligarle a evaluar todas las dependencias; por eso, para construir un proyecto
entero se podra usar el target 'all' y dar como dependencias cualquier fichero
que el fichero make diga que hay que construir.

Como ejemplo, la regla:

file1.obj: file1.asm
        nasm -fobj file1.asm

Compar la fecha de file1.obj con la fechas de file1.asm. Si file1.asm es ms
nuevo entonces el comando:
        nasm -fobj file1.asm
ser enviado al MS-DOS, resultando en la actualizacin del fichero.

2.5.3. Reglas implcitas

Las reglas implcitas tienen la forma:

.EXT1.EXT2:
        < lista de comandos >

Donde EXT1 y EXT2 pueden ser cualesquiera extensiones vlidas del MS-DOS. Si
Imake se encuentra un fichero sin reglas explcitas especificadas. mirar todas
las reglas implcitas y encontrar aquell cuya EXT2 coincida con la extensin
del fichero. Si encuentra una, sustituir EXT2 con EXT1 en el nombre del fichero
y buscar el nombre del fichero resultante. Si encuentra el fichero, supondr
que la regla explcita coincide con el fichero y entonces compara las fechas en
el fichero original y el que ha encontrado. Si el fichero original es ms
antiguo, entonces es reconstruido con los comandos especificados con la regla.

Las reglas implcitas son buscadas en el orden en que Imake las encuetra.

Como ejemplo, la reglas:

.asm.obj:
        nasm -fobj $<

Coincidir con cualquier fichero que termine en la extensin .obj, por ejemplo
file1.obj. Si Imake encuentra entonces un fichero llamado file1.asm (mirando
a lo largo de la variable Path si fuese necesario) entonces la regla implcita
coincide e Imake compara las fechas de los ficheros. Si file1.asm es ms nuevo
que file1.obj entonces el comando es analizado, el cual ensambla el fichero
y lo actualiza.

2.6.1. Construcciones de comandos miscelneos

Algunos macros incluidos como $< pueden generar una lista complete de ficheros
para usar en reglas implcitas. Por ejemplo:

.asm.obj:
        $(ASM) $<

Generar una lnea de comandos ASM que tiene cualesquiera ficheros fuente que
necesiten ser reconstruidos. Si se desea usar una herramienta que no acepte
mltiples ficheros de entrada, puede escribirse de la siguiente forma:

.asm.obj:
        @$(ASM) $<

e Imake separar un comando ASM para cada lnea de la lista.

Algunas veces, la lnea de comandos a usar por Valx o Xlib es demasiado larga
como para caber en el buffer de comandos de MS-DOS; ambas utilidades (y algunas
otras) permiten que se coja desde un fichero una entrada casi infinita. Imake
crear ficheros temporales a partir de una especificacin de un fichero en
lnea, pasndolos como argumentos al comando, y borrndos entonces (a menos que
se especifique -K).

La sintaxis para comenzar un fichero temporal es: &&| , donde | puede ser
cualquier carcter delimitador. Este carcter tambin ser usado para finalizar
el fichero temporal. Respecto a encontrar esta secuencia en una lista de
comandos, Imake ignorar primero el resto de la lnea actual tal y como si
fuese un comentario. Las lneas posteriores a esto ser sustituidas por un macro
y escritas directamente a un fichero temporal que crea Imake, hasta que se
encuentre el fichero delimitador. Cada lnea del fichero temporal acabar con
un final de prrafo (0x0a). las lneas pueden concatenarse con los extensores de
lnea.

Ahora la primera lnea ser retomada y el nombre del fichero make ser
sustituido por el &&| . Los caracteres en la ltima lnea despus del carcter
delimitador sern aadidas a esta lnea y todo ello ser emitido como un
comando. Imake usa el nombre "MAKEFILE.???" para los ficheros temporales, donde
los comodines pueden ser cualquier nmero. Esto permite un nmero arbitrario
de ficheros temporales durante una construccin.

Por ejemplo:

        valx -use32 -nci @&&|
codos.obj $(SOURCE_deps),filnam,filnam,cldos.lib
|

Si SOURCE_deps se expande hasta el fichero DEBUG.OBJ y HANDLER.OBJ Imake crear
un fichero con el siguiente contenido:

c0dos.obj debug.obj handler.obj,filnam,filnam,cldos.lib

Este fichero se llamar makefile.??? donde podrn ser sustituidos los ??? por
dgitos. Imake emitir el siguiente comando:

        val -use32 -nci @makefile.???

3.1.1. Formato de la lnea de comandos

imake [/a/B/D/e/f/h/I/K/m/n/q/r/s/u target names]
-B      Obliga a que todo sea reconstruido independientemente de las fechas
-DMACRO o -DMACRO=valor
        define un macro
-e      No permite las redefiniciones de macros de variables de entorno
-fname  Usa el fichero "name" en lugar de "MAKEFILE"
-h      Muestra la lnea de uso
-I      Especifica los directorios de los ficheros include
-K      Mantiene los ficheros temporales. Por defecto, Imake borra los ficheros
        temporales.
-m      Muestra la fecha y hora de cada fichero que procese Imake
        Los ficheros que necesiten ser reconstruidos tendrn prximo un '*'.
-n      Los comandos se imprimen en pantalla pero no se ejecutan. Util para
        depurar un fichero make
-p      Imprime las definiciones de macro y la reglas despus de la
        interpretacin pero antes de la ejecucin del fichero make
-q      Cambia el valor de retorno para que sea 0 si el 'target' est
        actualizado,  1 si se ha hecho cualquier cambio
-r      Ignora BUILTINS.MAK
-s      No imprime los comandos en la pantalla antes de partirlos.
-U      Hace un macro indefinible

4.1.1. Itouch

Itouch imprime la fecha actual del sistema en el fichero especificado. Se puede
usar comodines. La nica opcin es:

imake [/v] filenames

-v      muestra los ficheros segn los va tocando.
