1.1) Introduccin general
1.2) Comentarios sobre la configuracin general
1.3) Parmetros de la lnea de comandos
1.4) Crditos
2.1) Compatibilidad ANSI
2.2) Caractersticas desaparecidas
2.3) Caractersticas del estilo de C++
2.4) Fallos conocidos
3.1) Libreras run-time estndar
4.1) Palabras clave de implementacin y dependencia
4.2) Funciones del preprocesador de implementacin y dependencia
4.3) Compatibilidad Phi-text
5.1) Errores
6.1) Marcos de pila
6.2) Interfaz ASM
6.3) Segmentacin
6.4) Optimaciones
6.5) Cdigo FPU
7.1) Descripcin del rbol de directorios
7.2) Portabilidad

----------------------------------------------------------------------

1.1) Introduccin general

Este compilador se presenta en una base 'tal cual' sin garanta de que sirva o
se ajuste a cualquier aplicacin. Los riesgos asociados a su uso, incluyendo
prdidas financieras o de vidas no son responsabilidad de los autores. Sin
embargo, este compilador est concebido como una herramienta educativa y no
es para ser usado comercialmente en ningn caso sin el expreso consentimiento
por escrito de los autores.

El autor original es Matthew Brandt. Tal y como lo dej era un compilador de
estilo K&R sin coma flotante y una ayuda mnima de preprocesador,
orientada slo para el m68k. La mayor parte del trabajo fue hecho en una
mquina UNIX y despus se llev al DOS. Puedes encontrar su versin en uno de
los sitios de archivo de Motorola por si deseas comparar. La presente versin
ha sido actualizada de forma amplia para soportar una variedad de
construcciones ANSI as como soporte i386 y un preprocesador mejor. Sin
embargo, partes del programa todava reflejan el trabajo de Matthew.

Yo he hecho mi parte de la codificacin con compiladores de MSDOS de 16 y 32
bits. Esta versin del cdigo NO tiene caractersticas especficas del DOS
en ella y debera poder ser trasladada a cualquier compilador ANSI de 16 o de
32 bits.

Esta es una optimizacin reorientada a compiladores C de 32 bits. La presente
ayuda es para el mk68 y el i386. Soporta la mayora de las palabras clave de
ANSI; aunque el compilador definitivamente NO es compatible con ANSI cuando
se llega a las expresiones de evaluacin.

Se ha aadido un preprocesador interno. Ntese que debido a la necesidad de
usar un conjunto de caracteres extendido, la mayora del preprocesador
considera los caracteres como cortos. Los smbolos se traducen al formato
ASCII con secuencias de escape por lo que el resto del compilador puede usar
campos de carcter para los smbolos.

Hay tambin una mnima variante del compilador de Matthew; busque el fichero
c386.* usando archie. La caracterstica inteligente apenas es compatible
con este compilador, excepto si es totalmente compatible con ANSI mientras que
este compilador no lo es, y no tiene un preprocesador incorporado.

El compilador genera un cdigo ASM por ahora. Para el mk68, el compilador
genera un fichero .SCR y se utiliza la sintaxis de cdigo cruzado (CrossCode)
del ensamblador. Para el i386, el compilador genera un fichero .ASM y se
utiliza la sintaxis del tasm o del nasm.

En el directorio clibs encontar las fuentes de C y de ensamblador para una
librera C en ANSI. No se garantiza que estn completas o que sean exactas,
sin embargo sus funciones estn diseadas para trabajar de forma similar a
las funciones ANSI. Hay ficheros de arranque que inicializan por completo el
entorno en tiempo de ejecucin del compilador.

----------------------------------------------------------------------

1.2) Comentarios sobre la configuracin general

Lo nico que realmente se necesita para que el compilador funcione es un
puntero a los directorios 'include'. Estos podran ser especificados en la
variable de entorno 'CCINCL' o con el parmetro /I en la lnea de comando. Yo
normalmente establezco CCINCL=clibs\stdinc para llegar a las cabeceras ANSI y
luego uso /I si se necesitan otros directorios. Si usas el programa install.bat
CL386 se ocupar de las cuestiones relativas a los include y las bibliotecas
a travs de su fichero de configuracin y no se necesita ninguna otra
configuracin ms que ejecutar el programa de instalacin.

----------------------------------------------------------------------

1.3) Parmetros de la lnea de comandos

Los parmetros preestablecidos con un '+' o un '-' pueden activarse o
desactivarse. La ltima aparicin del comando determina su estado. Para
estos comandos '/' es equivalente a '-'. Dse cuenta que los parmetros
generadores de cdigo deben ser generalmente los mismos para todos los mdulos
en un programa o se obtendrn resultados impredecibles.


+e  - crea un fichero de error

+i  - crea un fichero preprocesado
	por defecto es -i

/ffile - procesa los argumentos que estn en el fichero 'file'
+l  - crea un fichero LST
	por defecto es -l
/w-all - sin avisos, slo errores
	los avisos tambin pueden ser suprimidos individualmente. Vese
	ERROR.DOC
-A  -  desactiva la compatibilidad ANSI y habilita algunas caractersticas no
       estndar
	por defecto es +A
/C  - parmetros de generacin de cdigos
	/C+d - muestra los diagnsticos internos
	/C+2 - (slo 680x0) especifica un procesador 68020 o uno mejor
	/C+1 - (slo 680x0) habilita instrucciones 68010
		esto es de una utilidad limitada ya que todo lo que hace es
		habilitar la instruccin RTD -y la nica vez que se usa es si
		usas la palabra clave 'pascal' para forzar las convenciones de
		llamada de pascal.
	/C-b - no BBS
	/C-l - para no poner el cdigo C en el fichero ASM
	/C-m - no elimina los smbolos con un subrayado delante
	/C+p - agrupa las variables para ganar espacio. En un 68020+ minimiza
		la alineacin de palabras
	/C+r - invierte el orden de las operaciones de bits
	/C+s - (slo 680x0) modelo de datos pequeos
		slo est disponible cuando se ha indicado /C+A
	/C+A - usa referencias absolutas de datos antes que las relativas
	/C+F - (386) fuerza la directiva .MODEL del TASM para usar el modo FLAT
		Esto puede convertirse en preestablecido en futuras versiones.
	/C+L - (slo 680x0) usa el modelo de datos grandes
	/C+N - (slo 80386) generador de cdigo NASM
	/C+P - (slo 680x0) usa los marcos de pilas originales de 68k antes que
	       los tipos ms estndar
	/C-R - usa el puntero de pila antes que los registradores de enlaces

	por defecto es /C+blmR-d2prsAFLNP
/Dxxx  - define un macro 'xxx'
/E##  - mximo nmero de errores a generar
/Idirs  - especifica los directorios include. Usa un punto y coma para
	  separar mltiples especificaciones de directorios. Los directorios
	  especificados por la variable de entorno "CCINCL" son siempre los
	  primeros en ser buscados.
/O  - Parmetros de optimacin
	/O-Rxxx Desactiva las optimaciones de registro. En lugar de xxx
		pon cualquiera de las combinaciones:

		a - desactiva la direccin de la optimacin de registro
		f - desactiva el punto flotante de la optimacin de registro
		d - desactiva los datos de la optimacin de registro

	por defecto estn disponibles todas las optimaciones de registro

 +S  - reservada, sin uso (todava)
	por defecto es -S

El compilador buscar el smbolo CC68K en el entorno.
Si lo encuentra, evaluar cualquier argumento de la lnea de comando en l
antes de evaluar la lnea de comando. Ntese que los parmetros de la lnea
de comando ignorarn la variable de entorno; en particular, el especificar un
path de bsqueda tanto en la variable de entorno como en la lnea de
comando llevar a una prdida del entorno de bsqueda del path. Hay una
variable de entorno CCINCL alternativa que especifica los path include
que se aadirn a la especificacin de la lnea de comando.

---------------------------------------------------------------------

1.4) Crditos

La siguiente gente contribuy con cdigo fuente a este programa.

Matthew Brandt:  compilador K&R original en C
David Lindauer:  Conversin al ANSI, preprocesador, libreras run-time
	generador de cdigo 386, diversas mejoras al compilador original


Mucha gente contribuy materialmente en la localizacin de fallos, me gustara
agradecer a dos que fueron especialmente tiles en *muchas* pruebas:

Johann Klockars
Kirill Joss

Y gracias a David Gurevich y a Kirich Joss por valiosas sugerencias a la hora
de empaquetar.

----------------------------------------------------------------------

2.1) Compatibilidad ANSI

Este compilador est pensado para ser compatible con ANSI al nivel de fuente.
Sin embargo, nunca he visto la documentacin ANSI para ver qu significa esto;
si encuentras algo que no va, hzmelo saber!

A pesar de todo, no hay garanta de que el cdigo generado se ajuste a los
requerimientos del runtime ANSI en trminos de orden de evaluacin.
La coma flotante est hecha usando el coprocesador servidor y no est ajustado
a la compatibilidad ANSI/IEEE.

La librera run-time est diseada para actuar como una librera ANSI; sin
embargo, internamente es bastante probable que sea, de alguna manera,
diferente. Especialmente desde que elimin los buffers estticos all donde era
posible.


----------------------------------------------------------------------

2.2) Caractersticas perdidas

Lo siguiente se sabe que falta:

a) las libreras no manejan operaciones con nmeros 'long double'
b) expresiones de la forma:
	(T)

no se manejan correctamente cuando T es un typedef

----------------------------------------------------------------------

2.3) Caractersticas del estilo de C++

El compilador de C tiene algunos rudimentarios soportes de C++. Reconoce:

1) Funciones sobrecargadas (pero no la palabra clave de sobrecarga)
2) Declaraciones de variable en cualquier lugar
3) Variables de referencia
4) Parmetros de funcin por defecto
5) Comprobacin ms estricta de tipos
6) Mejora de iniciacin de punteros estticos y variables de referencia
7) Mensajes detallados de error de C++

Las clases y las palabras claves de C++ todavan no estn soportadas.

Para habilitar estas caractersticas use la extensin .CPP en su fichero de
entrada.

----------------------------------------------------------------------

2.4) Bugs conocidos

Existen los siguientes bugs conocidos:

a) La expresin de evaluacin es recursiva. Con un stack de compilador de 4K
el lmite es aproximadamente algo como:

	a = (b()+(c()+(d()+(e()+f()))));

Ms all de esto, tendrn lugar errores impredecibles. Eleve el lmite de stack
o reajuste la expresin con parntesis de orden superior a la izquierda.
Ntese que esto no sera un problema sin los parntesis de agrupacin porque
el compilador no tendra que mantener tantos contextos. Yo compilo el compilador
con un stack de 20K

b) las sustituciones de macro puede que no abarque mltiples lneas en esta
   ocasin

c) expresiones tales como :

	a = b = c;

puede que no devuelvan el valor correcto a otra cosa que no sea la asignacin
ms a la derecha. En general funcionar, pero si hay mltiples 'cast' implcitas
yendo de una tarea a la siguiente puede que no funcione correctamente.

d) % puede que no funcione correctamente para divisiones con signo. El signo
puede estar equivocado pero el valor ser el correcto. Esto puede o no ser un
problema, todava no lo he analizado.

e) El identificador 'pascal' es una palabra clave estndar ms que algo que
el usuario pueda redefinir. Lo mismo ocurre con el identificador __abs y el
__fabs.

----------------------------------------------------------------------

3.1) Libreras run-time estndar.

Las libreras fueron implementadas de acuerdo con 'The Waite Group's Essential
Guide to ANSI C'- ISbN 0-672-22673-1. Mi copia es circa 1989.

Las funciones de librera de coma flotante no estn soportadas por ahora, ya
que no tengo forma de probarlas. Esto incluye cosas como atof y difftime as
como la mayora de las libreras matemticas.

Todas las funciones en este libro fueron implementadas excepto la coma
flotante. Sin embargo, la materia del control de proceso es parecida a un
esquema por ahora. La mayor parte de la librera IO, parte de la librera time
y las funciones librera malloc requieren soporte del sistema operativo.
Los 'hooks' se dejaron en el cdigo, la funcin que comienza por _ll_ est
diseada para proporcionar el interface entre el sistema operativo y las
libreras C. Para probar las libreras ensambl todo en maysculas y us las
rutinas de la librera BC45 como el interface OS. Si necesitas llevar las
libreras a otra plataforma, consulta los ficheros en clibs\msdos\386 para
tener un ejemplo de escritura de rutinas a bajo nivel para conectar con el
sistema operativo.

Puede haber una variedad de casos en donde las cosas no funcionen como se
esperaba. Por ejemplo scanf leer slo una lnea sin importar que... cuando
una funcin como strftime requiere que se le d una longitud de buffer, los
resultados son indefinidos si la longitud de texto excede la longitud del
buffer. Tambin acabo de descubrir que el abrir un fichero con el atributo
'a' se supone que ignora cualquier intento de definir la posicin para
escribir en el fichero... en esta implementacin todo lo que hace es colocarse
al final del fichero cuando se abre.

Donde ha sido posible, he eliminado los buffers estticos (que hacen que estas
libreras no sean compatibles). Las funciones tales como asctime que se
supone que devuelven el puntero a un buffer esttico en vez de ello colocan
un grupo de espacios en el stack y ponen el buffer al fondo de ella. Este te
permite un poco de libertad para llamar a otras subrutinas... sin embargo para
la mxima portabilidad deberas copiar inmediatamente dichos buffers a un rea
de datos con 'malloc' o a un buffer local. Este se hizo para permitir una mayor
re-entrada que la que el ANSI estrictamente permite. La mayor parte de las cosas
son re-entrantes como esta, excepto para las libreras IO, malloc y una
variedad de cosas como strtok() que requieren un contexto para ser mantenidas
de una llamada a la siguiente. Sin embargo, malloc llama a una funcin 'hook'
_ll_ de transferencia, si accedes a ella mientras hay un acceso en proceso.
Esto tambin podra hacerse con las libreras I/O pero no lo he hecho.

ERRNO ahora ya est soportado!!!

Muchas de las funciones de la librera dependen de tener incluido el cdigo de
arranque/apagado. Este cdigo inicializa unas pocas variables globales y
ejecuta cualquier funcin de arranque/apagado que necesiten las libreras para
la inicializacin y limpieza.

Apenas he hecho unas pruebas mnimas en la versin 68k de las libreras por
ahora; la mayor parte de las pruebas estn hechas en un 386. La prueba de 68k
est limitada a las rutinas de ensamblador y a las rutinas de arranque.

----------------------------------------------------------------------

4.1) Palabras clave de implementacin y dependencia

a) Las siguientes palabras clave de implementacin y dependencia ha sido
aadidas

i386            m68k            uso
_interrupt      _interrupt      Genera una funcin que puede ser usada como
				un trap/interrupcin.
_genbyte        _genword        Genera datos en el segmento de cdigo
<none>          _trap           llama una funcin de trap de 68k
_absolute       _absolute       Sita una variable global en una direccin
				absoluta. Tales variables sern directamente
				direccionables.
pascal          pascal          fuerza a la declaracin de funcin a usar
				convenciones de llamada de pascal.

b) Las siguientes variables de implementacin han sido aadidas. Estas
variables acceden directamente a los registros del lenguaje ensamblador de
dicho nombre. Ntese que deben ser usadas con precaucin y pueden cambiar
peridicamente a voluntad del compilador. Adems, un 'cast' o asignaciones de
ellas pueden cambiar el estado de funcionalidad de la mquina... y arruinar el
cdigo que el compilador ha generado.

m68k
_D0 _D1 _D2 _D3 _D4 _D5 _D6 _D7
_A0 _A1 _A2 _A3 _A4 _A5 _A6 _A7
_FP0 _FP1 _FP2 _FP3 _FP4 _FP5 _FP6 _FP7

----------------------------------------------------------------------

4.2) Funciones de preprocesador de implementacin y dependencia

El preprocesador es ms o menos compatible con ANSI.

Las siguientes sentencias #pragma estn soportadas:

#pragma regopt xxx
	ahora obsoleta

#pragma startup xxx #
	xxx puede ser cualquier nombre de funcin
	# puede ser un valor prioritario entre 20 - 90 (otros valores son
	usados por la librera run-time) Las funciones de prioridad mayor se
	ejecutan primero.

	Esta opcin le dice al compilador que informe a las rutinas de arranque
	de que esta funcin debera ser ejecutada con prioridad a la llamada
	principal.

#pragma rundown xxx #
	xxx puede ser cualquier nombre de funcin
	# puede ser un valor entero entre 20-90 (otros valores son usados por
	la librera run-time). Las funciones de prioridad mayor se ejecutan
	primero.

	Esta opcin le dice al compilador que informe a las rutinas de arranque
	de que esta funcin debera ser ejecutada tras la salida principal.

#pragma packed
	Activa el agrupamiento de miembros de estructura

#pragma unpacked
	Desactiva el agrupamiento de miembros de estructura

Los siguientes macros estn predefinidos:

	_m68k_ El compilador est generando cdigo 68k

	__cplusplus si el compilador permite extensiones de C++
	__FILE__ El nombre de fichero del fichero fuente como una cadena
	__DATE__ La fecha como una cadena
	__TIME__ La hora como una cadena
	__LINE__ El nmero de lnea como un nmero

#si los macros pueden usar (xxx) definidos para determinar si un macro est
definido.

----------------------------------------------------------------------

4.3) Compatibilidad Phi-text

Este compilador es capaz de entender 'phi-text' que es un grupo de caracteres
extendidos basada en texto. De alguna manera, es preferible al UNICODE por los
programadores occidentales ya que no conlleva miles de caracteres que son
poco usados por el grupo principal de occidentales.

Phi text es un conjunto de caracteres en bancos. Cada carcter en su forma
completa tiene 32 bits; esto conlleva la siguiente informacin:

cwb:    un nmero entre 32 y 127 que describe el carcter
bank:   un banco entre 0 y 15. BANK 0 es el juego de caracteres ASCII con
	algunas modificaciones para controlar los caracteres.

Atributos bsicos:  Atributos BOLD, UNDERLINE, ITALIC, HIDDEN y REVERSED.
	BLINKING puede ser sustituido por ITALIC aunque normalmente nosotros
	usamos ITALIC.

color: prestacin de 16 colores. Los colores han sido elegidos para reflejar
	colores complementarios. El primer plano y el fondo pueden ser
	especificados para carcter.

size:   atributo de 16 tamaos
font:   atributo de 16 fuentes


32 bits por carcter es un poco ms para algunmas aplicaciones; una aplicacin
puede elegir ignorar ciertos campos. Este compilador ignora TODOS los campos
excepto el bank y el CWB (aunque puede parecer escrito como atributo, no lo
recuerdo). Internamente, los caracteres son as representados con campos de
16 bits en este compilador.

Para facilitar los requerimientos de almacenaje de tal grupo de caracteres,
existe una forma 'streamed' de phi-text. Esta se aprovecha de la nocin de
que los atributos no es probable que cambien tan rpidamente como la
informacin del carcter. Bsicamente, si el bit superior de un byte secuencial
est activado indica que la informacin de control est incrustada la cual
indica los nuevos atributos. Tambin hay un cdigo de 'repeticin' de tal
manera que estas largas cadenas de caracteres repetidos (por ejemplo espacios)
se agrupen juntas. Esto no es tan eficiente como la etiquetacin pero a la
larga funciona mejor porque hay varias situaciones donde tales cadenas puedan
darse en phi-text y NO siempre involucren espacios. En este compilador, el
texto que entra es en formato continuo o en serie (que por defecto es ASCII
a menos que se use un editor apropiado). El formato en serie o continuo se
convierte en formato plano y toda la informacin es desglosada excepto la
esencial para detectar el carcter. El preprocesado se hace en la versin
plana... pero cuando el escner comienza a buscar seales entonces convierte la
versin plana de nuevo en la continua (menos los colores y atributos) para una
mayor eficacia en el interpretador y representador. Si el fichero fuente es
phi-text continuo los ficheros de lista y de ensamblaje tambin sern en
phi-text continuo; la informacin del color es aadida al fichero de lista slo
para hacerlo un poco ostentoso, aunque tengo un monitor monocromo, por eso los
colores que eleg pueden ser desagradables.

Existe un problema con los formatos continuos: en caso de una situacin de
error es posible perder importante sincronizacin y por lo tanto arruinar ms
que un simple carcter. Por esta razn el phi-text continuo est sincronizado
parcialmente; al comienzo de cada lnea toda la informacin de atributos por
defecto vuelve a un estndar por defecto. De este modo uno nunca pierde ms
de una lnea completa ante simples errores. E incluso en esto un editor
inteligente puede ser diseado para ayudarle a uno a reparar estos simples
errores... supuesto que los errores ocurran lo suficientemente a menudo como
para que valga la pena el esfuerzo.

Hemos comprobado que el phi-text est compuesto de 16 banks con 96 caracteres
por banco, para un total de 1536 caracteres. El primer banco es ASCII puro, con
unas pocas modificaciones, pero qu son los otros bancos?. Aproximadamente la
mitad de ellos actualmente no se usan. De ellos algunos han sido deliberadamente
reservados para aplicaciones especficas y usos especficos del sistema por los
diseadores del phi-text. Los caracteres definidos se pueden dividir a grandes
rasgos en los siguientes grupos:

1) Caracteres ASCII
2) Extensiones europeas (caracteres acentuados)
3) Caracteres griegos
4) Caracteres cirlicos
5) Caracteres de dibujo de lnea
6) Caracteres matemticos
7) Caracteres diversos

Dada que ES posible extender ciertos operadores C con ms representaciones
de carcter compactas en un compilador como este, el uso de phi-text ha sido
limitado para admitir caracteres griegos y cirlicos en nombres de variables y
para permitir que las cosas en cajas sean tratadas como comentarios. El editor
primario para phi-text tiene una extensin que permite el uso de los cursores
para dibujar lneas en pantalla y hacer el cdigo ms bonito en un momento.

Para ms informacin sobre el phi-text, contacta con:

Paul McKneely
P.O. BOX 5641
Pasadena, TX, 77508

email: gecko@onramp.net

----------------------------------------------------------------------

5.1) Errores

Esta es una lista de posibles errores. Hay dos tipos de errores... 'Errors'
(Errores) y 'Warnings' (Avisos). Un 'Error' significa un suceso que el
compilador no puede manejar, mientras que un 'Aviso' es un diagnstico que
indica que algo posiblemente est mal pero el compilador har suposiciones
sobre ello.

Cada 'Aviso' tendr un valor entre parntesis, este valor puede usarse en la
lnea de comandos para suprimir el 'aviso'. El valor 'all' puede usarse para
suprimir todos los 'Avisos'. Los 'Errores' no pueden ser suprimidos.

Ejempo

cc -w-ieq a.c  ; Suprime el aviso 'Posible asignacin incorrecta'.
cc -w-all a.c  ; Suprime TODOS los 'Avisos'

Algunos de estos errores tienen lugar cuando el compilador est en modo C++.





Error: _int keyword not allowed in Pascal declarations

	Las declaraciones en Pascal no pueden ser usadas como traps o
	interruptores.
	
Error: Ambiguity between %s and %s

	C++.  El compilador no puede elegir entre dos definiciones
	sobrecargadas casi equivalentes.
	
Warning: ('cln') Argument list too long %s

	La lista de argumentos para la llamada de funcin especificada es
	demasiado larga. El compilador ignora los argumentos extras.
	
Error: Argument list too long in redeclaration of function '%s'

	Una funcin prototipo ha sido redefinida con una lista de argumentos
	diferente.
	
Error: Argument list too short %s
	
	Se le ha suministrado a una llamada de funcin muy pocos parmetros.
	
Error: Argument list too short in redeclaration of function '%s'

	Una funcin prototipo ha sido redefinida con una lista de argumentos
	diferente.
	
Error: Bit field must be signed or unsigned int

	El C de ANSI necesita un campo de bit para ser de uno de estos tipos.
	Si se permiten extensiones los campos de bit pueden ser de cualquier
	tipo entero.
	
Error: Bit field only allowed on scalar types

	Los campos de bit slo se pueden usar en tipos enteros.
	Este error se producir si se est en modo no ANSI y usas cualquier
	tipo no integral como la base para un campo de bit.
	
Error: Bit field too big

	Los campos de bit deben ajustarse al tamao de palabra del procesador.
	
Warning: ('pro') Call to function '%s' with no prototype 

	Se ha hecho una llamada de funcin a una funcin que no ha sido
	previamente definida (declarada). El compilador intenta adivinar los
	tipos de argumentos.
	
Error: Break or Continue outside loop

	Break y continue no se puede ejecutar fuera del mbito de un bucle.
	En su lugar usa Return.
	
Error: Cannot cast %s

	C++. Algunas conversiones forzadas (casting) no estn permitidas.
	
Error: Cannot define a pointer or reference to a reference

	C++. La referencia de variables es tratada de forma especial.
	
Error: Cannot initialize '%s'

	Un error ocurri cuando se intentaba procesar una inicializacin de
	variable.
	
Error: Cannot modify a const val

	Un valor CONST no puede ser modificado.
	
Error: Cannot open file \"%s\" for read access

	No se encontr un fichero include
	
Error: Cannot overload 'main'

	C++. main() no debe estar sobrecargado.
	
Error: Cannot take address of bit field

	No se permiten punteros a los campos de bit.
	
Error: Cannot use bit field as a non-member

	Slo los miembros de estructuras pueden tener un calificador de campo
	de bit.

Warning: ('cno') Code has no effect

	Esta lnea de cdigo no se compil.
	
Error: Constant value expected

	En general, los inicializadores deben ser valores constantes. Algunos
	otros tambin deben serlo.
	
Error: Constructor/destructor must be untyped

	C++ no puede escribir constructores/destructores.
	
Warning: ('cnv') Conversion may truncate ignificant digits 

	Un cast implcito puede producir la prdida de dgitos significativos.
	Este aviso no lo producen los cast explcitos.
	
Error: Could not find a match for '%s'

	C++. Esta llamada de funcin no se convierte en un prototipo ni
	directamente ni con una funcin prototipo sobrecargada o por defecto.
	
Warning: ('dpc') Dangerous pointer cast 

	Este aviso tendr lugar cuando el tamao del puntero no sea el mismo
	que el del tipo (escalar) que usas con l.
	
Error: Declaration expected

	El Parser toma una afirmacin (declaracin) u otro valor cuando se
	esperaba una declaracin.
	
Error: Declaration not allowed here

	El Parser encontr una declaracin cuando se esperaba una afirmacin.
	
Error: Default missing after parameter '%s'

	C++... Este parmetro se supona que tena un valor por defecto y no
	lo encuentra.
	
Error: Destructor for class '%s' expected

	C++. Se esperaba un destructor.
	
Error: Duplicate case %d

	Dos sentencias case evaluadas con el mismo valor.
	
Error: Duplicate label '%s'     

	El etiquetado tiene lugar dos veces en el mismo proceso.
	
Error: Duplicate symbol '%s' 

	El smbolo est siendo redefinido.
	
Error: Ellipse (...) not allowed in Pascal declarations

	Las declaraciones de tipo Pascal puede que no tengan argumentos
	variables.
	
Error: Expected '%c'

	El compilador esperaba un carcter o elemento especfico.

Error: Expression expected

	El compilador estaba listo para interpretar una expresin pero encontr
	algo ms.
	
Error: File ended with comment in progress

	Los comentarios deben tener un punto en el que acaben dentro del mismo
	fichero o en el fichero include.
	
Error: File name expected in #include directive

	la directiva #include debe tener un nombre de fichero.
	
Error: Function declaration not allowed here

	Se intent una declaracin de funcin en un lugar equivocado, por
	ejemplo dentro de una estructura o dentro de otra funcin.
	
Warning: ('ret') Function should return a value

	Este error se produce cuando una funcin no es del tipo 'void' y sales
	sin devolver un valor.
	
Error: Identifier expected

	El parser esperaba el nombre de una variable/funcin.
	
Error: Illegal call to main() from within program 

	C++. Los programas de C++ puede que no hagan una llamada a main()

Error: Illegal character '%c'

	El parser detect una secuencia ilegal de carateres.
	
Error: Illegal pointer

	Hubo un intento de usar un no-puntero en un contexto de puntero.
	
Error: Illegal pure declaration syntzx of '%s'

	C++. La sintaxis de una declaracin virtual es errnea.
	
Warning: ('irg')  Illegal register var '%s' 

	El tamao de la variable era demasiado grande para ella para ajustarse
	en un registro.
	
Error: Illegal storage class specifier '%s'

	Especificador conflictivo o ilegal en una declaracin.
	
Error: Illegal storage class specifier on '%s'

	Especificador conflictivo o ilegal en una declaracin.
	
Error: Illegal typedef of '%s'

	Intento de volver a usar el nombre de un smbolo como un typedef.
	
Error: Illegal use of reference operator

	Intento de usar '&' en un contexto donde no est permitido.
	
Error:  Illegal use of void pointer

	No puede tomar el tamao de un puntero void.
	
Error: Inserted '%c'

	El parser intent adivinar un smbolo a insertar.
	
Error: Invalid '&' on register var '%s' 

	No puede coger la direccin de un registro.
	
Error: Invalid floating point

	No puede usar la coma flotante en ciertos tipos de funciones
	matemticas (por ejemplo funciones lgicas)
	
Error: Invalid preprocessor directive '%s'

	La directiva del preprocesador es desconocida.
	
Error: Invalid trap id

	Especfica de la CPU. Indica que se llam a una operacin de la CPU
	(int o trap) con un identificador que es demasiado largo.
	
Error: '%s' is not a function

	No puede llamar no-funciones.
	
Error: '%s' is not a label

	No puede saltar a no-etiquetas.
	
Error: Local class functions not supported

	C++. No puede soportar las definiciones de clase como variables locales.
	
Error: Local variables may not be used as parameter defaults

	C++. Los parmetros por defecto deben estar al alcance antes de llamar
	a la funcin.
	
Warning: ('lli') long long int type not supported, defaulting to long int

	El tipo long long int se interpretar correctamente pero no est
	soportado.
	
Error: Lvalue expected

	No puede asignarse a la direccin de una variable.
	
Error: Macro substitution error

	Las expansiones de macros estn limitadas a 4096 caracteres.
	
Error: Misplaced else

	Algo inesperado se encontr en el flujo de entrada.
	
Error: '%s' must be a predefined class or struct

	C++. No puede trabajar con esta estructura/clase porque no ha sido
	totalmente definida.
	
Warning: ('zer') No memory allocated for '%s'   
	
	Un array sin tamao tampoco tiene inicializadores.
	
Warning: ('nsf') Nonexistant static func '%s'   

	Una funcin esttica se hizo prototipo pero no fue declarada (definida)
	
Warning: ('npo') Nonportable pointer conversion

	Una conversin implcita de puntero puede dar lugar a un cdigo que se
	compila errneamente con otros compiladores de C.
	
Error: Non-scalar array index

	Los ndices de arrays deben ser del tipo entero.
	
Error: Numeric constant is too large

	Una constante entera o hexadecimal era demasiado larga para el tipo
	base o la parte no decimal de un nmero de un punto flotante podra
	no encajar en un entero grande.
	
Error: Pointer type expected

	Se esperaba un puntero.
	
Warning: '(ieq') Possible incorrect assignment

	El smbolo '=' se us en el campo (mbito) externo en una expresin
	condicional.
	Esto podra ser intencionado pero a menudo es un fallo del smbolo
	'==' por lo que el compilador te avisa.
	
Warning: ('san') Possible superfluous &

	& no es necesario cuando se toma la direccin de un array. Esto es
	un mensaje basura; ANSI C no lo tiene en cuenta en ningn caso.
	
Warning: ('sud') Possible use of '%s' before assignment

	Se ha usado una variable pero posiblemente no ha sido inicializada
	con un valor.
	
Error: Reference initialization needs lvalue

	C++. Referencia las llamadas de sintaxis para algo cuya direccin
	puede ser tomada.
	
Error: Reference member '%s' in a class with no constructors

	C++. La variable de referencia no puede ser iniciada en la clase de
	inicio porque se supone que eso lo hace el constructor.
	
Error: Reference variable '%s' must be initialized

	C++. No se puede cambiar lo que una variable de referencia vale
	mientras se est ejecutando.
	
Error: Return type is void      

	Intento de devolver un valor de una funcin void.
	
Error: Size is unknown or zero

	Intento de usar el tamao de una variable con un tipo que ha sido
	previamente declarado.
	
Error: Size of '%s' is unknown or zero

	Intento de usar el tamao de una variable con un tipo que ha sido
	previamente declarado.
	
Error: Startup/rundown function '%s' is unknown or not a function

	Una funcin nombrada en el '#pragma startup' o en el '@pragma rundown'
	o no es una funcin o no ha sido definida.
	
Error: String constant too long

	Una cadena de varias lneas es demasiado larga.
	
Warning: ('spc') Suspicious pointer conversion

	Una operacin de puntero est siendo ejecutada sobre punteros que
	tienen diferentes tipos base.
	
Warning: ('fun') Static function '%s' is declared but never used

	Esta funcin esttica est desperdiciando el espacio.
	
Warning: ('sud') Static variable '%s' is declared but never used
	
	Esta variable esttica est desperdiciando el espacio.
	
Warning: '(fsu) Structure '%s' is undefined

	La compilacin se complet con una estructurra cuyo tipo nunca se
	defini.
	
Error: Switch argument must be of integral type

	Los parmetros argumento deben ser enteros.
	
Warning: ('tua') Temporary used for parameter %s

	C++. Una constante ha sido pasada en un parmetro de referencia y el
	compilador automticamente cre una variable por eso la funcin llamada
	estara feliz.
	
Warning: ('tui') Temporary used to initialize %s

	La variable de referencia es iniciada con una constante; el almacenaje
	extra se tiene que crear.
	
Error: Too many initializers

	Una estructura/array tiene demasiados inicializadores.
	
Error: Type expected in sizeof

	El argumento sizeof no es de tipo o de variable.
	
Error: Type mismatch

	Tipos no coinciden.
	
Error: Type mismatch in arg '%s'

	Tipos no coinciden en las llamadas a funcin.
	
Error: Type mismatch in redeclaration of '%s'

	Una variable ha sido redeclarada con un tipo diferente al anterior.
	
Error: Type mismatch in return

	El valor que se devuelve no coincide con el tipo de funcin.
	
Error: Unbalanced preprocessor directives

	Las directivas #if- #endif no estn ajustadas.
	
Warning: Undefined label '%s'

	La etiqueta debera aparecer en algn sitio ya que hay un goto a ella.
	
Error: Undefined symbol '%s' 

	Smbolo desconocido.
	
Error: Unexpected '%s'

	Palabra clave no esperada.
	
Warning: (' urc') Unreachable code

	La flujo de cdigo nunca puede llegar aqu.
	
Warning: ('lun') Unused label '%s'      

	Se declar una etiqueta pero nunca se us.
	
Error: User error: %s

	La directiva #Error conlleva a esto.
	
Warning: ('sas') Variable '%s' is assigned a value which is never used

	Tras la asignacin a la variable, no hay un uso posterior.
	
Error: Variable '%s' cannot have a type qualifier

	C++. ???
	
Error: Variable '%s' is not a class instance

	C++. Se esperaba un ejemplo de clase.
	
Warning: ('sun') Variable '%s' is declared but never used

	Esta variable fue declarada pero no hay nada que la referencie.
	Desperdicia el espacio.
	
----------------------------------------------------------------------

6.1) Marcos de pila

Hay una variedad de opciones para los marcos de pila.

a) Los marcos de pila estndar tipo C. Un ndice registrado (EBP o A6) se usa
para sealar un valor entre los parmetros y las variables de funcin local;
todas las variables locales y los parmetros de funcin estn indexados a partir
de este registro base. Esto es lo que viene por defecto.

b) El compilador puede liberar el registro de unin e indexar todas las
variables locales y los parmetros de funcin fuera del puntero de pila.

c) (Slo 68K) Las listas de parmetros pueden situarse en cualquier lugar de
la memoria; el parmetro del puntero de la lista se pasa a A0. A0 es entonces
transferido a A6 y los parmetros son indexados fuera de A6. Mientras tanto las
variables locales son indexadas desde el puntero de pila.

En el 68K, algunas opciones del generador de cdigo estn disponibles. Por
defecto, el compilador 68k genera cdigo PIC basado en un modelo de memoria de
32K. Est disponible el modo 68020 para especificar caractersticas extendidas
del 68020 tales como modos de direccionamiento mejorados e instrucciones
especializadas. Otra opcin es generar cdigo 68000 de tal modo que se pueda
usar una seccin de datos mayor que la de 32K. La ltima opcin te permite
desactivar el modo PIC y generar cdigo que ser situado en direcciones
absolutas en memoria.

El cdigo 386 es bastante sencillo. Es algo ms complejo de lo necesario porque
se necesita usar registros especiales de funcin para algunas operaciones como
multiplicaciones y desplazamientos. El cdigo 386 ser un poco grande debido a
esta necesidad.

El cdigo 68K es independiente de la posicin. Todos los datos globales son
accesibles fuera del registro A5 o A6; los argumentos de las funciones estn
indexados fuera de A6 o A7; y la pila est indexada fuera de A7. Las
constantes de cadena estn indexadas fuera del PC. Debido a esto, el tamao
total de los datos slo puede ser de 32K a menos que se use alguna de las
opciones sigientes: /C+2, /C+L o /C+A.

----------------------------------------------------------------------

6.2) Interfaz ASM

El programa de lenguaje ensamblador no debe modificar ningn registro excepto
los registros:

386:    EAX,ECX,EDX
68K:    D0-D2,A0-A1,FP0-FP2

Los parmetros se pasan por la pila, con el parmetro ms a la izquierda en la
direccin ms baja.

En todas las situaciones en las que se est ensamblando es conveniente usar un
registro ndice para indexar todos los parmetros. El registro que sirve de
ndice debe ser cargado con la direccin del primer parmetro (que estar en la
pila del puntero +4 si no pones el registro ndice o el puntero de pila +8
si lo haces). Los parmetros normalmente necesitan 4 bytes para los tipos
estndar de datos; sin embargo los tipos doble y doble largo necesitan 8 y 12
bytes respectivamente. Si pasas una estructura por valor la cantidad de espacio
de pila usado depende del tamao de la estructura.

En el m68k, si has usado la opcin /C+P del compilador A0 ser precargada con
la direccin de la lista de parmetros ANTES de que tu funcin de lenguaje
ensamblador sea llamada. Si siempre vas a usar esta manera de pasar parmetros
puedes escribir tus funciones de ensamblador para aprovecharlo; sin embargo,
dado que el compilador SIEMPRE pasa los datos a la pila el ndice de libreras
run-time desconecta de un registro de unin o del puntero de la pila para
hacerlos compatibles con los marcos de pila estndar. Por ahora no hay
abastecimiento en las libreras run-time para permitir el paso de parmetros
que no estn localizados en la pila.

Nota: por defecto, el compilador C intenta alinear todos los datos en lmites
que permitan el acceder a los datos de forma ms eficiente. Esto significa que,
si defines una estructura tanto en la cabecera C como en la cabecera ASM,
deberas examinar el fichero LST que origina el compilador C para la estructura
para lograr el equivalente correcto en la versin ASM. Otra alternativa es
agrupar la estructura con la opcin /C+p o el empaquetamiento #pragma.

----------------------------------------------------------------------

6.3) Segmentacin

Los siguientes segmentos o secciones pueden aparecer en el fichero de salida:

nombre 386      nombre 68K      uso
.CODE           code            Constantes de cdigo y de cadenas
.DATA           data            Datos globales inicializados
.?DATA          bss             Datos globales no inicializados
INITDATA        cstartup        Enlazadores de arranque #pragma
EXITDATA        crundown        Enlazadores de apagado #pragma
<none>          codefix         Correcciones para el modo PIC
<none>          datafix         Correcciones para el modo PIC
CPPDATA         cppinit         Inicializaciones estticas de C++

Las siguientes opciones afectan a la generacin de cdigo:

/C-b            Combina el BSS con los DATA
/C-l            No pone los nmeros de lnea en el fichero ASM
/C-m
/C+p            Variables de agrupamiento
/C+r            Usa el orden inverso para los campos de bit
		Ntese que esta opcin invierte el orden de colocacin pero no
		invierte el valor en el campo.

Las siguientes sentencias #pragma afectan a la generacin de cdigo:

#pragma regopt  - activa/desactiva las localizaciones de registros
#pragma startup - nombra una rutina para que sea ejecutada al arrancar
#pragma rundown - nombra una rutina para que sea ejecutada al apagar

----------------------------------------------------------------------

6.4) Optimizaciones

El compilador realiza las siguientes optimizaciones:

a) Plegado de constantes

Cuando se realizan operaciones matemticas normales con constantes el
compilador evaluar la expresin y la sustituir por una constante.

b) Reduccin en la fuerza

Multiplicaciones y divisiones se convierten en desplazamientos cuando sea
apropiado. Los mdulos se transforman en ands cuando sea apropiado.

c) Optimizacin del destino

Cuando el destino de una asignacin es conocido, un registro temporal no ser
colocado, sino que el destino ser usado directamente. Esto nos evita el
generar registros temporales 'muertos' que posteriormente deberan ser
optimizados fuera del icode.

d) Eliminacin de cdigo 'muerto'

Borra saltos a saltos, saltos a la siguiente frase y el cdigo 'muerto'.
Tambin borra todo lo temporal de los que el punto 2) hablaba y que ahora no se
usan.

Ntese que las libreras SETJMP por ejemplo no grabarn el estado de los
registros de punto flotante. Por ello hay una opcin para desactivar la
optimizacin dentro de los registros de punto flotante en caso de que necesites
establecer un salto a una rutina que use la coma flotante. Las optimizaciones
del registro de direccin y datos tambin pueden ser desactivadas. Vase el
fichero switches.doc.

e) Expresiones de reordenamiento
  En algunos casos el compilador genera un cdigo mejor si las expresiones son
  reordenadas; por ejemplo:

  a = a + 10;

  puede transformarse en a += 10 y se consigue generar un cdigo mejor. Tambin
  se ha trabajado mucho en la optimizacin del uso de los modos based/indexed de
  los procesadores cuando era posible hacerlo. La presente versin incluso
  usar el escalado del registro ndice cuando sea posible!.

f) Los modos base + index de direccionar

Este compilador necesita algo de tiempo para identificar cundo los modos
base + index de direccionar pueden ser utilizados para generar una direccin.

6.5) Cdigo FPU

Esta versin utiliza el procesador de coma flotante. No garantizo que los
algoritmos matemticos que he implementado estn optimizados para el mejor
funcionamiento. Adems, no he sido capaz de probarlos (an) y tampoco he
implementado el manejo de la excepcin de coma flotante.

----------------------------------------------------------------------

7.1) Descripcin del rbol de directorio

Las fuentes deberan ser genricas; esto quiere decir que deberan funcionar en
cualquier arquitectura donde el tamao del byte sea de 8 bits. Sin embargo, uso
en mi editor configuraciones de tabulacin extraas. Si quieres comprender los
fuentes coge algn embellecedor de cualquier clase y pasa los fuentes por l
primero; o configura el tabulador de tu editor a 2 si quieres ver lo que yo veo.


La estructura del directorio es:

CLIBS
	varias fuentes para la librera run-time
DOC
	documentacin
EXAMP
	un ejemplo sencillo
	(hay uno ms complejo en clibs\startup\test)
INCLUDE
	ficheros con las cabeceras del compilador
OBJECT
	ficheros del compilador para crear y de objetos
SOURCE
	ficheros fuente del compilador

Hay dos grupos de fuentes:
   1) el compilador
	en los directorios SOURCE, INCLUDE y OBJECT
   2) libreras que puedes usar conjuntamente
      con el compilador para generar programas (libreras de destino run-time)
	en el directorio CLIBS

A menudo uso la configuracin de triple directorio:
	SOURCE
	OBJECT
	INCLUDE

para un proyecto dado para as no abarrotar un nico directorio con docenas de
ficheros. Cuando surge esta configuracin triple, las fuentes estn en el
directorio SOURCE, las cabeceras de las cuales dependen las fuentes se
encuentran en el directorio INCLUDE y puedes suponer que cambio al directorio
OBJECT para compilar el programa... por lo que encontrars el fichero make
all.

As, para esta configuracin triple, tienes que usar un path de inclusin que
consiste en el directorio INCLUDE cuando compilas los ficheros fuente.

proto.bat genera el fichero INCLUDE\CC.P que es un fichero prototipo que uso
para conseguir que el compilador sea honesto conmigo. No deberas tener que
cambiar eso a menos que hagas grandes cambios a las fuentes... pero puedes
editar el fichero CC.P directamente y poner nuevos prototipos en l si lo
deseas. Yo lo hago a menudo. Slo uso proto.bat cuando hago grandes cambios al
compilador.

----------------------------------------------------------------------

7.2) Portabilidad

Se pretende que esta versin del compilador sea portable; uno slo necesita
volver a escribir el back end para el destino deseado. Esta portabilidad
probablemente se extiende slo a los procesadores con una arquitectura de
'byte'.

Los siguientes smbolos tienen que ser definidos en la lnea de comando:

-DPROGNAME="CC68K"              ; Nombre del programa, el cual aparecer en el
				  anuncio

 -DENVNAME="CC68K"              ; Nombre de la variable de entorno que se debe
				  consultar para los parmetros de la lnea de
				  comando

-DGLBDEFINE="_m68k_"            ; Smbolo a definir en la fuente; puede usarse
				  para identificar necesidades especficas del
				  procesador

-DSOURCEXT=".SRC"               ; Extensin a usar en el fichero de salida

Estas definiciones son importadas de CMAIN.C para definir el entorno del
programa. Te he mostrado las definiciones usadas por el compilador 386;
cmbialas como sea necesario para tu objetivo.

Los siguientes ficheros forman el back end del 386. Estos deberan ser todo lo
que tendras que cambiar para trasladar el compilador a otro procesador. Te
sugiero que los renombres antes de cambiarlos:

an68.c          - Registro de optimizacin
reg68.c         - Registro de situacin para expresiones
conf68.c        - configuracin; tamaos de inicio y registros libres
outas68.c       - cdigo de salida de ASM
gexpr68.c       - convierte los rboles de interpretacin de expresiones en
		  cdigo
gstmt68.c       - convierte los rboles de interpretacin de stmt en cdigo
peep68.c        - Anlisis de 'mirilla' para este procesador

Para ms informacin sobre la portabilidad contacta con el autor del cdigo.

David Lindauer (gclind01@starbase.spd.louisville.edu)
