<?php
include("phpchartdir.php");

#The data for the area chart
$data = array(25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
	58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22);

#The labels for the area chart
$labels = array("0", "", "", "3", "", "", "6", "", "", "9", "", "", 
	"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24");

#First, create a XYChart of size 300 pixels x 280 pixels
$c = new XYChart(300, 280);

#the plotarea at (50, 25) and of 200 pixel (w) x 200 pixels (h)
$c->setPlotArea(50, 25, 200, 200);

#Add a title to the chart
$c->addTitle("Daily Server Load");
	
#Add a title to the y axis
$c->yAxis->setTitle("MBytes");

#Add a title to the x axis
$c->xAxis->setTitle("June 12, 2001");

#the x axis labels using the supplied labels
$c->xAxis->setLabels($labels);

#Add an area layer to the chart
$layer = $c->addAreaLayer();

#Add a data set to the area layer, and set the data color to 
#light blue (0xa8a8ff) and the line color to blue (0x0000ff)
$dataSet = $layer->addDataSet($data);
$dataSet->setDataColor(0xa8a8ff, 0x0000ff);

#the line width to 3 pixels to highlight the line
$layer->setLineWidth(3);

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>