<?php
include("phpchartdir.php");

#The data for the chart
$data0 = array(100, 125, 245.78, 147, 67);
$data1 = array(85, 156, 179.5, 211, 123);
$data2 = array(97, 187, 156, 237, 157);
$labels = array("Mon", "Tue", "Wed", "Thu", "Fri");

#Create a XYChart object of size 300 x 300
$c = new XYChart(300, 300);

#the plot area at (50, 40) and of size 240 x 200
$c->setPlotArea(50, 40, 240, 200);

switch ($HTTP_GET_VARS["img"]) {
case 0 :
	#add legends on the top of the chart (60, 10) using horizontal layout.
	#set the font to 8 points, and hide the legend box boundary (Transparent)
	$legendBox = $c->addLegend(60, 10, 0, "", 8);
	break;
case 1 :
	#add legends on the top of the plot area (60, 28) using horizontal layout
	#set the font to 8 points, and hide the legend box boundary (Transparent)
	$legendBox = $c->addLegend(60, 28, 0, "", 8);
	#reserve 20 pixels at the top of the plot area to ensure the legend keys
	#will not overlap with the charts
	$c->yAxis->setTopMargin(20);
	break;
default :
	#add legends on the bottom of the chart (60, 260) using horizontal layout
	#set the font to 8 points, and hide the legend box boundary (Transparent)
	$legendBox = $c->addLegend(60, 260, 0, "", 8);
}

#hide the legend box boundary (Transparent)
$legendBox->setBackground(Transparent, Transparent);

#Add a title to the y-axis
$c->yAxis->setTitle("Throughput (MBytes Per Hour)");

#the labels on the x axis
$c->xAxis->setLabels($labels);

#Use non-indented x-axis layout
$c->xAxis->setIndent(0);

#Add 3 differnet layers using the given data sets
$lineLayer = $c->addLineLayer($data0, 0x4040ff, "Server 1");
$lineLayer->setLineWidth(3);
$barLayer = $c->addBarLayer($data1, 0xff8080, "Server 2");
$barLayer->set3D();
$areaLayer = $c->addAreaLayer($data2, 0x80ff80, "Server 3");
$areaLayer->set3D();

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>
 