<?php
include("phpchartdir.php");

#query string to determine the starting angle and direction
if ($HTTP_GET_VARS["img"] == "0") {
	$angle = 0;
	$clockwise = 1;
}
else {
	$angle = 90;
	$clockwise = 0;
}

#The data for the pie chart
$data = array( 25, 18, 15, 12, 8, 30, 35 );

#The labels for the pie chart
$labels = array( "Labor", "Licenses", "Taxes", "Legal", 
	"Insurance", "Facilities", "Production" );

#First, create a PieChart of size 280 pixels x 240 pixels
$c = new PieChart(280, 240);

#the center of the pie at (140, 130) and the radius to 80 pixels
$c->setPieSize(140, 130, 80);

#add a title to the pie to show the start angle and direction
if ($clockwise) 
	$c->addTitle( 
		"Start Angle = $angle degrees\nDirection = Clockwise");
else  
	$c->addTitle( 
		"Start Angle = $angle degrees\nDirection = AntiClockwise");

#the pie start angle and direction
$c->setStartAngle($angle, $clockwise);

#Draw the pie in 3D
$c->set3D();

#the pie data and the pie labels
$c->setData($data, $labels);

#Explode the 1st sector
$sectorObj = $c->sector(0);
$sectorObj->setExplode();

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>