use perlchartdir;


sub logaxis
{
	my ($logaxis, $filename) = @_;

	#data for the chart
	my $data = [100, 125, 260, 147, 67];
	my $labels = ["Mon", "Tue", "Wed", "Thur", "Fri"];

	#create a XYChart object of size 200 x 180
	my $c = new XYChart(200, 180);
	
	#set the plot area to start at (30, 10) and of size 140 x 130
	$c->setPlotArea(30, 10, 140, 130);

	#use log scale axis if required
	if ($logaxis) {
		$c->yAxis()->setLogScale();
	}
	
	#Set the labels on the x axis
	$c->xAxis()->setLabels($labels);

	#Add a bar layer using the supplied data
	$c->addBarLayer($data);
	
	#output the chart as a PNG file
	$c->makeChart($filename);
}


logaxis(0, "linearaxis.png");
logaxis(1, "logaxis.png");
