use perlchartdir;


sub main
{
	#The data for the pie chart
	my $data = [ 25, 18, 15, 12, 8, 30, 35 ];

	#The labels for the pie chart
	my $labels = [ "Labor", "Licenses", "Taxes", "Legal",
		"Insurance", "Facilities", "Production" ];

	#First, create a PieChart of size 480 pixels x 300 pixels
	my $c = new PieChart(480, 300);

	#Set the center of the pie at (150, 150) and the radius to 100 pixels
	$c->setPieSize(150, 150, 100);

	#Add a title to the pie chart, using the font Monotype Corsiva ("mtcorsva")
	#and font size of 20 points. text color is deep blue (0x000080)
	$c->addTitle("Project Cost Breakdown", "mtcorsva.ttf", 20, 0x000080);

	#Draw the pie in 3D
	$c->set3D();

	#add a legend box using the font Times New Romans Bold ("timesbd.ttf") and
	#set the font size to 12 points. Set the background color of the legend box
	#to light gray (0xd0d0d0), and the border to blue (0x0000ff).
	$c->addLegend(340, 80, 1, "timesbd.ttf", 12)
		->setBackground(0xd0d0d0, 0x0000ff);

	#set the default font for all sector labels to Impact ("impact.ttf") and 
	#font size to 8 points font color is set to drak green (0x008000).
	$c->setLabelStyle("impact.ttf", 8, 0x008000);
	
	#Set the pie data and the pie labels
	$c->setData($data, $labels);

	#Explode the 3rd sector
	$c->sector(2)->setExplode(40);

	#Use Impact/12 points/Red color as font for the 3rd sector
	$c->sector(2)->setLabelStyle("impact.ttf", 12, 0xff0000);
	
	#Use default font (Arial)/8 points/Deep Blue color as the font for the 
	#labels for the 5th sector
	$c->sector(4)->setLabelStyle("", 8, 0x000080);

	#Use Times New Romans/8 points/Deep Red color as the font for the 6th sector
	$c->sector(5)->setLabelStyle("times.ttf", 8, 0x800000);

	#Use Impact/8 points/Deep Greencolor as the font for the 7th sector. 
	#In addition, add a background box to the label filled with yellow color 
	#(0xffff00) with a black (0x000000) border.
	$c->sector(6)->setLabelStyle("impact.ttf", 8, 0x008000)
		->setBackground(0xffff00, 0x000000);

	#output the chart as a PNG file
	$c->makeChart("fontpie.png");
}


main()
   