use perlchartdir;


sub threedanglepie
{
	my ($angle, $filename) = @_;

	#The data for the pie chart
	my $data = [ 25, 18, 15, 12, 8, 30, 35 ];

	#First, create a PieChart of size 100 pixels x 110 pixels
	my $c = new PieChart(100, 110);

	##Set the center of the pie at (50, 55) and the radius to 38 pixels
	$c->setPieSize(50, 55, 38);

	##Set the depth and tilt angle of the 3D pie (-1 means auto depth)
	$c->set3D(-1, $angle);

	##/Add a title showing the tilt angle
	$c->addTitle(sprintf("Tilt = %d deg", $angle), "arial.ttf", 8);

	##Set the pie data and the pie labels
	$c->setData($data);

	##Disable the sector labels by setting the color to transparent
	$c->setLabelStyle("", 8, $perlchartdir::Transparent);

	##output the chart
	$c->makeChart($filename);
}


threedanglepie(0, "tilt0pie.png");
threedanglepie(15, "tilt15pie.png");
threedanglepie(30, "tilt30pie.png");
threedanglepie(45, "tilt45pie.png");
threedanglepie(60, "tilt60pie.png");
threedanglepie(75, "tilt75pie.png");
