// PhilosopherTask.cpp: implementation of the PhilosopherTask class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PhilosopherTask.h"
#include "Report.h"
#include "TableTop.h"

//////////////////////////////////////////////////////////////////////
// Static Utilities
//////////////////////////////////////////////////////////////////////

#define MAX_WAIT 7000
#define MIN_WAIT 1000

static Milliseconds random_time()
{
	return (rand() % (MAX_WAIT - MIN_WAIT)) + MIN_WAIT;
}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PhilosopherTask::PhilosopherTask(int id)
{
	this->id = id;
	this->activate();
}

PhilosopherTask::~PhilosopherTask()
{
	this->terminate();
}

//////////////////////////////////////////////////////////////////////
// Member Functions
//////////////////////////////////////////////////////////////////////

void PhilosopherTask::body()
{
	// Initialize the random number generator
	srand((unsigned int)time(NULL) + 2047*this->id);

	this->state = thinking;	// Initial state

	while (!Report::end_flagged()) {
		Milliseconds time;

		switch (this->state) {
		case thinking:
			time = random_time();
			Report::update_philosopher_state(this->id, this->state, time);
			delay(time);

			this->state = waiting;
			break;
		case waiting:
			Report::update_philosopher_state(this->id, this->state, 0);
			TableTop::grab_forks(this->id);

			this->state = eating;
			break;
		case eating:
			time = random_time();
			Report::update_philosopher_state(this->id, this->state, time);
			delay(time);
			TableTop::release_forks(this->id);

			this->state = thinking;
			break;
		}
	}
	TableTop::release_forks(this->id);
}

Priority PhilosopherTask::priority()
{
	return low_Priority;
}

size_t PhilosopherTask::virtual_sizeof()
{
	return sizeof(PhilosopherTask);
}

