// AboutTask.cpp: implementation of the AboutTask class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "AboutTask.h"
#include "Report.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

AboutTask::AboutTask(HINSTANCE hInstance, HWND hWnd)
{
	this->hInstance = hInstance;
	this->hWnd = hWnd;
	this->activate();
}

AboutTask::~AboutTask()
{
	this->terminate();
}

//////////////////////////////////////////////////////////////////////
// Member Function
//////////////////////////////////////////////////////////////////////

void AboutTask::body()
{
	DialogBox(this->hInstance, 
				(LPCTSTR)IDD_ABOUTBOX, this->hWnd, about_handler);
}

Priority AboutTask::priority()
{
	return highest_Priority;
}

size_t AboutTask::virtual_sizeof()
{
	return sizeof(AboutTask);
}

// Mesage handler for about box.
BOOL CALLBACK AboutTask::about_handler
	(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	AboutTask *this_task = (AboutTask*)current_task();

	switch (message) {
	case WM_INITDIALOG: {
		char text_str[256];

		Report::make_versioned_string
			(text_str, 256, "DiningPhilosophers %s", this_task->hInstance);
		SetDlgItemText(hDlg, IDC_ABOUTTEXT, text_str);
		this_task->hDlg = hDlg;
		return true;
						}
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
			EndDialog(hDlg, IDOK);
			return true;
		case IDCANCEL:
			EndDialog(hDlg, IDCANCEL);
			return true;
		}
		break;
	}
    return false;
}

