/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TSpinner
extends Panel
implements ActionListener {
    protected int min;
    protected int max;
    protected int current;
    protected String text;
    protected TextField textField;
    protected int increment;
    protected ActionListener actionListener = null;
    protected SpinButtonPanel buttonPanel;
    protected int gap = 2;
    boolean editable;
    boolean wrappable;
    int previous = 0;

    public TSpinner() {
        super.setLayout(null);
        this.buttonPanel = new SpinButtonPanel();
        this.add(this.buttonPanel);
        this.textField = new TextField("0", 1);
        this.textField.setBackground(Color.white);
        this.add(this.textField);
        this.increment = 1;
        this.min = 0;
        this.max = 0;
        this.current = 0;
        this.setEditable(true);
        this.setWrappable(false);
        this.previous = 0;
        this.buttonPanel.addActionListener(this);
        this.textField.addActionListener(this);
    }

    public TSpinner(int n, int n2, int n3) {
        this();
        this.setMin(n2);
        this.setMax(n3);
        this.setCurrent(n);
        this.previous = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.buttonPanel.setBounds(n3 - 20, 0, 20, 20);
        this.textField.setBounds(0, 0, n3 - 20, 20);
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.textField.setEditable(bl);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setWrappable(boolean bl) {
        this.wrappable = bl;
        this.updateButtonStatus();
    }

    public boolean isWrappable() {
        return this.wrappable;
    }

    public void setMin(int n) {
        this.min = n;
        this.setCurrent(this.current);
        this.updateButtonStatus();
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int n) {
        this.max = n;
        this.setCurrent(this.current);
        this.updateButtonStatus();
    }

    public int getMax() {
        return this.max;
    }

    public void setCurrent(int n) {
        this.current = n;
        if (this.current < this.min) {
            this.current = this.min;
        }
        if (this.current > this.max) {
            this.current = this.max;
        }
        this.setText(this.current);
        this.updateButtonStatus();
    }

    public int getCurrent() {
        return this.current;
    }

    public void setNotifyWhilePressed(boolean bl) {
        this.buttonPanel.setNotifyWhilePressed(bl);
    }

    public boolean isNotifyWhilePressed() {
        return this.buttonPanel.isNotifyWhilePressed();
    }

    public void setDelay(int n) {
        this.buttonPanel.setDelay(n);
    }

    public int getDelay() {
        return this.buttonPanel.getDelay();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public Dimension getPreferredSize() {
        int n = 50;
        int n2 = 20;
        Dimension dimension = this.textField.getPreferredSize();
        Dimension dimension2 = this.buttonPanel.getPreferredSize();
        int n3 = 0;
        int n4 = 0;
        n = dimension2.width + dimension.width + this.gap + n4;
        n2 = dimension.height + n3;
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected boolean isValidCurrent(int n) {
        return n <= this.max && n >= this.min;
    }

    protected boolean isValidMax(int n) {
        return n >= this.min;
    }

    protected boolean isValidMin(int n) {
        return n <= this.max;
    }

    protected void sourceActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    protected void scrollUp() {
        int n = this.current + this.increment;
        if (n > this.max) {
            n = this.wrappable ? this.min : this.max;
        }
        this.setCurrent(n);
    }

    protected void scrollDown() {
        int n = this.current - this.increment;
        if (n < this.min) {
            n = this.wrappable ? this.max : this.min;
        }
        this.setCurrent(n);
    }

    public void setText(int n) {
        this.textField.setText(Integer.toString(n));
    }

    public String getText() {
        return this.textField.getText();
    }

    public boolean isModified() {
        boolean bl = this.previous != this.current;
        this.previous = this.current;
        return bl;
    }

    protected void updateButtonStatus() {
        if (this.buttonPanel != null) {
            if (this.wrappable) {
                this.buttonPanel.setUpButtonEnabled(true);
                this.buttonPanel.setDownButtonEnabled(true);
            } else if (this.current == this.max && this.current == this.min) {
                this.buttonPanel.setUpButtonEnabled(false);
                this.buttonPanel.setDownButtonEnabled(false);
            } else if (this.current == this.max) {
                this.buttonPanel.setUpButtonEnabled(false);
                this.buttonPanel.setDownButtonEnabled(true);
            } else if (this.current == this.min) {
                this.buttonPanel.setUpButtonEnabled(true);
                this.buttonPanel.setDownButtonEnabled(false);
            } else {
                this.buttonPanel.setUpButtonEnabled(true);
                this.buttonPanel.setDownButtonEnabled(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Increment")) {
            this.scrollUp();
            this.sourceActionEvent("ScrollUp");
        } else if (string.equals("Decrement")) {
            this.scrollDown();
            this.sourceActionEvent("ScrollDown");
        } else {
            this.setCurrent(new Integer(this.textField.getText()));
            this.sourceActionEvent("Enter");
            return;
        }
    }
}

