// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "AdoSample.h"
#include "ChildView.h"
#include "AdoDialog.h"
#include "AdoEdit.h"
#include "ModemDialog.h"
#include "ListDialog.h"
#include "AdoPropSheet.h"
#include "AdoPropPage.h"
#include "AdoCheck.h"
#include "AdoCombo.h"
#include "Cust1Page.h"
#include "Cust2Page.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
}

CChildView::~CChildView()
{
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_COMMAND(ID_FILE_MODEM, OnFileModem)
	ON_COMMAND(ID_FILE_CUSTOMER_NEW, OnFileCustomerNew)
	ON_COMMAND(ID_FILE_CUSTOMER_OPEN, OnFileCustomerOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Do not call CWnd::OnPaint() for painting messages
}


void CChildView::OnFileModem() 
{
	AdoRecordset rs;
	try {
		rs = "select * from Modem";
		CModemDialog Mod;
		CListDialog Lis(rs, &Mod);
		Lis.SetCaption("Modem Listing");
		Lis.DoModal();
	}
	catch(_com_error& e) {
		Show(e, *this);
	}
}

void CChildView::OnFileCustomerNew() 
{
	try {
		CAdoPropSheet Prop("Customer Data", "Customer", true);
		Prop.AddPage(new CCust1Page);
		Prop.AddPage(new CCust2Page);
		Prop.DoModal();
	}
	catch(_com_error& e) {
		Show(e, *this);
	}
}

void CChildView::OnFileCustomerOpen() 
{
	int customer = 0;

	if(InputBox(m_hWnd, "Customer", "Enter Customer ID: ", &customer,
		IN_LONG) == IDCANCEL) return;

	CString sql;
	sql.Format("select * from Customer where CustomerID = %d", customer);

	try {
		CAdoPropSheet Prop("Customer Data", sql);
		Prop.AddPage(new CCust1Page);
		Prop.AddPage(new CCust2Page);
		Prop.DoModal();
	}
	catch(_com_error& e) {
		Show(e, *this);
	}
}
