// DBFTable.cpp: implementation of the CDBFTable class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "DBFTable.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDBFTable::CDBFTable()
{
	memset(&m_pTable, 0, sizeof(DBFTable));

}

CDBFTable::~CDBFTable()
{
	Close();
}

//////////////////////// Open ///////////////////////////////////////
BOOL CDBFTable::Open(const char* sFileName)
{
	return (DBFOpen(sFileName, &m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// Open ///////////////////////////////////////
BOOL CDBFTable::Create(const char* sFileName, int fCount, const DBFField* pDBFField)
{
	if(DBFCreate(sFileName, fCount, pDBFField) == DBF_E_NO_ERROR)
	{
		return (DBFOpen(sFileName, &m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
	}
	return FALSE;
}

//////////////////////// Close //////////////////////////////////////
BOOL CDBFTable::Close(void)
{
	return (DBFClose(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// Pack ///////////////////////////////////////
BOOL CDBFTable::Pack(void)
{
	return (DBFPack(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// GetLastError ///////////////////////////////
DBF_Error_Code CDBFTable::GetLastError(void)
{
	return DBFGetLastError(&m_pTable, NULL, 0);
}

DBF_Error_Code CDBFTable::GetLastError(CString& sErrorMsg)
{
	char*	tBuf = new char[81];
	DBF_Error_Code err = DBFGetLastError(&m_pTable, tBuf, 80);
	sErrorMsg = tBuf;
	delete [] tBuf;
	return err;
}

//////////////////////// IsOpen /////////////////////////////////////
BOOL CDBFTable::IsOpen(void)
{
	return DBFIsOpen(&m_pTable);
}

//////////////////////// GetFields //////////////////////////////////
const DBFField* CDBFTable::GetFields(void)
{
	return DBFGetFields(&m_pTable);
}

//////////////////////// GetRecordCount /////////////////////////////
long CDBFTable::GetRecordCount(void)
{
	return DBFGetRecCount(&m_pTable);
}

//////////////////////// GetRecordLength ////////////////////////////
long CDBFTable::GetRecordLength(void)
{
	return DBFGetRecLen(&m_pTable);
}

//////////////////////// GetFieldCount //////////////////////////////
long CDBFTable::GetFieldCount(void)
{
	return DBFGetFieldCount(&m_pTable);
}

//////////////////////// GetRecordNumber ////////////////////////////
long CDBFTable::GetRecordNumber(void)
{
	return DBFGetRecNo(&m_pTable);
}

//////////////////////// GetRelRecordNumber /////////////////////////
long CDBFTable::GetRelRecordNumber(void)
{
	return DBFGetNonDeletedRecNo(&m_pTable);
}

//////////////////////// GetRecNo ///////////////////////////////////
long CDBFTable::GetRecNo(void)
{
	return (GetShowDeleted()) ? GetRecordNumber() : GetRelRecordNumber();
}

//////////////////////// GetVersion /////////////////////////////////
CString CDBFTable::GetVersion(void)
{
    return CString(DBFGetVersion(&m_pTable));
}

//////////////////////// GetFileName ////////////////////////////////
CString CDBFTable::GetFileName(void)
{
	return CString(DBFGetFileName(&m_pTable));
}

//////////////////////// GetFileName ////////////////////////////////
BOOL CDBFTable::IsRecordDeleted(void)
{
	return DBFIsRecordDeleted(&m_pTable);
}

//////////////////////// GetShowDeleted /////////////////////////////
BOOL CDBFTable::GetShowDeleted(void)
{
	return DBFGetShowDeleted(&m_pTable);
}

//////////////////////// SetShowDeleted /////////////////////////////
BOOL CDBFTable::SetShowDeleted(BOOL bShow)
{
	DBFSetShowDeleted(&m_pTable, bShow);
	return (DBFSetShowDeleted(&m_pTable, bShow) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// IsBOF //////////////////////////////////////
BOOL CDBFTable::IsBOF(void)
{
	return DBFIsBOF(&m_pTable);
}

//////////////////////// IsEOF //////////////////////////////////////
BOOL CDBFTable::IsEOF(void)
{
	return DBFIsEOF(&m_pTable);
}

//////////////////////// GoTop //////////////////////////////////////
BOOL CDBFTable::GoTop(void)
{
	return (DBFTop(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// GoBottom ///////////////////////////////////
BOOL CDBFTable::GoBottom(void)
{
	return (DBFBottom(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// Skip ///////////////////////////////////////
BOOL CDBFTable::Skip(long count)
{
	return (DBFSkip(&m_pTable, count) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// GoToRecord /////////////////////////////////
BOOL CDBFTable::GoToRecord(long recno)
{
	return (DBFGoTo(&m_pTable, recno) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// GoToNonDeletedRecord ///////////////////////
BOOL CDBFTable::GoToNonDeletedRecord(long recno)
{
	return (DBFGoToNonDeleted(&m_pTable, recno) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// MoveTo /////////////////////////////////////
BOOL CDBFTable::MoveTo(long recno)
{
	return (GetShowDeleted()) ? GoToRecord(recno) : GoToNonDeletedRecord(recno);
}

//////////////////////// Append /////////////////////////////////////
BOOL CDBFTable::Append(void)
{
	return (DBFAppend(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// Delete /////////////////////////////////////
BOOL CDBFTable::Delete(void)
{
	return (DBFDelete(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// Recall /////////////////////////////////////
BOOL CDBFTable::Recall(void)
{
	return (DBFRecall(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// Edit ///////////////////////////////////////
BOOL CDBFTable::Edit(void)
{
	return (DBFEdit(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// Post ///////////////////////////////////////
BOOL CDBFTable::Post(void)
{
	return (DBFPost(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// Cancel /////////////////////////////////////
BOOL CDBFTable::Cancel(void)
{
	return (DBFCancel(&m_pTable) == DBF_E_NO_ERROR) ? TRUE : FALSE;
}

//////////////////////// GetString //////////////////////////////////
CString CDBFTable::GetString(const char* pszFieldName)
{
	CString sRet;
	int fNumber;
	
	if(DBFGetFieldNumber(&m_pTable, pszFieldName, &fNumber) == DBF_E_NO_ERROR)
	{
		return GetString(fNumber);
	}

	sRet.Empty();
	return sRet;
}

CString CDBFTable::GetString(int fieldNumber)
{
	CString sRet;
	const DBFField* pFieldArray = DBFGetFields(&m_pTable);
	int		len = (pFieldArray[fieldNumber].FieldType == DBF_FIELD_TYPE_DATE)
						? 11 : pFieldArray[fieldNumber].FieldLen + 1;
	char* tBuf = new char[len];

	sRet.Empty();
	
	if(DBFGetCharacterByNumber(&m_pTable, fieldNumber, tBuf, len) == DBF_E_NO_ERROR)
	{
		sRet = tBuf;
	}

	delete [] tBuf;

	return sRet;
}

//////////////////////// GetInt /////////////////////////////////////
int CDBFTable::GetInt(const char* pszFieldName)
{
	int iValue;

	DBFGetIntByName(&m_pTable, pszFieldName, &iValue);

	return iValue;
}

int CDBFTable::GetInt(int fieldNumber)
{
	int iValue;

	DBFGetIntByNumber(&m_pTable, fieldNumber, &iValue);

	return iValue;
}

//////////////////////// GetLong ////////////////////////////////////
long CDBFTable::GetLong(const char* pszFieldName)
{
	long lValue;

	DBFGetLongByName(&m_pTable, pszFieldName, &lValue);

	return lValue;
}

long CDBFTable::GetLong(int fieldNumber)
{
	long lValue;

	DBFGetLongByNumber(&m_pTable, fieldNumber, &lValue);

	return lValue;
}

//////////////////////// GetDouble //////////////////////////////////
double CDBFTable::GetDouble(const char* pszFieldName)
{
	double fValue;

	DBFGetDoubleByName(&m_pTable, pszFieldName, &fValue);

	return fValue;
}

double CDBFTable::GetDouble(int fieldNumber)
{
	double fValue;

	DBFGetDoubleByNumber(&m_pTable, fieldNumber, &fValue);

	return fValue;
}

//////////////////////// GetLogical /////////////////////////////////
BOOL CDBFTable::GetLogical(const char* pszFieldName)
{
	BOOL bValue;

	DBFGetLogicalByName(&m_pTable, pszFieldName, &bValue);

	return bValue;
}

BOOL CDBFTable::GetLogical(int fieldNumber)
{
	BOOL bValue;

	DBFGetLogicalByNumber(&m_pTable, fieldNumber, &bValue);

	return bValue;
}

//////////////////////// GetDate ////////////////////////////////////
CTime CDBFTable::GetDate(const char* pszFieldName)
{
	DBFDate dValue;

	DBFGetDateByName(&m_pTable, pszFieldName, &dValue);

	return CTime(dValue.year, dValue.month, dValue.day, 0, 0, 0);
}

CTime CDBFTable::GetDate(int fieldNumber)
{
	DBFDate dValue;

	DBFGetDateByNumber(&m_pTable, fieldNumber, &dValue);

	return CTime(dValue.year, dValue.month, dValue.day, 0, 0, 0);
}

//////////////////////// GetStringField /////////////////////////////
CString CDBFTable::GetStringField(const char* pszFieldName)
{
	CString sRes = GetString(pszFieldName);
	sRes.TrimLeft();
	sRes.TrimRight();
    return sRes;
}

CString CDBFTable::GetStringField(int fieldNumber)
{
	CString sRes = GetString(fieldNumber);
	sRes.TrimLeft();
	sRes.TrimRight();
    return sRes;
}

//////////////////////// PutString //////////////////////////////////
BOOL CDBFTable::PutString(const char* pszFieldName, const char* sValue)
{
	return (DBFPutCharacterByName(&m_pTable, pszFieldName, sValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

BOOL CDBFTable::PutString(int fieldNumber, const char* sValue)
{
	return (DBFPutCharacterByNumber(&m_pTable, fieldNumber, sValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;

}

//////////////////////// PutInt /////////////////////////////////////
BOOL CDBFTable::PutInt(const char* pszFieldName, int iValue)
{
	return (DBFPutIntByName(&m_pTable, pszFieldName, iValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

BOOL CDBFTable::PutInt(int fieldNumber, int iValue)
{
	return (DBFPutIntByNumber(&m_pTable, fieldNumber, iValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

//////////////////////// PutLong ////////////////////////////////////
BOOL CDBFTable::PutLong(const char* pszFieldName, long lValue)
{
return (DBFPutLongByName(&m_pTable, pszFieldName, lValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

BOOL CDBFTable::PutLong(int fieldNumber, long lValue)
{
	return (DBFPutLongByNumber(&m_pTable, fieldNumber, lValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

//////////////////////// PutDouble //////////////////////////////////
BOOL CDBFTable::PutDouble(const char* pszFieldName, double fValue)
{
	return (DBFPutDoubleByName(&m_pTable, pszFieldName, fValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

BOOL CDBFTable::PutDouble(int fieldNumber, double fValue)
{
	return (DBFPutDoubleByNumber(&m_pTable, fieldNumber, fValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

//////////////////////// PutLogical /////////////////////////////////
BOOL CDBFTable::PutLogical(const char* pszFieldName, BOOL bValue)
{
	return (DBFPutLogicalByName(&m_pTable, pszFieldName, bValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

BOOL CDBFTable::PutLogical(int fieldNumber, BOOL bValue)
{
	return (DBFPutLogicalByNumber(&m_pTable, fieldNumber, bValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

//////////////////////// PutDate ////////////////////////////////////
BOOL CDBFTable::PutDate(const char* pszFieldName, CTime& dValue)
{
	DBFDate dbValue;
	dbValue.year	=	dValue.GetYear();
	dbValue.month	=	dValue.GetMonth();
	dbValue.day		=	dValue.GetDay();

	return (DBFPutDateByName(&m_pTable, pszFieldName, &dbValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}

BOOL CDBFTable::PutDate(int fieldNumber, CTime& dValue)
{
	DBFDate dbValue;
	dbValue.year	=	dValue.GetYear();
	dbValue.month	=	dValue.GetMonth();
	dbValue.day		=	dValue.GetDay();

	return (DBFPutDateByNumber(&m_pTable, fieldNumber, &dbValue) == DBF_E_NO_ERROR)
		? TRUE : FALSE;
}


/////////////////////////////////////////////////////////////////////
// Obsolete functions - only for compatibility
/////////////////////////////////////////////////////////////////////


BOOL CDBFTable::GetDeleted(void)
{
	return IsRecordDeleted();
}

BOOL CDBFTable::GetBOF(void)
{
	return IsBOF();
}

BOOL CDBFTable::GetEOF(void)
{
	return IsEOF();
}

BOOL CDBFTable::MoveTop(void)
{
	return GoTop();
}

BOOL CDBFTable::MoveBottom(void)
{
	return GoBottom();
}


double CDBFTable::GetFloatField(CString sFieldName)
{
    return GetDouble(sFieldName);
}

BOOL CDBFTable::GetBoolField(CString sFieldName)
{
    return GetLogical(sFieldName);
}

CTime CDBFTable::GetDateField(CString sFieldName)
{
    return GetDate(sFieldName);
}

BOOL CDBFTable::SetStringField(CString sFieldName, CString sValue)
{
    return PutString(sFieldName, sValue);
}

BOOL CDBFTable::SetFloatField(CString sFieldName, double fValue)
{
    return PutDouble(sFieldName, fValue);
}

BOOL CDBFTable::SetBoolField(CString sFieldName, BOOL bValue)
{
    return PutLogical(sFieldName, bValue);
}

BOOL CDBFTable::SetDateField(CString sFieldName, CTime dtValue)
{
    return PutDate(sFieldName, dtValue);
}

