#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                 * invoiceTracker  
g-- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered,gStack,gPrevCard
  put "invoiceTracker" into gStack
  if the short name of this stack <> gStack then exit openStack
  if gRegistered is empty then
    open stack "launcher"
  else
    lock screen
    if field "date" of card 1 is empty then
      go first card
      put the long date into field "date"
      put "10001" into field "invoice"
    else
      if gPrevCard is not empty then
        go card gPrevCard
      else
        go last card
      end if
    end if
    saveData
    setArrows
    unlock screen with visual plain
  end if
end openStack

on checkCompleted
  if the number of cards = 1 and field "project" is empty then exit checkCompleted
  if field "project" is empty OR field "date" is empty OR field "duedate" is empty OR field "amount" is empty then
    answer warning "This record is missing information about the invoice" & return & \
        "date, project or invoice amount or the due date and"  & return & \
        "will not be included in any report."  \
        with "Fix later" or "Delete Record" or "Fix now"
    unlock screen
    if it is "fix now" then
      if field "project" is empty then send mouseUp to button "select project"
      if field "date" is empty then send mouseUp to button "choose"
      if field "duedate" is empty then send mouseUp to field "duedate"
      if field "amount" is empty then send mouseUp to field "amount"
      exit to metaCard
    end if
    if it is "Delete Record"  then
      if the number of cards > 1 then
        lock screen
        put the number of this card into cardNum
        delete this card
        go card cardNum
        unlock screen
      else
        clearCardOne
      end if
      repeat with i = 1 to the number of cards
        put i into field "record" of card i
      end repeat
    end if
  end if
end checkCompleted

on clearCardOne
  put the number of field "date" into firstField
  repeat with i = firstField to the number of fields
    put empty into field i
  end repeat
  put 1 into field "record"
end clearCardOne

on version
  ask "Enter a new version" with field "version" of stack "iprefs"
  put it into field "version" of stack "iprefs"
end version

on openCard
  if the short name of this stack is "invoiceTracker" then
    saveData
  end if
end openCard

on closeCard
  global gDontSave
  if gDontSave then
    put false into gDontSave
    exit closeCard
  end if
  if the short name of this stack is "invoiceTracker" then
    checkData
  else
    set cursor to watch
    save this stack
  end if
end closeCard
  w         CC Aquamarine    white        
       ^ Invoice Tracker      W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U monaco  	 U monaco   U 
helvetica 8records,atmain.mc
taskTracker,tasks.mc
passwords,password.mc
launcher,itmain.mc
launcher,sbdmain.mc
launcher,aetmain.mc
launcher,sbmain.mc
writer,whelper.mc
versions,version.mc
vehicleExp,vehexp.mc
invoiceTracker,invoice.mc
inventory,inventry.mc
scheduler,schedule.mc
contacts,contact.mc
calculator,calculat.mc
       	@                  i        
   date1 label   on mouseUp
  ask "Go to the first record with date" with the short date
  if it is empty then exit mouseUp
  convert it to long date
  repeat with i = 1 to the number of cards
    if field "date" of card i is it then
      lock screen
      go card i
      unlock screen with visual plain
      setarrows
      exit mouseUp
    end if
  end repeat
  answer information "No records with that date."
end mouseUp
         
 l            
Invoice Date 
   label2           
 l            
Invoice # 
  E date2 label           p l            	Due Date 
  L date3 label            l            
Date Paid 
  J label4           > l            Invoice Amount 
   label5                        Notes 
   label6           p v            Partial Payments 
   label7           > l            Project    New Ex  on mouseUp
  global gRegistered
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    toplevel  "Register"
    exit mouseUp
  end if
  
  if  field "project" is empty then
    answer information "You need to choose or create a project " & return & \
        "for this record before creating another."
    send mouseUp to button "select project"
    exit mouseUp
  end if
  
  checkCompleted
  answer question "Do you want a new blank record or" & return & " or another record for this project?" \
      with "Blank Record" or  "This Project"
  put it into which
  unlock screen
  lock screen
  lock messages
  put field "project" into zProjectName
  
  if which is "This Project" then
    go last
    create card
    put the number of this card into field "record"
    put zProjectName into field "project"
  end if
  
  if which is "Blank record" then
    go last
    create card
    put the number of this card into field "record"
    send mouseUp to button "select project"
  end if
  
  put 0 into temp
  repeat with i = 1 to the number of cards
    if field "invoice" of card i > temp then
      put field "invoice" of card i into temp
    end if
  end repeat
  put the number of this card into field "record"
  put the long date into field "date"
  put temp + 1 into field "invoice"
  setArrows
  unlock screen with visual plain
end mouseUp
           ዋkk Salmon    & A             	     
   recNumLabel    $on mouseUp
  goCardNum
end mouseUp
         E            	Record # 
   date  	x  Mon mouseUp
  if field "date" is empty then
    put the long date into temp
  else
    put field "date" into temp
  end if
  
  convert temp to short date
  ask "Enter a Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "date"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "date"
  end if
end mouseUp
        
             
   invoice  	x   on mouseUp
  ask "Enter a new invoice number" with field "invoice"
  if it is empty then exit mouseUp
  if it is not a number then
    answer error "Please enter numbers only. Try again."
  else
    put it into field "invoice"
  end if
end mouseUp
                     
   amount  	x  on mouseUp
  global gDollarSign
  ask "Enter an invoice amount" with field "amount"
  if checkNumber(it) is empty then
    put empty into field "amount"
  else
    put validateNumber(it) into temp
    put gDollarSign & setnumber(temp) into field "amount"
  end if
end mouseUp
         S            
   project  	x   Bon mouseUp
  send mouseUp to button "select project"
end mouseUp
        
 S            
  D duedate  	x  ]on mouseUp
  if field "duedate" is empty then
    put the long date into temp
  else
    put field "duedate" into temp
  end if
  
  convert temp to short date
  ask "Enter a Due Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "duedate"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "duedate"
  end if
end mouseUp
        
             
   	partials  )h            H                	`    @ s   F 
  K 	datepaid  	x  on mouseUp
  if field "datepaid" is empty then
    put the long date into temp
  else
    put field "datepaid" into temp
  end if
  
  convert temp to short date
  ask "Enter a Payment Date" with temp
  if it is empty then
    put empty into field "datepaid"
    exit mouseUp
  end if
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "datepaid"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "datepaid"
  end if
end mouseUp
        
             
   notes  )h         
                   	`    @      
   record  x    %on mouseUp
  goCardNum
end mouseUp

       Z  *          1    First @V  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go first
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ዋkk Salmon      * ,  ?         	   	  o    Prev @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go prev
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ዋkk Salmon     * ,  @         	      Next @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go next
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ዋkk Salmon   ?  * ,  A         	      Last @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go last
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ዋkk Salmon   e  * ,  B         	      Delete Ex  Kon mouseUp
  if the number of cards = 1 then
    if field "date" is empty then
      answer information "There are no more records to delete."
    else
      lock screen
      clearCardOne
      put the long date into field "date"
    end if
    exit mouseUp
  end if
  answer question "Delete all records, completed records or just this one?" with "All" or "Completed" or "Just this one" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock messages
  put the number of this card -1 into cardNum
  if it is "completed" then
    repeat with i = the number of cards down to 2
      set cursor to busy
      if field "compdate" of card i <> empty then  delete card i
    end repeat
    
    go card 1
    if field "compdate" of card 1 <> empty then
      if the number of cards  is 1 then
        clearCardOne
        put the long date into field "date"
      else
        delete card 1
      end if
    end if
  end if
  
  if it is "All" then
    lock screen
    repeat with i = the number of cards down to 2
      set cursor to busy
      delete card i
    end repeat
    clearCardOne
    put the long date into field "date"
    setArrows
    unlock screen with visual plain
    exit mouseUp
  end if
  
  if it is "Just this one" then
    lock screen
    if the number of cards > 1 then
      delete this card
    else
      clearCardOne
      put the long date into field "date"
    end if
    go card cardNum
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
           ዋkk Salmon   C& A             	        Find Ex  on mouseUp
  global gFindStack, gFoundOne
  put "atFind" into zFindStack
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 220 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack zFindStack to it
  go card 1 of stack zFindStack
  show stack zFindStack
  select text of field "find" of stack zFindStack
end mouseUp
           ዋkk Salmon    @ A              	        Sort Ex  on mouseUp
  if field "date" is empty then
    answer information "No records to sort."
    exit mouseUp
  end if
  answer question "Sort records by Due Date, Project or Invoice Date?" with  "Cancel" or "Due Date" or "Project" or "Invoice Date"
  if it is "Cancel" then exit mouseUp
  put it into which
  unlock screen
  if which is "Due Date" then put "duedate" into whichField
  if which is "Invoice Date" then put "date" into whichField
  if which is "Project" then put "date" into whichField
  
  lock screen
  lock messages
  repeat with i = 1 to the number of cards
    put empty into temp
    put field whichField of card i into startDate
    convert startDate to dateItems
    repeat with n = 1 to 3
      if item n of startDate < 10 then
        put "0"&item n of startDate after temp
      else
        put item n of startDate after temp
      end if
    end repeat
    put temp into field "Start items" of card i
  end repeat
  
  sort this stack by field "Start items"
  if which is "Project" then sort this stack by field "Project"
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  openCard
  unlock screen with visual plain
end mouseUp
           ዋkk Salmon   C@ A              	        Import Ex  Eon mouseUp
  put the number of cards into znum
  if (the number of cards = 1) and (field "project" is empty) then
    put 1 into firstCard
  else
    answer question "Delete all records first or add to existing?" with "Delete" or "Add" or "Cancel"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Delete" then
      lock messages
      lock screen
      repeat with i = znum down to 2
        set cursor to busy
        delete card i
      end repeat
      put 1 into firstCard
      clearCardOne
      put false into renumberTasks
      unlock screen with visual plain
    else
      go card znum
      if znum = 1 then
        put 1.5 into znum
      end if
      put znum into firstCard
      put true into renumberTasks
    end if
  end if
  importRecords firstCard, renumberTasks -- in this script
  setArrows
  saveData
  unlock screen with visual plain
  set cursor to watch
  save this stack
end mouseUp

on  importRecords  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select an invoice records file to import." with "invoice_records.txt"
  if the result is "Cancel" then exit to metacard
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    if word 1 of temp <> "Invoice" then
      answer error "This is not a valid invoice records file. Try again."
      close file fileName
      exit to metaCard
    end if
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    go card firstCard
    if firstCard = 1.5 then
      add .5 to firstCard
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
    end if
    
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      if NOT item 1 of zline is a date then next repeat
      
      put item 1 of zline into zDate
      put item 2 of zline into field "invoice"
      put item 3 of zline into field "project"
      put item 4 of zline into field "amount"
      put item 5 of zline into dDate
      put item 6 of zline into pDate
      convert zDate to long date
      put zDate into field "Date"
      if dDate <> empty then
        convert dDate to long date
        put dDate into field "duedate"
      end if
      if pDate <> empty then
        convert pDate to long date
        put pDate into field "datepaid"
      end if
      
      put item 7 of zline into enotes
      repeat while offset(" | ",enotes) > 0
        put offset(" | ",enotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of enotes
      end repeat
      put enotes into field "partials"
      
      put item 8 of zline into tNotes
      repeat while offset(" | ",tnotes) > 0
        put offset(" | ",tnotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of tnotes
      end repeat
      put tnotes into field "Notes"
      
      checkList "Projects","Project","iProjects" --  whichList,whichField,whichStack
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importRecords
           ዋkk Salmon    U A              	        Export Ex  on mouseUp
  global gElapsed
  
  if the number of cards is 1 and field "date" is empty then
    answer information "There are no records to export."
    exit mouseUp
  end if
  answer question "Export all records or specific records?" with "All" or "Specific" or "Cancel"
  if it is "Cancel" then exit mouseUp
  put it into exportWhich
  put empty into completed
  put the short date into whichDate
  if it is "Specific" then
    answer question "Export old records, new records or completed records?" with "New" or "Old" or "Completed" or "Cancel"
    if it is "Cancel" then exit mouseUp
    put it into exportWhich
    unlock screen
    if exportWhich is "completed" then
      put true into completed
      put empty into whichDate
      ask file "Save records as... " with "completed_invoices.txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
    end if
    
    if exportWhich is "New" then
      ask "Export records newer than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "invoice_records_newer_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
    
    if exportWhich is "Old" then
      ask "Export records older than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "invoice_records_older_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
  end if
  
  if exportWhich is "all" then
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save records as... " with "all_invoice_records_" & whichDate & ".txt"
    if the result is "Cancel" then exit mouseUp
    put checkExt(it) into fileName
    put empty into whichDate
  end if
  unlock screen
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    put true into noRecords
    write "Invoice Date" & tab & "Invoice #" & tab & "Project" & tab & "Invoice Amount" & tab \
        & "Due Date" & tab & "Date Paid" & tab & "Partial Payments" & tab & "Notes" & return to file fileName
    repeat with i = 1 to the number of cards
      set cursor to busy
      go card i
      put true into exportRecord
      if completed <> empty then
        if field "datepaid" is empty then
          put false into exportRecord
        end if
      end if
      if whichDate<> empty then
        put field "date" into startDate
        convert startDate to seconds
        if exportWhich is "New" then
          if startDate <= whichDate then
            put false into exportRecord
          end if
        else -- exportWhich is "old"
          if startDate >= whichDate then
            put false into exportRecord
          end if
        end if
      end if
      if exportRecord then
        put false into noRecords
        put field "Date" into zDate
        put field "duedate" into dDate
        put field "datepaid" into pDate
        convert zDate to short date
        convert dDate to short date
        convert pDate to short date
        
        put field "partials" into tpartials
        repeat while offset(return,tpartials) > 0
          put " | " into char offset(return,tpartials) of tpartials
        end repeat
        
        put field "notes" into tnotes
        repeat while offset(return,tnotes) > 0
          put " | " into char offset(return,tnotes) of tnotes
        end repeat
        
        write zDate & tab & field "invoice" & tab & field "project" & tab & field "amount" & tab &  \
            dDate & tab & pDate & tab & tpartials & tab & tnotes  & return to file fileName
      end if
    end repeat
    setarrows
    saveData
    unlock screen with visual plain
    close file fileName
    
    if  noRecords then
      answer information "No records were found to export."
    end if
    
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
           ዋkk Salmon   CU A              	        Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
   ዋkk Salmon    j A              	        Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "iHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "invoice tracker", helpStack, zStack
end mouseUp
   ዋkk Salmon   Cj A              	        Quit ux   (on mouseUp
  quitSBTracker
end mouseUp
   ዋkk Salmon     A      Quit          	        Save Ux   Kon mouseUp
  set cursor to watch
  save this stack
  saveData
end mouseUp
   ዋkk Salmon   C A              	        List Invoices Due Ex  on mouseUp
  if the number of cards is 1 and field "project" is empty then
    answer information "There are no records to report."
    exit mouseUp
  end if
  lock screen
  checkCompleted
  checkData
  if the openStacks contains "iReport" then close stack "iReport"
  setHeight "iReport"
  topLevel "iReport"
  setLoc "iReport"
  send mouseUp to button "create report" of stack "iReport"
  unlock screen with visual plain
end mouseUp
   ዋkk Salmon                  	        Today Ex  
 >on mouseUp
  put the long date into field "date"
end mouseUp
   ዋkk Salmon    d  (              	       	 Edit Ex  
 7on mouseUp
  send mouseUp to field "date"
end mouseUp
   ዋkk Salmon      (              	       
 Choose Ex  
}on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "date" into gStartDate
  put "date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose an Entered Date"
  modal stack "dates"
end mouseUp
   ዋkk Salmon      2              	        Edit Ex  
 :on mouseUp
  send mouseUp to field "invoice"
end mouseUp
   ዋkk Salmon   \  (              	     
   start items  !h            t                  F Today Ex  
 Aon mouseUp
  put the long date into field "duedate"
end mouseUp
   ዋkk Salmon    d q (              	       G Edit Ex  
 :on mouseUp
  send mouseUp to field "duedate"
end mouseUp
   ዋkk Salmon     q (              	       H Choose Ex  
~on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "duedate" into gStartDate
  put "duedate" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Due Date"
  modal stack "dates"
end mouseUp
   ዋkk Salmon     q 2              	       M Today Ex  
 Bon mouseUp
  put the long date into field "datepaid"
end mouseUp
   ዋkk Salmon    d  (              	       N Edit Ex  
 ;on mouseUp
  send mouseUp to field "datepaid"
end mouseUp
   ዋkk Salmon      (              	       O Choose Ex  
on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "datepaid" into gStartDate
  put "datepaid" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Payment Date"
  modal stack "dates"
end mouseUp
   ዋkk Salmon      2              	     
  Q 	priority  h         0  P              
Find Project ex  on mouseUp
  global gStack, gButton,gWhichCard
  put the short name of me into gButton
  put the short name of this stack into gStack
  checkCompleted
  answer question "Do you want to go to the first or last " \
      & return & "record for a particular project?" \
      with "Cancel" or "First" or "Last"
  if it is "cancel" then exit mouseUp
  else put it into gWhichCard
  modal stack "iprojects"
end mouseUp
           ዋkk Salmon    H < <      Go To         	        Select Project ex   on mouseUp
  global gStack, gButton
  put the short name of me into gButton
  put the short name of this stack into gStack
  modal stack "iprojects"
end mouseUp
           ዋkk Salmon     < b      Add/Select         	        Edit Ex  
 9on mouseUp
  send mouseUp to field "amount"
end mouseUp
   ዋkk Salmon   \ @ (              	        
Main Menu }    ^on menuPick which
checkCompleted
  set cursor to watch
  goSBTrackerStack which
end menuPick
   ዋkk Salmon    
       Small Business Tracker Menu   Activity && Expense Tracker
Contact Tracker - Address Book
Schedule Tracker - Calendar
Task Tracker - To Do List
-
Inventory Tracker
(Invoice Tracker
Password Tracker
Vehicle Expense Tracker
-
Universal Calculator
Version Tracker
Writer's Helper
Small Business Tracker Welcome
       	        iReport  #on closeCard
  global gDontSave
  put true into gDontSave
  if the visible of group "font" then hide group "font"
end closeCard

function checkItems cardNum
  if field "project" of card cardNum of stack "records" is empty \
      OR field "task" of card cardNum of stack "records" is empty \
      OR field "elapsed" of card cardNum of stack "records" is empty then
    return true
  else
    return false
  end if
end checkItems

on collectData cardnum,invoice
  global gBillHours,gNbillHours, gExpenses,gDollars,gStack,gNotes,gDollarSign
  
  put field "start date" of card cardNum of stack "records"  into zDate
  delete item 3 of zDate
  put field "project" of card cardNum of stack "records" into zProject
  
  put field "task" of card cardNum of stack "records" into zTask
  if invoice and (item 2 of zTask is empty) then
    if offset(ztask,field "task")>0 then -- include this task
      if  the hilite of button "Show Rates" is false then
        put item 1 of field "task" of card cardNum of stack "records" into zTask
      end if
    else
      put "(non-billable activity)" into zTask
    end if
  else
    if the hilite of button "Show Rates" then
      put field "task" of card cardNum of stack "records" into zTask
    else
      put item 1 of field "task" of card cardNum of stack "records" into zTask
    end if
  end if
  
  set the numberFormat to 0.00
  put field "elapsed" of card cardNum of stack "records" into eTime
  put word 1 of eTime  into taskTime -- hours
  if the hilite of button 16 then -- "round times" then
    add roundoff(word 3 of eTime/60) to taskTime -- partial hours
  else
    add (word 3 of eTime/60) to taskTime -- partial hours
  end if
  
  if the number of items of field "task" of card cardNum of stack "records" > 1 then
    put item 2 of field "task" of card cardNum of stack "records" into rate
    add taskTime to gBillHours
    if offset("/hr",rate) = 0 then -- flat rate
      add rate to gDollars
    else
      delete char offset("/hr",rate) to length(rate) of rate
      add (taskTime * rate) to gDollars
    end if
  else
    add taskTime to gNbillHours
  end if
  
  put field "expense amount" of card cardNum of stack "records" into expAmount
  repeat with x = 1 to length(expAmount)
    if char x of expAmount is "-" then
      put true into dontAdd
      delete char x of expAmount
      exit repeat
    else
      put false into dontAdd
    end if
  end repeat
  repeat with x = 1 to length(expAmount)
    if not(char 1 of expAmount is a number) AND (char 1 of expAmount <> ".") then -- delete $ signs
      delete char 1 of expAmount
    else
      exit repeat
    end if
  end repeat
  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
    if dontAdd then
      put "Expense Total = " && gDollarSign & "-" & expAmount into  zExpenseTotal
      subtract expAmount from gExpenses
    else
      put "Expense Total = " && gDollarSign & expAmount into  zExpenseTotal
      add expAmount to gExpenses
    end if
    put "Expense Type = " && field "expense" of card cardNum of stack "records" into  zExpense
  end if
  
  if field "project" <> empty then
    put zDate & tab & zTask & tab & taskTime & return into temp
  else
    put zDate & tab & zProject & tab & zTask & tab & taskTime & return into temp
  end if
  
  if (field "task notes" of card cardNum of stack "records"  <> empty) and (the hilite of button "Show Activity Notes") then
    put "Activity Notes = " & field "task notes" of card cardNum of stack "records" into gNotes
    if length(gNotes) > 100 then
      createLines
    end if
    put gNotes & return after temp
  end if
  
  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
    put zExpense & return after temp
    if field "expense notes" of card cardNum of stack "records"  <> empty then
      put  "Expense Notes = " & field "expense notes" of card cardNum of stack "records" into gNotes
      if length(gNotes) > 100 then
        createLines
      end if
      put gNotes & return after temp
      -- else
      --  put  return after temp
    end if
    put zExpenseTotal & return after temp
  end if
  
  put return after temp
  put temp after field "report" of stack "output"
end collectData


on collectExpenseData cardnum,invoice
  global gBillHours,gNbillHours, gExpenses,gDollars,gStack,gNotes,gDollarSign
  
  put field "start date" of card cardNum of stack "records"  into zDate
  delete item 3 of zDate
  put field "project" of card cardNum of stack "records" into zProject
  put field "expense amount" of card cardNum of stack "records" into expAmount
  repeat with x = 1 to length(expAmount)
    if char x of expAmount is "-" then
      put true into dontAdd
      delete char x of expAmount
      exit repeat
    else
      put false into dontAdd
    end if
  end repeat
  
  repeat with x = 1 to length(expAmount)
    if not(char 1 of expAmount is a number) AND (char 1 of expAmount <> ".") then -- delete $ signs
      delete char 1 of expAmount
    else
      exit repeat
    end if
  end repeat
  if expAmount = 0 then exit collectExpenseData
  
  --  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
  if dontAdd then
    put gDollarSign & "-" & expAmount into  zExpenseTotal
    subtract expAmount from gExpenses
  else
    put gDollarSign & expAmount into  zExpenseTotal
    add expAmount to gExpenses
  end if
  put  field "expense" of card cardNum of stack "records" into  zExpense
  
  if field "project" <> empty then
    put zDate & tab & zExpense & tab & zExpenseTotal & return into temp
  else
    put zDate & tab & zProject & tab & zExpense & tab & zExpenseTotal & return into temp
  end if
  
  
  if field "expense notes" of card cardNum of stack "records"  <> empty then
    put  "Expense Notes = " & field "expense notes" of card cardNum of stack "records" into gNotes
    if length(gNotes) > 100 then
      createLines
    end if
    put gNotes & return after temp
  end if
  
  put return after temp
  put temp after field "report" of stack "output"
end collectExpenseData

on setTabs which
  global gTabs
  if gTabs is empty then
    if which is "wide" then
      put "150,320,500" into gTabs
      set the tabStops of field "report" of card 1 of stack "output" to 150,320,500,520
      set the tabStops of field "report" of card 2 of stack "output" to 150,320,500,520
    else
      put "200,425,450" into gTabs
      set the tabStops of field "report" of card 1 of stack "output" to 200,425,450
      set the tabStops of field "report" of card 2 of stack "output" to 200,425,450
    end if
  end if
end setTabs

on createLines
  global gNotes
  repeat while the number of chars of gNotes > 0
    put 100 into tooLong
    put char 1 to tooLong of gNotes into temp2
    if offset(return,temp2) = 0 then
      repeat while the number of chars of temp2 > 0
        if char tooLong of temp2 <> space then
          delete char tooLong of temp2
          subtract 1 from tooLong
        else
          exit repeat
        end if
      end repeat
    else
      put offset(return,temp2) - 1 into tooLong
    end if
    if length(gNotes) < 100 then
      put gNotes after temp
      exit repeat
    end if
    if tooLong < 1 then
      delete char 1 of gNotes
    else
      put char 1 to tooLong of temp2 & return after temp
      delete char 1 to tooLong of gNotes
    end if
  end repeat
  put temp into gNotes
end createLines

on checkTime
  put field "start"  into startTime
  put field "end"  into endTime
  if startTime is empty or endTime is empty then exit checkTime
  convert startTime to dateItems
  convert endTime to dateItems
  
  if item 4 of startTime > item 4 of endTime then
    add 24 to item 4 of endTime -- add 24 hours
    subtract 1 from item 3 of endTime
  end if
  if item 3 of startTime > item 3 of endTime then
    put daysofmonth(item 2 of startTime,item 1of startTime) into zdays
    add zdays to item 3 of endTime -- add about 30 days
    subtract 1 from item 2 of endTime
  end if
  if item 2 of startTime > item 2 of endTime then
    add 12 to item 2 of endTime -- add 12 months
    subtract 1 from item 1 of endTime
  end if
  
  repeat with i = 1 to 5
    if (item i of startTime > item i of endTime) then
      abort
      exit to metaCard
    end if
  end repeat
end checkTime

on abort
  global gStartDate, gEndDate, gDateField, gDateStack
  
  if gDateField is "start" then
    put gStartDate into field "start"
  else
    put gEndDate into field "end"
  end if
  answer error "The end date is before the start date. " & return & "Please enter a new date."
end abort

function spaces howmany
  repeat with i = 1 to howmany
    put space after temp
  end repeat
  return temp
end spaces

function roundoff numb
  set the numberFormat to 0.000
  put offset(".",numb) into decPos
  put char 1 to decPos of numb into zwhole
  put char decPos  to length(numb) of numb into zparts
  put field "roundoff" into z
  put z/2 into x
  put 0 into y
  put 0 into n
  repeat while y < 1.000
    add x to y
    if zparts < y then
      return (zwhole + (y-x))
    end if
    add x to y
    add 1 to n
  end repeat
  return (zwhole + 1)
end roundoff
  w        Black CC Aquamarine ffffff      white       	darkgray    
 ?         List of Invoices Due      U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial   U 
Helvetica  	 U 
Helvetica   U Monaco   U Monaco  
 U B Friz Quadrata Bold   U B Friz Quadrata Bold   U B Friz Quadrata Bold       	@          ?&                                      options   i           2   Overdue Invoices @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon    w #               	      
List Options  D    ዋkk Salmon      h              	      
All Invoices @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon    w  a              	     Create Report Ex  /on mouseUp
  global gInvoiceTabs,gDollarSign
  
  if the hilitedButtonName of group "options" is empty then
    set the hilitedButtonName of group "options" to "All Invoices"
  end if
  if the hilitedButtonName of group "sort" is empty then
    set the hilitedButtonName of group "sort" to "Project"
  end if
  put "Invoice #" & tab & "Amount" & tab & "Due Date" & tab & "Project" & tab & "Invoice Date" into temp
  
  if gInvoiceTabs is empty then
    set the tabstops of field "report" to "75,150,235,440"
  else
    set the tabstops of field "report" to gInvoiceTabs
  end if
  put temp & return into field "report"
  
  set the itemDelimiter to tab
  put 1 into sortLine
  put the hilitedButtonName of group "sort" into sortBy
  if sortBy is "Invoice #" then put "invoice" into sortBy
  if sortBy is "Invoice Date" then put "date" into sortBy
  if sortBy is "Due Date" then put "duedate" into sortBy
  
  put true into nodata
  put the number of cards of stack "invoiceTracker" into zcards
  repeat with i = 1 to zcards
    if zcards > 50 then set cursor to busy
    --  if checkItems(i) then next repeat
    
    if field "datepaid" of card i of stack "invoiceTracker" <> empty then next repeat
    if field "duedate" of card i of stack "invoiceTracker" is empty then  next repeat
    
    put field "duedate" of card i of stack "invoiceTracker" into zduedate
    put convertDate(zduedate) into zddate
    put convertDate(the date) into zdate
    
    if the hilite of button "overdue invoices" AND zdate < zddate then next repeat
    
    put field "invoice" of card i of stack "invoiceTracker" & tab into temp -- item 1
    put field "amount" of card i of stack "invoiceTracker" & tab after temp -- item 2
    put validatenumber(field "amount" of card i of stack "invoiceTracker") into zamount
    add zamount to ztotalAmount
    convert zduedate to short date
    put zduedate & tab after temp -- item 3
    put field "project" of card i of stack "invoiceTracker" & tab after temp -- item 4
    put field "date" of card i of stack "invoiceTracker" into zdate
    convert zdate to short date
    put zdate & tab after temp -- item 5
    put convertDate(zduedate) & tab after temp -- item 6
    put convertDate(zdate) & tab after temp -- item 7
    put i into item 8 of temp
    put temp into line sortLine of zSorter
    add 1 to sortLine
    put false into nodata
  end repeat
  
  if nodata then
    unlock screen with visual plain
    answer information "There were no invoices found for these options."
    exit to metacard
  end if
  
  -- set the itemDelimiter to tab
  sort lines of zSorter by item 1 of each -- always sort by invoice # first
  if sortBy is "project" then
    sort lines of zSorter  by item 4 of each
  end if
  if sortBy is "duedate" then
    sort lines of zSorter  by item 6 of each
  end if
  if sortBy is "date" then
    sort lines of zSorter by item 7 of each
  end if
  
  repeat with i = 1 to the number of lines of zsorter
    put line i of zSorter & return after field "report"
    put item 8 of line i of zsorter into cardNum
    put empty into temp
    put empty into zNotes
    if field "partials" of card cardNum of stack "invoiceTracker" is not empty then
      put field "partials" of card cardNum of stack "invoiceTracker" into temp
      repeat while offset(return,temp) > 0
        put comma && space into char offset(return,temp) of temp
      end repeat
      repeat with w = 1 to the number of words of  temp
        put validateNumber(word w of temp) into checkWord
        if checkWord is a number then
          add checkWord to partials
        end if
      end repeat
    end if
    
    if the hilite of button "show partial payments" AND temp <> empty then
      put "Partial Payments:" && temp & return after field "report"
    end if
    if the hilite of button "show notes" then
      put field "notes" of card cardNum of stack "invoiceTracker" into zNotes
      if zNotes <> empty then
        put "Notes:" && zNotes & return & return after field "report"
      end if
    end if
  end repeat
  
  put return & return after field "report"
  put "Total amount of invoices due = " & gDollarSign & setnumber(ztotalAmount) after field "report"
  
  put return & return after field "report"
  put "Total amount of partial payments = " & gDollarSign & setnumber(partials) after field "report"
  put return & return after field "report"
  put "Total amount still due = " & gDollarSign & setnumber(ztotalAmount-partials) after field "report"
end mouseUp

function convertDate zdate
  convert zdate to dateitems
  -- set the itemDelimiter to comma
  put item 1 of zdate into temp
  if item 2 of zdate < 10 then
    put "0" & item 2 of zdate after temp
  else
    put item 2 of zdate after temp
  end if
  if item 3 of zdate < 10 then
    put "0" & item 3 of zdate after temp
  else
    put item 3 of zdate after temp
  end if
  return temp
end convertDate
   ዋkk Salmon     t             	         sort   i          H   
Invoice Date @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon    6 h              	      	Due Date @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon      R              	      Project @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon      F              	     Sort By  D    ዋkk Salmon     L              	      
Invoice # @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon    6 M              	      Show Date Entered @E  on mouseUp
  if the hilite of me then
    set the disabled of button "date entered" to false
  else
    set the disabled of button "date entered" to true
    set the hilitedButtonName of group "sort" to "task" -- "priority"
  end if
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon     #               	       Show Invoice  @E  	on mouseUp
  if the hilite of me then
    set the disabled of button "deadline" to false
  else
    set the disabled of button "deadline" to true
    set the hilitedButtonName of group "sort" to "task"
  end if
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon                    	    
   instruction 	  
        8|            ZClick any options to get an updated list. Click an item in the list to go to that record.    bg  @h    ዋkk Salmon    	 + E            	   	        font   a         4   font bg E`  ዋkk Salmon     ,             	        bgrect   K@              v    
   fonts  )x   won mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "report" to line temp of me
end mouseUp
                      
.Keyboard  
AGaramond  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  B Friz Quadrata Bold  C Helvetica Condensed  	Capitals  CB Helvetica Condensed Bold  	Charcoal  Chicago  Comic Sans MS  Courier  Courier New  
FrenchScript  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  
Helvetica  Impact  	Kidprint  L Helvetica Light  LB Helvetica Black  
Lydian MT  Minion Web  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  	Palatino  Sand  Swing  Swis721 BdCn BT  Swis721 BdCnOul BT  Swis721 BdOul BT  Swis721 BdRnd BT  Swis721 BlkCn BT  Swis721 BlkOul BT  Swis721 BlkRnd BT  Swis721 BT  Swis721 Hv BT  Swis721 It BT  Swis721 LtCn BT  Swis721 Th BT  Symbol  Techno  Tekton  Tekton Bold  Textile  Times  Times New Roman  
Trebuchet MS  Verdana  	Webdings  
Wingdings  Zapf Dingbats       	`    @        Close Ex   `on mouseUp
  lock screen
  hide group "font"
  unlock screen with visual wipe left
end mouseUp
   ዋkk Salmon     L              	     
   inst 	                      +Pick a font face and size for your report.    sizes   i   on mouseUp
  set the textSize of field "report" to word 1 of the hilitedButtonName of me
  put the textHeight of field "report" into field "lheight"
end mouseUp
         z K   9 pt @D  ዋkk Salmon     8              	      10 pt @D  ዋkk Salmon     8              	     11 pt @D  ዋkk Salmon     8              	      12 pt @D  ዋkk Salmon     8              	      14 pt @D  ዋkk Salmon     8              	      16 pt @D  ዋkk Salmon     8              	   
   label3 	         ]  ,           KAfter making changes to the font or size, you may need to adjust the tabs. 
   label2 
          T             Line Height 
   lheight  7)x  on mouseUp
  put field "lheight" into temp
  put the hilitedButtonName of group "sizes" into tsize
  ask "Enter a new line height > " & tsize &"." with temp
  if it is empty or it is not a number or it < tsize then
    answer information "You must enter a number larger than the font size."
    exit mouseUp
  end if
  put it into field "lheight"
  set the textHeight of field "report" to it
end mouseUp
         '            13    Tabs Ex  on mouseUp
  global gInvoiceTabs
  answer question "Set the tab stops to" with "Default" or "Custom"
  switch it
  case "Default"
    --  if the hilite of button "show deadlines"  AND the hilite of button "show date entered" then
    set the tabstops of field "report" to "75,150,235,440"
    --  else
    --  set the tabstops of field "report" to "50,450,600,700"
    -- end if
    put "75,150,235,440" into gInvoiceTabs
    break
    
  case "Custom"
    if gInvoiceTabs is empty then put the tabstops of field "report" into gInvoiceTabs
    ask "Set the tab stops of the report field to" with gInvoiceTabs
    if it is empty then exit mouseUp
    put true into flag
    repeat with i = 1 to 3
      if item i of it is a number then
        put true into flag
      else
        put false into flag
      end if
    end repeat
    if flag then
      set the tabstops of field "report" to it
      put it into gInvoiceTabs
    end if
  end switch
end mouseUp
   ዋkk Salmon    4              	        
Default Font Ex   on mouseUp
  set the hilitedButtonName of group "sizes" to "10 pt"
  send mouseUp to group "sizes"
  set the textfont of field "report" to  "Arial"
  send mouseUp to button "font"
end mouseUp
   ዋkk Salmon    `              	     	   
   report 	x 	 
 )on mouseUp
  goReportLine 8
end mouseUp
        	 X+8 
 
 
 
    K                  	`    @ # Y 6    size   a         ` Z
   short  )h 	 
       d  <           button "Help"	48,410,120,431  &button "Close Window"	129,410,261,431  $button "Save as..."	270,410,358,431  button "Font"	368,410,440,431  button "Print"	449,410,521,431  field "report"	9,88,564,400       	`    @ s e  : 
   long  )h 	 
       d  <           button "Help"	48,520,120,541  &button "Close Window"	129,520,261,541  $button "Save as..."	270,520,358,541  button "Font"	368,520,440,541  button "Print"	449,520,521,541  field "report"	9,88,564,508       	`    @  e  :    putLong Ex  
;on mouseUp
  put "long" into whichField
  put empty into field whichField
  repeat with i = 1 to 5
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field "report" & tab & the rect of field "report" after field whichField
end mouseUp
   ዋkk Salmon     :              	     	      setLong Ex  
kon mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
   ዋkk Salmon     :              	     	      	putShort Ex  
<on mouseUp
  put "short" into whichField
  put empty into field whichField
  repeat with i = 1 to 5
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field "report" & tab & the rect of field "report" after field whichField
end mouseUp
   ዋkk Salmon     :              	     	      	setShort Ex  
lon mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
   ዋkk Salmon   G  :              	     	      Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "iHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "list invoices due", helpStack, zStack
end mouseUp
   ዋkk Salmon    0 H             	        
Close Window Ex   |on mouseUp
  global gStack
  lock screen
  close this stack
  goStack gStack
  unlock screen with visual plain
end mouseUp
   ዋkk Salmon                  	        Save as... Ux  on mouseUp
  
  put the date into whichDate
  put whichDate into temp
  repeat while offset("/",temp) > 0
    put "_" into char offset("/",temp) of temp
  end repeat
  ask file "Save invoice list as... " with "invoice_list_" & temp & ".txt"
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    put field "report" into temp
    write "List of Invoices as of " & whichdate & return & line 1 of temp & return to file filename
    set itemdelimiter to tab
    repeat with i = 2 to the number of lines of temp
      delete item 6 to 8 of line i of temp
      write line i of temp & return to file filename
    end repeat
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
   ዋkk Salmon    X             	        Font Ux  on mouseUp
  lock screen
  put the fontNames into field "fonts"
  sort field "fonts"
  repeat with i = 1 to the number of lines of field "fonts"
    if the textfont of field "report" is line i of field "fonts" then
      set the hilitedlines of field "fonts" to i
      exit repeat
    end if
  end repeat
  put the textHeight of field "report" into field "lheight"
  show group "font"
  unlock screen with visual wipe right
end mouseUp
   ዋkk Salmon   p H             	        Print Ux   &on mouseUp
  printReport
end mouseUp
   ዋkk Salmon    H             	        Show Partial Payments @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon                    	      Show Notes @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   ዋkk Salmon     # h              	      iHelp   on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
  hide group "devtools"
end closeStack

on closeCard
  -- trap
end closeCard
  w        Black CC Aquamarine ffffff      white       	darkgray    !w             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica    About Help   	@          w       List Invoices Due   	@          w       	Tutorial   	@          w       Invoice Tracker   	@          w       Preferences   	@          w       Keyboard Shortcuts   	@          w      & Importing/Export Projects   	@          w    * About Projects   	@          w    . Adding a New Project   	@          w    / Adding a New Record   	@          w    1 Adjusting the Date   	@          w    3 Background Color   	@          w     Button Colors   	@          w    7 Changing Projects   	@          w    : Choose Date   	@          w    < Choose Project   	@          w    B Create Project   	@          w    D Default Settings   	@          w    G Delete Project   	@          w    H Deleting Records   	@          w    I 
Edit Date   	@          w    M Exporting Records   	@          w     
First Record   	@          w    V Highlight Color   	@          w    W Importing Records   	@          w     Last Record   	@          w    Z Look and Feel   	@          w    ] Modify Project   	@          w     Next Record   	@          w     Prev Record   	@          w    g Quit   	@          w    h 	Record #   	@          w    i 
Registration   	@          w     Save As...   	@          w    n Save Record   	@          w    o Searching Records   	@          w     Sorting Records   	@          w    z 
Today's Date   	@          w    { Visual Effects   	@          w     Font   	@          w     Print   	@          w     Help Index   	@          w    !               help   i          t
   main  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(         Invoice Tracker 
  @          
  @          OThe Invoice Tracker window is where you will add all your invoice information. 
 @        Black    
 @      red   
 @        Black   3   Each "record" in Invoice Tracker consists of the invoice date, invoice amount, project, invoice number, due date, partial payments, date paid and any notes.  You can add new records or edit the information for any record at any time.   rThe Date field is automatically filled in. If it is incorrect, you can click on the field, or the Edit button, to enter another date. Enter the current date by clicking the Today button. You can also use the date chooser by clicking Choose. See Choose Date for more information. You can go directly to the first record with a particular date by clicking the Date label. 
       
      
      Z
     b 
     f G
      
      7
      
      
  @       
      
     N
    e 
    j    oEnter the amount of the invoice in the Invoice Amount field by clicking the field or the Edit button above it. 
       &
     & 
     5 
     < 
     Y 
     ]   
        6To add a new project, click the Add/Select button. Next click the Create Project button. Enter the name for the new project. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
        
       

     * 
     B 
     P 
      
     "
  @     &    To go to the last record of a particular project, click the Go To button. Next click the project name and finally click the Choose Project button. You can also double-click the project name to save the last step. For more information see About Projects. 
       ;
     ; 
     A :
     { 
      d
  @         
  @           
  @          TYou can add or edit the Invoice# by clicking the field or the Edit button above it. 
       
      
       
     > 
     B    =Enter the due date for the invoice into the Due Date field.  
       +
     + 	
     4    LYou can enter notes on any partial payments in the Partial Payments field.  
       2
     2 
     C    ?Enter the date the invoice was paid into the Date Paid field.  
       ,
     , 

     6    /Type your text directly into the Notes field.  
        
       
     &   
         0Adding, Deleting, Searching and Sorting Records 
  @        /  
  @          +To add a new record click the New button.  
       
      
     ! 	  
        <You may delete one or all of the records by clicking the Delete button. You will be asked if you want to delete just the record you are on, all records, or just those older than a certain date. If you choose the last option you will be asked for a date. You may want to export the records, before deleting them all. 
       9
     9 
     ?    Search for text in any record by clicking Find. You can search for the first few characters of a word or complete words. You may also limit your search to words with the exact capitalization as the word you enter, by clicking "case sensitive". 
       *
     * 
     .   
         You can sort records by clicking the Sort button. You will be asked if you want to sort the records by Invoice Date, Due Date or Project. All records are renumbered after sorting. 
       %
     % 
     ) _
      
      *  
         Import and Exporting Records 
  @           You can import or export the records to a tab delimited text file by clicking the Import or Export button. There are a couple of reasons you might want to do this: 
       R
     R 
     X 
     \ 
     b A  
         1) Rather than archiving the whole program, you might want to export all the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.    The exported file is called invoice_records.txt with contains the data for all the records. You can change this name if you wish. Be sure to make a note of its location.  
       
 @      Red   
     / S
 @      Blue   (   You can export one or all records, or records that are newer or older than a certain date. See Exporting Records for more information. 
       _
  @      _ 
     p   
         Other Buttons 
  @        
  vYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Schedule Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q {
      
      
      
      4
     
     
    % 
    ) /
 @      Blue X X
     0
     
        The Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Time Format. For more information see Preferences. 
       
      
     	 
  @       
     1 p
  @       
        
         To register Small Business Tracker, click the Register button. Read the instructions for getting a registration number. When you receive your number, fill in your full name and the registration number. You will then be able to continue using the software. 
       .
     . 
     6    /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
         tYou can list all invoices due by clicking the List Invoices Due button. See List Invoices Due for more information. 
       -
 @        Black  - 
     ? 

 @      blue  L 
     ]    nThe Save button saves your data. All records are saved automatically when going to another record or window.. 
       
      
      e   The Quit button saves the data and quits the program.  You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      .
     6 o         About Help 
  @        
  
  @          !Welcome to Invoice Tracker Help. 
 @        Black        Listed in this Help system are all the features, fields and buttons of Invoice Tracker. (Buttons are things you click on and fields contain text.) 
         You can click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

      
 @      Blue   Y
    < W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R   
         Each "record" in Invoice Tracker consists of the date, time, project, version number, change notes and a short description of the changes made.  You can add new records or edit the information for any record at any time.    \Use the buttons at the top of this Help window to learn more about the following subjects:  
       #
     # 
     ' 4   The Invoice Tracker window is where you can make notes about invoices that are due, partially paid and paid for any number of projects. 
       
  @       
      
 @        Black   
      l  
         sThe List Invoices Due window is where you can create a report of all the invoices due, and export or print it out. 
       
  @       
      
 @        Black   
      U  
         The Preferences window is where you can change background and button colors, time formats, and the general "look and feel" of the program.  
       
  @       
      |   jAlmost every button in this program has a keyboard shortcut. For more information see Keyboard Shortcuts. 
       V
  @      V 
     h    IThere's an extensive tutorial available by clicking the Tutorial button. 
       8
  @      8 
     @    iThe newest version of this software is available at http://productivity-software/sbtracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470      List Invoices Due 
  @          
  @          pEasily create a list of unpaid invoices by clicking the List Invoices Due button in the Invoice Tracker window. 
       7
     7 
     I 
 @      Red  W    You can list All Invoices or just Overdue Invoices by clicking the appropriate radio button at the top of the List Invoices Due window. 
       

     
 
      
     ! 
     2 ;
 @      Red  m 
        
         The list can be sorted by clicking one of the Sort By radio buttons. The choices are Project, Due Date, Invoice # and Invoice Date.  
       U
     U 
     q 
     u    =Click any invoice in  the list to go directly to its record.    The font face, size, line height and tab stops of the list can be modified by clicking the Font button. See Font  for more information. 
       [
     [ 
     _ 

 @      Blue  l 
     p    :You can print the task list by clicking the Print button. 
       ,
     , 
     1    `To save the list as a text file for importing into another program click the Save as... button. 
       M
     M 

     W      Sorting Records 
  @           You can sort records by Invoice Date, Project or Due Date  by clicking the Sort button in the Invoice Tracker window.  All records are renumbered after sorting. 
       
      
     . 
     0 	
     9 
     K 
     O 
 @      red  ] 
     t ,     	Tutorial 
  @          
  @          QHere's a quick tutorial for those just getting started with the Invoice Tracker. 
 @        Black    P   Each "record" in Invoice Tracker consists of the invoice date, invoice amount, project, invoice number, due date, partial payments, date paid and any notes.  You can add new records or edit the information for any record at any time.    To add a new record click the New button. The Date field is filled in automatically. You can easily change the date at any time by clicking the Today, Edit, or Choose buttons. For more information see Adjusting the Date. 
       
      
     ! 	
     * 
     - 
     2 ^
      
      
      
      
      
      #
  @          oEnter the amount of the invoice in the Invoice Amount field by clicking the field or the Edit button above it. 
       &
     & 
     5 
     < 
     Y 
     ]   6To add a new project, click the Add/Select button. Next click the Create Project button. Enter the name for the new project. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
        
       

     * 
     B 
     P 
      
     "
  @     &    To go to the last record of a particular project, click the Go To button. Next click the project name and finally click the Choose Project button. You can also double-click the project name to save the last step. For more information see About Projects. 
       ;
     ; 
     A :
     { 
      d
  @         
  @          TYou can add or edit the Invoice# by clicking the field or the Edit button above it. 
       
      
       
     > 
     B    =Enter the due date for the invoice into the Due Date field.  
       +
     + 	
     4    LYou can enter notes on any partial payments in the Partial Payments field.  
       2
     2 
     C    ?Enter the date the invoice was paid into the Date Paid field.  
       ,
     , 

     6    /Type your text directly into the Notes field.  
        
       
     &   
         Other features: 
  @           tYou can list all invoices due by clicking the List Invoices Due button. See List Invoices Due for more information. 
       -
 @        Black  - 
     ? 

 @      blue  L 
     ]   uYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Invoice Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q z
      
      
      
      4
     
     
    $ 
    ( /
 @      Blue W X
     0
     
        Search for text in any record by clicking the Find button. You can search for the first part of a word (partial words) or one or more whole words. If capitalization matters, click the "case sensitive" button. 
       .
     . 
     2   
         oSort all the records by date or project by clicking the Sort button. You will be asked which field to sort by. 
       8
     8 
     < 2   Delete one or all of the records by clicking the Delete button. You will be asked which records you want to delete. For more information see Deleting Records. 
       1
     1 
     7 V
  @         You may want to export the records by clicking Export. You can then import the data into a spreadsheet or word processing program. You can export the data for archiving purposes too. You can Import the saved data back into Invoice Tracker at any time. You will want to export your data when updating to a newer version of Invoice Tracker. For more information see Exporting Records and Importing Records. 
       /
     / 
     5 
      
      
  @     l 
    } 
  @      
       
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
         To access the Preferences window, click the Prefs button. You can change the highlight, button and background colors, time format, etc. For more information see Preferences. 
       ,
     , 
     1 p
  @         
  @         You can close the current window by using the Control + w (or command + w on the Mac) key combination. It is usually better to use the Close Window button, if there is one, or choose another tool from the Small Business Tracker Menu instead of using this shortcut though. 
       
      
      :
      
      '  
        You can close the current window by using the Control + w (or command + w on the Mac) key combination. It is usually better to use the Close Window button, if there is one, or choose another tool from the Small Business Tracker Menu instead of using this shortcut though. 
       
      
      :
      
      '  
         The Save button saves your data. All records are saved automatically when going to another record or when you Quit the program. You can quit the program from any window by using the Control + Q (or Command + q on the Macintosh) key combination. 
       
      
      f
     n 
     r   
         5To access the help system, click on the Help button. 
       (
     ( 
     ,    \For more information, check the Help Index or any of the buttons at the top of this window. 
        
 @        Black    

     * 1  
         You can use the Save As... button below, to save any or all of the text in the help system, as either a .txt or .html file, for reading or printing. Saving the text in .html format allows you to view the formatted help text in your web browser. 
       
      
      z
 @      Blue   _  
               Keyboard Shortcuts 
  @          
  @          )Many buttons have a keyboard equivalent. 
 @        Black    (  
  @          Shortcuts are indicated by the letter of the button that is underlined. Just press the letter on your keyboard to activate the button.    cIf a keyboard shortcut does not work, try pressing the tab key and then the shortcut letter again. 
  @        b   If you are typing notes, many of the following shortcuts will not work unless you also hold down the Alt key (or Command key on the Macintosh).   CYou can also use the Tab key to move between most of the buttons and editable fields of each window. (Buttons are things you click on, fields are places where text is entered or displayed.) Buttons will appear with a dotted rectangle when they are active. Then you can press the return or enter key to activate the button.    In any field that you can type in, you can also use the standard Cut (Ctrl - x), Copy (Ctrl - c) and Paste (Ctrl - v) keyboard shortcuts.    "Invoice Tracker window shortcuts: 
 @        Black    
      
 Add/Select - a  
Go To - g  New - n  Delete - d  List Invoices Due - l  	Save - s  	Quit - q    Add/Projects window shortcuts: 
        Choose Project - t  Create Project - r  Modify Project - m  Delete Project - d  Import/Export - i  Close Window - c  'Move up in list of projects - Up arrow  +Move down in list of projects - Down arrow    $List Invoices Due window shortcuts: 
       # 	Help - h  Save as - v  	Font - f  
Print - p  	Save - s  Close Window - c  'Move up in list of projects - Up arrow  +Move down in list of projects - Down arrow    Help window shortcuts: 
        About Help - a  Invoice Tracker - v  Keyboard Shortcuts- k  
Tutorial - t  List Invoices Due - l  Preferences - p  Help Index - h  Back to Previous Topic - b  Search Help - s  Close Window - c         g Quit 
  @           You can quit (or exit) the program at any time by clicking the Quit button. All data will be saved before quitting. You can quit the program from any window by using the Control + Q (or command + q on the Macintosh) key combination. 
       ?
     ? 
     C        Font 
  @          
         You may want to adjust the font, size or line height of the schedule text by clicking the Font button. Choose a new font by clicking its name in the font list. 
       Z
     Z 
     ^ A  
         Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change.  
         
         Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       3
     3 {  
        You can also set the tab stops of the list text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      !
     @ 
     G 
     \ 
     _ *
      
      
      
      
 @      Blue n O  
 @      Blue      QReset the font face and size to 10 pt Arial by clicking the Default Font button. 
 @        Black    <
 @        Black  < 
 @        Black  H   
             Print 
  @          
  @         :You can print either All Due Invoices or just the Overdue Invoices by clicking List Invoices Due button in the  Invoice Tracker window. Then click the appropriate radio button at the top of the List of Invoices Due window. After selecting from the following options,  print the list  by clicking the Print button. 
       
      
     % 
     1 
     B 

     O 
     ` 
 @      Red  o 
      :
 @      Red   
      O
    , 
    1    The font face, size, line height and tab stops of the list can be modified by clicking the Font button. See Font  for more information. 
       [
     [ 
     _ 

 @      Blue  l 
     p        xx   { Visual Effects 
  @          *There is a visual effect that helps to indicate the movement from one record to another in the Invoice Tracker window when using the arrow keys. Some people found this effect annoying or slow. Other people thought is was great. So you may now choose to turn it On or Off in the Preferences window. 
       n
 @      red  n 
     u 
     
     
     
     
  @      
    (    See also Record #. 
       	
 @      Blue  	 	  M Exporting Records 
  @          3You can export the records to a text file by clicking the Export button. You will be asked if you want export All records or just Specific ones. If you choose All then all records will be exported. Records are exported in a tab delimited format, so they can be easily imported into many other applications. 
       :
     : 
     @ .
     n 
     y 	
      
      
      
      $
 @      Blue   l   If you choose Specific you will then be asked if you want to export Old records, New records or Project records. If you click the Project button, only records for the project on the current record will be exported. 
       
      
      .
     D 
     G 

     Q 
     T 
     ` 
     g 
      
      M   If you choose New, you will be asked to enter a date. Only records newer than that date will be exported. Using this feature allows you to export just the records for the last week (for example) so that they can be sent to an administrator for importing. 
       
      
        
         If you choose Old, you will also be asked to enter a date. Only records older than that date will be exported. This feature is useful if you want to delete old records, but want to export and archive them first. 
       
      
        
         If there are no records found to be exported, you will see a message to that effect, but a file will still be written to disk. To avoid confusion, you may want to delete that file. 
         
         You can export records which have their timer running. However, when these records are imported again, the timer will be paused at the time it was exported. The note "timer running or paused" is added to the exported record. 
       
      :   @There are a couple of reasons you might want to export records: 
  @        ? 1) Rather than archiving the whole program, you might want to export all (or some of) the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.   
  @          The exported file is called invoice_records.txt which contains the data for all the records in a tab delimited format. You can change this name if you wish. Be sure to make a note of its location. 
       
 @      Red   
  @      , 
     / n
  @       '      i 
Registration 
  @          'To register Small Business Tracker, click the Small Business Tracker Menu button and choose Small Business Tracker Welcome. Then click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       .
     . 
     I 
     [ 
     \ 
     { 
      

      
         HYou can also review the License Agreement from the Registration window. 
       
      
     )          Preferences 
  @          
  @          ?There are several preferences you can set for Invoice Tracker. 
 @        Black    >   XTo access the Preferences window, click the Prefs button in the Invoice Tracker window. 
       ,
     , 
     1 
 @      Red  O 
     V   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
      
      e
     v 

      a
      	
      H
  @     2 
    D   You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C   -There is a visual effect that helps to indicate the movement from one record to another in the Invoice Tracker window when using the arrow buttons or keys. Some people find this effect annoying or slow. Other people think it is great. So you can choose to turn it On or Off in the Preferences window. 
       n
 @      red  n 
     u 
     
    
 
     
     
  @      
    +   The Open new tools in a different window? button allows you to choose if you want each tool to open in a new, separate window or if you want each new tool to open in the same window as the current tool. Opening new tools in new windows sometimes creates too many open windows on the screen for some people. Some tools, such as the Universal Calculator,  always open in a new window. 
       
      %
     )U  
         WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <        1 Adjusting the Date 
  @           The date can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y W
      
      F  
Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the current record. 
       
      
     %       * About Projects 
  @          lYou can enter any number of projects into Invoice Tracker. If you have several clients, you may want to use the client's name for the project name. If you work on different projects for the same client, you will want to combine the client and project name somehow. Project names are limited to 25 characters, but commas and other special characters are permitted.    To choose a project, click the Add/Select Project button. Then select a project name and click the Choose Project button. You may also double-click on the project name. 
       
      
     1 2
     c 
     q 7  To create a project name, click the Add/Select Project button. Then click the Create Project button and enter a name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. 
       $
     $ 
     6 
     N 
     ] 
      
         To modify a project name, click the Add/Select Project button. Then select a project name to modify and click the Modify Project button. You will be asked for a new name. All records with the old project name will be updated with the new name. 
       $
     $ 
     6 <
     r 
      *
  @       H
         To delete a project name, click the Add/Select Project button. Then select a project name to delete and click the Delete Project button.  
       $
     $ 
     6 <
     r 
      	  
        $To import or export a list of project names, click the Import/Export  button. If you choose Import, you will be asked to locate a project.txt file. If you choose Export, save the project.txt file to your computer so that you can then import it into another module of this productivity suite. 
       7
     7 
     E 
     \ 
     b  
 @      Red   
      
      
      
 @      Red   
      e      z 
Today's Date 
  @           rTo easily enter today's date into a record, click the Today button above either the Start Date or End Date field. 
       6
     6 
     ; 
     T 

     ^ 
     b 
     j    aYou can go directly to the first record with a particular date by clicking the Start Date label. 
       O
     O 

     Y     o Searching Records 
  @          You can search records for particular text by clicking the Find button. A dialog will ask for a partial or whole word to search for. You can find the beginning of a word or phrase by using the partial words option. To find an exact word or phrase, use the whole words option. 
       ;
     ; 
     ? 
      

      2
      
        You can also specify that you want your search to be case sensitive (i.e., a search for "UNIX" will not find "unix"). Click the checkbox next to this option to enable it. 
       5
     5 
     C g   [You can go directly to the first record with a particular date by clicking the Date label. 
       N
     N 
     S     n Save Record 
  @           You can save all the data in the record window by clicking the Save button. All data is saved automatically when going to another record or when quitting the program. 
       ?
     ? 
     C c         Save As... 
  @        
  You can use the Save as... button at the bottom of this window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. See About Help for more information about printable versions of this Help system. 
       
      

      
 @      Blue   Y
    5 \
  @      

     C  
         iIn the List Invoices Due window, the Save as... button exports the list of invoices due to a text file.  
       
 @      Red   
      
     % 

     / 9  h 	Record # 
  @          Each Record in Invoice Tracker has a number. This number may change when you add or delete records. You can go directly to a particular record by clicking the Record # field or label. Or you can use the arrow buttons to go the First Record, Prev Record, Next Record or Last Record. 
       -
  @      - 6
     c <
      
      <
  @       
      
  @       
      
  @       
    	 
  @     
 
        The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
          See also Visual Effects. 
       	
 @      Blue  	    Prev Record 
  @           {Go the previous record (the record with the next lowest number) by clicking the Prev button (the one with the left arrow). 
       P
     P 
     T &   The First Record and Prev Record buttons are hidden on the first record. You can also use the arrow keys to move from one record to the next or previous record.  
            Next Record 
  @           yGo the next record (the record with the next highest number) by clicking the Next button (the one with the right arrow). 
       M
     M 
     Q '   The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
           ] Modify Project 
  @          To modify a project name, click the Add/Select Project button. Then select a project name to modify and click the Modify Project button. You will be asked for a new name. All records with the old project name will be updated with the new name. For more information see About Projects. 
       $
     $ 
     6 <
     r 
      +
  @       I
      
  @     
         Z Look and Feel 
  @        
  aIn the Preferences window, the Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
  @       
      
      

     , e
      

      a
      	
     H
  @     M 
    _          Last Record 
  @           |Go the last record (the record with the highest number) by clicking the Last button (the one with the right arrow and bar). 
       H
     H 
     L /   GThe Last Record and Next Record buttons are hidden on the last record. 
       F    W Importing Records 
  @          /You can import previously exported records by clicking the Import button in the Invoice Tracker window. First you will be asked if you want to Delete all existing records before importing or Add the imported records to the existing ones. You then will be asked to locate a invoices.txt file to import.  
       ;
     ; 
     A 
 @      Red  _ 
     f )
      
      *
      
      O
  @      
        ,See Exporting Records for more information. 
       
  @       
          V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the Invoice Tracker window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O 
 @      red  m 
     t 
      
      F         
First Record 
  @           |Go the first record (the record with the lowest number) by clicking the First button (the one with the left arrow and bar). 
       H
     H 
     M .  
         IThe First Record and Prev Record buttons are hidden on the first record. 
       H        I 
Edit Date 
  @        	   The date can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y W
      
      F  Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date, closes the window and enters that date into the current record. 
       
      
     %       H Deleting Records 
  @          You can delete some or all records by clicking the Delete button. You will be asked if you want to delete Just this one record, Older records or All records. If you choose Older then you will be asked for a date. This feature is useful when you have many old records that you do not need to keep. You will probably want to export the old records first. See Exporting Records for more information. 
       3
     3 
     9 1
     j 

     w 	
      
      
      
      
  @     e 
    v         G Delete Project 
  @           To delete a project name, click the Add/Select Project button. Then select a project name to delete and click the Delete Project button. You will no longer be able to create reports for that project. 
       $
     $ 
     6 ;
     q 
      G        D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	     B Create Project 
  @          /To create a project name, click the Add/Select Project button. Then click the Create Project button and enter a name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
       $
     $ 
     6 
     N 
     \ 
      
      "
  @              < Choose Project 
  @           To choose a project, click the Add/Select Project button. Then select a project name and click the Choose Project button. You may also double-click on the project name to add it directly to the current record. For more information see About Projects. 
       
      
     2 1
     c 
     q z
  @               : Choose Date 
  @          3One method for changing a date, is to click the Choose button above the date field. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the appropriate field. 
       0
     0 
     6     7 Changing Projects 
  @           To add a new project name to the current record, click the Add/Select Project button. Then select the new name and then click the Choose Project button. You may also double-click on the project name to add the project to the current record. 
       ;
     ; 
     M 5
      
      `  ITo change projects, click the Add/Select Project button. If you want to modify an existing name, select the project to be changed, click the Modify Project button and enter a new name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. 
       
      
     0 ]
      
      
    2 
    @          Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G        / Adding a New Record 
  @           +To add a new record click the New button.  
       
      
     ! 	    . Adding a New Project 
  @          >To add a new project, click the Add/Select Project button. Next click the Create Project button. Enter the name for the new project. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
        
       
     2 
     J 
     X 
      
     "
  @     .         & Importing/Export Projects 
  @          You can import or export lists of projects from other components of (whatever we're going to call this package). Just click the Import/Export button in the Projects window.  If you choose Import, you will be asked to locate a project.txt file. If you choose Export, save the project.txt file to your computer so that you can then import it into another module of this productivity suite. 
       
      

      
 @      Red   
      
      
       
 @      Red   
      
     
     
 @      Red  
     e     Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &    About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
   ዋkk Salmon      ]             	        List Invoices Ex   Pon mouseUp
  lock screen
  push card
  go card "List invoices due"
end mouseUp
   ዋkk Salmon    l  l             	        Keyboard Shortcuts Ex   Oon mouseUp
  lock screen
push card
  go card "Keyboard Shortcuts"
end mouseUp
   ዋkk Salmon                   	        	Tutorial Ex   Eon mouseUp
  lock screen
push card
  go card "Tutorial"
end mouseUp
   ዋkk Salmon     " P             	        Invoice Tracker Ex   Qon mouseUp
  lock screen
  push card
  go card the short name of me
end mouseUp
   ዋkk Salmon    ` "              	        Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
   ዋkk Salmon     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
   ዋkk Salmon     <              	        Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
   ዋkk Salmon     <              	        Search Help Ex  ]on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 320 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack "atFind" to it
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "atFind"
end mouseUp
           ዋkk Salmon     l             	        Save as... Ex   on mouseUp
  global gStackName
  
  insert the script of button "SaveHelp" of stack "Launcher" into back
  put "Invoice Tracker Help" into gStackName
  exportHelp
  remove the script of button "SaveHelp" of stack "Launcher" from back
end mouseUp
   ዋkk Salmon     Q              	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
   ዋkk Salmon     y             	        	devtools   a         tH    Save Ex   *on mouseUp
  save this stack
end mouseUp
   ዋkk Salmon    x Q              	        go next Ex   'on mouseUp
  go next card
end mouseUp
   ዋkk Salmon    \x Q              	        delete Ex   +on mouseUp
  delete this card
end mouseUp
   ዋkk Salmon   x 2              	        go prev Ex   'on mouseUp
  go prev card
end mouseUp
   ዋkk Salmon    x Q              	           K        
  ^          K        ^             K           j          K                    K        
   T    
  ! index  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Help  About Projects  Adding a New Project  Adding a New Record  Adjusting the Date  Background Color  Button Colors  Changing Projects  Choose Date  Choose Project  Create Project  Default Settings  Delete Project  Deleting Records  
Edit Date  Exporting Records  
First Record  Font  Highlight Color  Importing Records  Importing/Export Projects  Invoice Tracker  Keyboard Shortcuts  Last Record  List Invoices Due  Look and Feel  Modify Project  Next Record  Preferences  Prev Record  Print  Quit  	Record #  
Registration  Save As...  Save Record  Searching Records  Sorting Records  
Today's Date  	Tutorial  Visual Effects         	`    @ ` Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    New Button EpGon mouseUp
sort this stack by field "main"
  beep
end mouseUp


  repeat with i = 1 to the number of cards
    put empty into field "main" of card i
  end repeat

repeat with i = 1 to the number of lines of field index
  if there is a card line i of field index then next repeat
  else answer line i of field index
end repeat
          `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
        D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
         ` 8             	        reindex and sort EpMon mouseUp
  put empty into field "index"
  repeat with i = 1 to the number of cards
    if char 1 of field "main" of card i <> "x" then
      set the name of card i to line 1 of field "main" of card i
      put line 1 of field "main" of card i  & return after field "index"
    end if
  end repeat
  sort field "index"
end mouseUp
        T               	           K        j  p       
iprojects  Yon openCard
  global gProject
  if field "projects" = empty then exit openCard
  if gProject is empty then
    set the hilitedlines of field "projects" to 1
    put 1 into gProject
  else
    set the hilitedlines of field "projects" to gProject
  end if
end openCard

on arrowKey which
  global gProject
  put the number of lines of field "projects" into numLines
  if which is "up" then
    if gProject is 1 then
      put numLines into gProject
    else
      subtract 1 from gProject
    end if
  end if
  if which is "down" then
    if gProject is numLines then
      put 1 into gProject
    else
      add 1 to gProject
    end if
  end if
  set the hilitedlines of field "projects" to gProject
end arrowKey

on returnKey
  checkFocus
end returnKey

on enterKey
  checkFocus
end enterKey

on checkFocus
  global gProject
  if word 3 of the focusedObject is the id of button "Create Project" then
    send mouseUp to button "Create Project"
  else
    if gProject is empty then
      send mouseUp to the focusedObject
    else
      send mouseUp to button "Choose Project"
    end if
  end if
end checkFocus
           CC Aquamarine    # _^,         	Projects      U Arial   U Arial   U 
Helvetica  
 U Arial  	 U Arial   U Arial   U 
Helvetica  
 U 
Helvetica  
 W 
Helvetica   W Arial   W 
Helvetica       	@          ^,                  
   projectsbg  	h          6                    	`    @   7      Create Project Ex 
 ,on mouseUp
  global gProject
  put 32 into maxLength
  ask "Enter the name of the new project."
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this project that is" && maxLength && "characters or less." with char 1 to maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is it then
      answer information "You have already created this project."
      exit mouseUp
    end if
  end repeat
  
  put the number of lines of field "projects" + 1 into temp
  put it into newProject
  put newProject into line temp of field "projects"
  sort field "projects"
  unlock screen
  set cursor to watch
  save this stack
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is newProject then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit mouseUp
    end if
  end repeat
  
end mouseUp
           ዋkk Salmon     j s             	        Delete Project Ex  Kon mouseUp
  global gProject,gStack
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to delete."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a project to delete."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into temp
  answer warning "Are you sure you want to delete project " &quote & temp & quote& "." with "Cancel" or "Delete"
  if it is "Cancel" then exit mouseUp
  delete line gProject of field "projects"
  put empty into gProject
  unlock screen
  set cursor to watch
  save this stack
end mouseUp
   ዋkk Salmon      s             	        Choose Project Mx  on mouseUp
  global gProject,gStack,gProjectName,gButton
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "First create a project."
      send mouseUp to button "Create Project"
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select or create a project."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into gProjectName
  send chooseProject to field "projects"
end mouseUp
   ዋkk Salmon     9 q %            	        
Close Window Ex   Xon mouseUp
  global gDontSave
  put true into gDontSave
  close this stack
end mouseUp
   ዋkk Salmon      s             	     
   instruction 	          F (           :Create a project or select one from the list on the left   &and then click a button on the right. 
   	projects  	x  	on mouseUp
  global gProject
  put word 2 of the clickLine into gProject
end mouseUp

on mouseDoubleDown
  global gProject,gStack,gProjectName,gButton,gWhichCard
  put word 2 of the clickLine into gProject
  put line gProject of field "projects" into gProjectName
  if gProjectName is empty then exit to metaCard
  chooseProject
end mouseDoubleDown

on chooseProject
  global gProject,gStack,gProjectName,gButton,gWhichCard,gDontSave
  put true into gDontSave
  lock screen
  put line gProject of field "projects" into gProjectName
  close this stack
  if gButton is "find project" then
    if gWhichCard is "Last" then
      repeat with i = the number of cards of stack gStack down to 1
        if field "project" of card i of stack gStack is gProjectName then
          go card i of stack gStack
          send setArrows to stack gStack
          exit repeat
        end if
      end repeat
    else
      repeat with i = 1 to the number of cards of stack gStack
        if field "project" of card i of stack gStack is gProjectName then
          go card i of stack gStack
          send setArrows to stack gStack
          exit repeat
        end if
      end repeat
    end if
  else
    if field "project" of stack gStack is empty OR gStack is "reports" then
      put gProjectName into field "project" of stack gStack
    else
      answer warning "Do you want to change the Project for this record" \
          & return & "or would you like to create a new record?" with "Change" or "New Record" or "Cancel"
      if it is "Cancel" then exit to metacard
      if it is "New Record" then
        go last card of stack gStack
        create card
        put the number of this card into field "record" of stack gStack
        put gProjectName into field "project" of stack gStack
        put 0 into temp
        repeat with i = 1 to the number of cards of stack gStack
          if field "invoice" of card i  of stack gStack > temp then
            put field "invoice" of card i  of stack gStack into temp
          end if
        end repeat
        put the number of this card into field "record" of stack gStack
        put the long date into field "date" of stack gStack
        put temp + 1 into field "invoice" of stack gStack
        send setArrows to stack gStack
      end if
      if it is "Change" then put gProjectName into field "project" of stack gStack
    end if
  end if
  put empty into gProject
  unlock screen with visual plain
end chooseProject
        	 6                    	`    @   7      Modify Project Ex  )on mouseUp
  global gProject, gStack,gProjectName
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a project."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into origProject
  
  put 32 into maxLength
  ask "Enter the new name for this project." with origProject
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this project that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  put it into gProjectName
  put gProjectName into line gProject of field "projects"
  sort field "projects"
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is gProjectName then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit repeat
    end if
  end repeat
  
  repeat with i = 1 to the number of cards of stack gStack
    if field "project" of card i of stack gStack is origProject then
      put gProjectName into field "project" of card i of stack gStack
    end if
  end repeat
  unlock screen
  set cursor to watch
  save this stack
end mouseUp
   ዋkk Salmon      s             	        Import/Export Ex   on mouseUp
  put "projects" into zfield
  put "projects" into what
  put "a Project" into zstack
  put "projects.txt" into fileName
  
  importExport zfield,what,zstack,filename
end mouseUp
   ዋkk Salmon      s             	       a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
   CC Aquamarine    2 @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
   ዋkk Salmon    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
   ዋkk Salmon     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@  ዋkk Salmon      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
   CC Aquamarine     t d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
            t d  z                
     @         d             31501 37252   z icon BP on mouseUp
end mouseUp
   ዋkk Salmon      , (         	      OK D`  ዋkk Salmon      6 4            	      Delete Record D`  ዋkk Salmon     Z z            	      
Fix later D`  ዋkk Salmon   * Z R            	      All D`  ዋkk Salmon    6 /            	      y D`  ዋkk Salmon     4 '            	      x D`  ዋkk Salmon    i 4 '            	      w D`  ዋkk Salmon      4 )            	    