@ECHO OFF
REM ***********************************************************************
REM DOWNALL.BAT -- Demo for shutdown manager
REM created by Moby Disk a.k.a. William Garrison - mobydisk@home.com
REM 
REM This is supposed to show off what you can do with a little batch file fun
REM This will shut down everyone on the network running the shutdown client
REM And will warn you if not all of the machines shut down, or if some were
REM forced to shut down.
REM 
REM Optional parameters: DOWNALL machine-name port-number
REM If these are not included, assumes all computers, default port
REM Ex. DOWNALL bobscomputer 1234
REM ***********************************************************************

REM OPTIONAL: Log the users out first -- no real need to though.
ECHO Logging out users...
manager LOGOFF %1 %2 >nul

REM ***********************************************************************
REM Now let me interrupt.  Let us suppose that the LAN adminstrator, in
REM their infinite wisdom, knew that 23 computers needed shutting down
REM every day.  We could now use the following code to verify that 23
REM computers were shut down.  For more help on this, see the errorlevel
REM example further below.
REM 
REM IF NOT ERRORLEVEL 23 GOTO notenough
REM Then :notenough would display an appropriate message
REM ***********************************************************************

ECHO Sending power off message...
manager POWEROFF %1 %2 >nul

REM Some machines cannot power off -- so we send SHUTDOWN for them
ECHO Sending shutdown message...
manager SHUTDOWN %1 %2 >nul

ECHO Forcing remaing clients down...
manager FORCE %1 %2 >downall.log
REM ***********************************************************************
REM Change the line above to >>downall.log to keep old logs.
REM ***********************************************************************
REM Now, the errorlevel contains the number of systems forced down.
REM This should be zero, if not, lets report an error message and display
REM the resulting computer list (now in downall.log)
REM If no computers required forcing, just exit nicely.
REM ***********************************************************************

REM Check to see if any systems required forced shutdown
IF ERRORLEVEL 1 GOTO hadtoforce

ECHO Shutdown complete.  No errors found.
GOTO quit

:hadtoforce
ECHO Warning! Some workstations had shutdown problems!
TYPE downall.log

:quit
