/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.ui.PlayerWindow;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.Manager;
import javax.media.Player;
import javax.media.format.AudioFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.rtcp.SourceDescription;
import rtp.RTPSendStreamWindow;

public class RTPUtil
implements ReceiveStreamListener,
ControllerListener {
    Vector playerlist = new Vector();
    SessionManager mgr;
    boolean terminatedbyClose = false;

    public SessionManager createManager(String address, String sport, String sttl, boolean listener, boolean sendlistener) {
        return this.createManager(address, new Integer(sport), new Integer(sttl), listener, sendlistener);
    }

    public SessionManager createManager(String address, int port, int ttl, boolean listener, boolean sendlistener) {
        this.mgr = new RTPSessionMgr();
        if (this.mgr == null) {
            return null;
        }
        this.mgr.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
        if (listener) {
            this.mgr.addReceiveStreamListener(this);
        }
        if (sendlistener) {
            new RTPSendStreamWindow(this.mgr);
        }
        String cname = this.mgr.generateCNAME();
        String username = null;
        try {
            username = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            username = "jmf-user";
        }
        SessionAddress localaddr = new SessionAddress();
        try {
            InetAddress destaddr = InetAddress.getByName(address);
            SessionAddress sessaddr = new SessionAddress(destaddr, port, destaddr, port + 1);
            SourceDescription[] userdesclist = new SourceDescription[]{new SourceDescription(3, "jmf-user@sun.com", 1, false), new SourceDescription(1, cname, 1, false), new SourceDescription(6, "JMF RTP Player v2.0", 1, false)};
            this.mgr.initSession(localaddr, userdesclist, 0.05, 0.25);
            this.mgr.startSession(sessaddr, ttl, null);
        }
        catch (Exception e2) {
            System.err.println(e2.getMessage());
            return null;
        }
        return this.mgr;
    }

    public void update(ReceiveStreamEvent event) {
        Player newplayer = null;
        RTPPlayerWindow playerWindow = null;
        SessionManager source = (SessionManager)event.getSource();
        if (event instanceof NewReceiveStreamEvent) {
            String cname = "Java Media Player";
            ReceiveStream stream = null;
            try {
                stream = ((NewReceiveStreamEvent)event).getReceiveStream();
                Participant part = stream.getParticipant();
                if (part != null) {
                    cname = part.getCNAME();
                }
                DataSource dsource = stream.getDataSource();
                newplayer = Manager.createPlayer(dsource);
                System.out.println("created player " + newplayer);
            }
            catch (Exception e2) {
                System.err.println("NewReceiveStreamEvent exception " + e2.getMessage());
                return;
            }
            if (newplayer == null) {
                return;
            }
            this.playerlist.addElement(newplayer);
            newplayer.addControllerListener(this);
            playerWindow = new RTPPlayerWindow(newplayer, cname);
        }
    }

    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ControllerClosedEvent || evt instanceof ControllerErrorEvent || evt instanceof DeallocateEvent) {
            Player p2 = (Player)evt.getSourceController();
            if (!this.terminatedbyClose) {
                if (this.playerlist.contains(p2)) {
                    this.playerlist.removeElement(p2);
                }
                if (this.playerlist.size() == 0 && this.mgr != null) {
                    this.mgr.closeSession("All players are closed");
                }
            }
        }
    }

    public void closeManager() {
        this.terminatedbyClose = true;
        int i2 = 0;
        while (i2 < this.playerlist.size()) {
            ((Player)this.playerlist.elementAt(i2)).close();
            ++i2;
        }
        if (this.mgr != null) {
            this.mgr.closeSession("RTP Session Terminated");
            this.mgr = null;
        }
    }

    class RTPPlayerWindow
    extends PlayerWindow {
        public RTPPlayerWindow(Player player, String title) {
            super(player);
            RTPUtil.this = RTPUtil.this;
            this.setTitle(title);
        }

        public void Name(String title) {
            this.setTitle(title);
        }
    }
}

