/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import com.sun.media.rtp.util.Signed;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.Player;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.rtcp.SenderReport;
import rtp.RTPStatsWindow;
import rtp.SenderReportWindow;

public class RTPStreamWindow
extends Frame
implements RemoteListener,
ActionListener {
    SessionManager mgr;
    RTPStream mystream;
    SenderReport myreport;
    Label state;
    List l;
    SenderReportWindow childsr;
    RTPStatsWindow statsw;
    String typestr;
    Button statsb;
    Player myplayer;
    boolean readytocreate = false;

    public RTPStreamWindow(SessionManager mgr, RTPStream stream) {
        super("RTPStream");
        this.mgr = mgr;
        this.mystream = stream;
        ((Component)this).setFont(new Font("Helvetica", 0, 14));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.anchor = 18;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        this.setLayout(gridbag);
        Participant owner = this.mystream.getParticipant();
        this.myreport = this.mystream.getSenderReport();
        Label l1 = new Label("Owner Participant");
        gridbag.setConstraints(l1, c2);
        this.add(l1);
        c2.gridwidth = 0;
        TextField t1 = new TextField(owner.getCNAME());
        t1.setEditable(false);
        gridbag.setConstraints(t1, c2);
        this.add(t1);
        Label l3 = new Label("SSRC");
        c2.gridwidth = -1;
        gridbag.setConstraints(l3, c2);
        this.add(l3);
        long ssrc = this.mystream.getSSRC();
        if (ssrc < 0L) {
            ssrc = Signed.UnsignedInt((int)ssrc);
        }
        String ssrcstr = new Long(ssrc).toString();
        TextField t2 = new TextField(ssrcstr);
        t2.setEditable(false);
        c2.gridwidth = 0;
        gridbag.setConstraints(t2, c2);
        this.add(t2);
        Label l2 = new Label("Latest Sender Report");
        c2.gridwidth = -1;
        gridbag.setConstraints(l2, c2);
        this.add(l2);
        this.l = new List(1);
        this.l.setBackground(Color.white);
        this.l.addItem("EMPTY");
        this.l.setEnabled(false);
        this.l.addActionListener(this);
        c2.gridwidth = 0;
        gridbag.setConstraints(this.l, c2);
        this.add(this.l);
        this.statsb = new Button("Source Reception Statistics");
        c2.gridwidth = -1;
        gridbag.setConstraints(this.statsb, c2);
        this.add(this.statsb);
        this.statsb.addActionListener(this);
        this.pack();
        this.show();
        this.addWindowListener(new 1());
        mgr.addRemoteListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        Button source;
        Object newplayer = null;
        Object playerWindow = null;
        if (event.getSource() instanceof List) {
            this.childsr = new SenderReportWindow(this.myreport);
        }
        if (event.getSource() instanceof Button && (source = (Button)event.getSource()) == this.statsb) {
            this.statsw = new RTPStatsWindow((ReceiveStream)this.mystream);
        }
    }

    public void close() {
        if (this.childsr != null) {
            this.childsr.close();
        }
        if (this.statsw != null) {
            this.statsw.close();
        }
        this.dispose();
    }

    public void update(RemoteEvent event) {
        if (event instanceof SenderReportEvent) {
            SenderReport report = ((SenderReportEvent)event).getReport();
            RTPStream stream = report.getStream();
            if (stream == null) {
                return;
            }
            if (stream == this.mystream) {
                this.l.replaceItem("View Latest SR", 0);
                this.l.setEnabled(true);
                if (this.childsr != null) {
                    this.childsr.update(this.myreport);
                }
            }
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            if (RTPStreamWindow.this.childsr != null) {
                RTPStreamWindow.this.childsr.close();
            }
            if (RTPStreamWindow.this.statsw != null) {
                RTPStreamWindow.this.statsw.close();
            }
            RTPStreamWindow.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }
}

