/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.sun.media.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.renderer.VideoRenderer;

public class VideoCodecChain {
    private Codec[] codecs;
    private Buffer[] buffers = new Buffer[5];
    private VideoFormat[] formats = new VideoFormat[5];
    private VideoRenderer renderer;
    private RGBFormat rgbFormat;
    protected Buffer copyBuffer = new Buffer();
    protected boolean firstBuffer = true;

    public VideoCodecChain(VideoFormat vf) throws UnsupportedFormatException {
        Vector<Codec> codecList = new Vector<Codec>(1);
        Dimension size = vf.getSize();
        float frameRate = vf.getFrameRate();
        boolean done = false;
        VideoFormat inputFormat = vf;
        if (size == null) {
            throw new UnsupportedFormatException(vf);
        }
        this.rgbFormat = new RGBFormat(size, size.width * size.height, Format.intArray, frameRate, 32, 1, -1, -1, -1, 1, -1, 0, -1);
        while (!done) {
            if (vf instanceof RGBFormat || vf instanceof YUVFormat) {
                if (vf.matches(this.rgbFormat)) {
                    done = true;
                    continue;
                }
                Codec codec = this.findCodec(vf, this.rgbFormat);
                if (codec == null) {
                    throw new UnsupportedFormatException(vf);
                }
                Format[] outputs = codec.getSupportedOutputFormats(vf);
                if (outputs == null || outputs.length == 0) {
                    throw new UnsupportedFormatException(vf);
                }
                int oldsize = codecList.size();
                int i2 = 0;
                while (i2 < outputs.length) {
                    Format f2;
                    if (outputs[i2].matches(this.rgbFormat) && (f2 = codec.setOutputFormat(outputs[i2])) != null && f2.matches(this.rgbFormat)) {
                        vf = (VideoFormat)f2;
                        this.formats[oldsize] = (VideoFormat)f2;
                        codecList.addElement(codec);
                        try {
                            codec.open();
                            break;
                        }
                        catch (ResourceUnavailableException resourceUnavailableException) {
                            throw new UnsupportedFormatException(vf);
                        }
                    }
                    ++i2;
                }
                if (oldsize != codecList.size()) continue;
                throw new UnsupportedFormatException(vf);
            }
            YUVFormat yuvFormat = new YUVFormat();
            RGBFormat looseRGBFormat = new RGBFormat();
            Codec codec = this.findCodec(vf, this.rgbFormat);
            if (codec == null) {
                codec = this.findCodec(vf, yuvFormat);
            }
            if (codec == null) {
                codec = this.findCodec(vf, looseRGBFormat);
            }
            if (codec == null) {
                throw new UnsupportedFormatException(vf);
            }
            Format[] outputs = codec.getSupportedOutputFormats(vf);
            if (outputs == null || outputs.length == 0) {
                throw new UnsupportedFormatException(vf);
            }
            int oldsize = codecList.size();
            int i3 = 0;
            while (i3 < outputs.length) {
                Format f3;
                if ((outputs[i3].matches(this.rgbFormat) || outputs[i3].matches(yuvFormat) || outputs[i3].matches(looseRGBFormat)) && (f3 = codec.setOutputFormat(outputs[i3])) != null) {
                    vf = (VideoFormat)f3;
                    try {
                        codec.open();
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        throw new UnsupportedFormatException(vf);
                    }
                    this.formats[oldsize] = (VideoFormat)f3;
                    codecList.addElement(codec);
                    break;
                }
                ++i3;
            }
            if (oldsize != codecList.size()) continue;
            throw new UnsupportedFormatException(vf);
        }
        if (done && vf.matches(this.rgbFormat)) {
            VideoRenderer rend = this.findRenderer(vf);
            if (rend != null) {
                this.renderer = rend;
            } else {
                throw new UnsupportedFormatException(vf);
            }
        }
        this.codecs = new Codec[codecList.size()];
        this.buffers = new Buffer[codecList.size()];
        int j2 = 0;
        while (j2 < codecList.size()) {
            this.codecs[j2] = (Codec)codecList.elementAt(j2);
            ++j2;
        }
        this.buildChain();
    }

    public int process(Buffer buffer, boolean render) {
        int codecNo = 0;
        return this.doProcess(codecNo, buffer, render);
    }

    private int doProcess(int codecNo, Buffer input, boolean render) {
        int returnVal;
        VideoFormat format = (VideoFormat)input.getFormat();
        if (codecNo == this.codecs.length) {
            if (render) {
                return this.renderer.process(input);
            }
            return 0;
        }
        if (format instanceof RGBFormat || format instanceof YUVFormat || format.getEncoding() != null && format.getEncoding().equalsIgnoreCase("jpeg")) {
            if (!render) {
                return 0;
            }
        } else if (this.firstBuffer) {
            if ((input.getFlags() & 0x10) == 0) {
                return 0;
            }
            this.firstBuffer = false;
        }
        Codec codec = this.codecs[codecNo];
        do {
            if ((returnVal = codec.process(input, this.buffers[codecNo])) == 1) {
                return 1;
            }
            if ((returnVal & 4) != 0) continue;
            if (!this.buffers[codecNo].isDiscard() && !this.buffers[codecNo].isEOM()) {
                this.doProcess(codecNo + 1, this.buffers[codecNo], render);
            }
            this.buffers[codecNo].setOffset(0);
            this.buffers[codecNo].setLength(0);
            this.buffers[codecNo].setFlags(0);
        } while ((returnVal & 2) != 0);
        return returnVal;
    }

    public Component getVisualComponent() {
        return this.renderer.getComponent();
    }

    public void finalize() {
        int i2 = 0;
        while (i2 < this.codecs.length) {
            this.codecs[i2].close();
            ++i2;
        }
        if (this.renderer != null) {
            this.renderer.close();
        }
    }

    protected void buildChain() {
        int i2 = 0;
        while (i2 < this.codecs.length) {
            this.buffers[i2] = new Buffer();
            this.buffers[i2].setFormat(this.formats[i2]);
            ++i2;
        }
    }

    protected Codec findCodec(VideoFormat input, VideoFormat output) {
        Vector codecList = PlugInManager.getPlugInList(input, output, 2);
        if (codecList == null || codecList.size() == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < codecList.size()) {
            Format[] outputs;
            String codecName = (String)codecList.elementAt(i2);
            Class codecClass = null;
            Codec codec = null;
            try {
                codecClass = Registry.getClassForName(codecName);
                if (codecClass != null) {
                    codec = (Codec)codecClass.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassCastException classCastException) {}
            if (codec != null && codec.setInputFormat(input) != null && (outputs = codec.getSupportedOutputFormats(input)) != null && outputs.length != 0) {
                int j2 = 0;
                while (j2 < outputs.length) {
                    if (outputs[j2].matches(output)) {
                        return codec;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        return null;
    }

    protected VideoRenderer findRenderer(VideoFormat input) {
        Vector rendList = PlugInManager.getPlugInList(input, null, 4);
        if (rendList == null || rendList.size() == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < rendList.size()) {
            String rendName = (String)rendList.elementAt(i2);
            Class rendClass = null;
            Renderer rend = null;
            try {
                rendClass = Registry.getClassForName(rendName);
                if (rendClass != null) {
                    rend = (VideoRenderer)rendClass.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassCastException classCastException) {}
            if (rend != null && rend.setInputFormat(input) != null) {
                return rend;
            }
            ++i2;
        }
        return null;
    }
}

