/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12PropertyAction;
import com.sun.media.util.jdk12ReadFileAction;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.Format;

public class Registry {
    private static Hashtable hash = null;
    private static String filename = null;
    private static final int versionNumber = 200;
    private static boolean securityPrivelege;
    private static JMFSecurity jmfSecurity;
    private static Method[] m;
    private static Class[] cl;
    private static Object[][] args;
    private static final String CLASSPATH = "java.class.path";
    private static String classpath;
    private static boolean jdkInit;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static final synchronized boolean set(String key, Object value) {
        if (key != null && value != null) {
            if (jmfSecurity != null && key.indexOf("secure.") == 0) {
                return false;
            }
            hash.put(key, value);
            return true;
        }
        return false;
    }

    public static final synchronized Object get(String key) {
        if (key != null) {
            return hash.get(key);
        }
        return null;
    }

    public static final synchronized boolean remove(String key) {
        if (key != null && hash.containsKey(key)) {
            hash.remove(key);
            return true;
        }
        return false;
    }

    public static final synchronized void removeGroup(String keyStart) {
        Vector<String> keys = new Vector<String>();
        if (keyStart != null) {
            Enumeration e2 = hash.keys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                if (!key.startsWith(keyStart)) continue;
                keys.addElement(key);
            }
        }
        int i2 = 0;
        while (i2 < keys.size()) {
            hash.remove(keys.elementAt(i2));
            ++i2;
        }
    }

    public static final synchronized boolean commit() throws IOException {
        if (filename == null) {
            throw new IOException("Can't find registry file");
        }
        FileOutputStream fos = new FileOutputStream(filename);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        int tableSize = hash.size();
        oos.writeInt(tableSize);
        oos.writeInt(200);
        Enumeration e2 = hash.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            Object value = hash.get(key);
            oos.writeUTF(key);
            oos.writeObject(value);
            oos.flush();
        }
        oos.close();
        return true;
    }

    private static final synchronized InputStream findJMFPropertiesFile() {
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        String strJMF = "jmf.properties";
        File file = null;
        FileInputStream ris = null;
        while (tokens.hasMoreTokens()) {
            String dir = tokens.nextToken();
            String caps = dir.toUpperCase();
            try {
                if (caps.indexOf(".ZIP") > 0 || caps.indexOf(".JAR") > 0) {
                    int sep = dir.lastIndexOf(File.separator);
                    if (sep == -1 && !File.separator.equals("/")) {
                        sep = dir.lastIndexOf("/");
                    }
                    dir = sep == -1 ? ((sep = dir.lastIndexOf(":")) == -1 ? strJMF : String.valueOf(dir.substring(0, sep)) + ":" + strJMF) : String.valueOf(dir.substring(0, sep)) + File.separator + strJMF;
                } else {
                    dir = String.valueOf(dir) + File.separator + strJMF;
                }
            }
            catch (Exception exception) {
                dir = String.valueOf(dir) + File.separator + strJMF;
            }
            try {
                file = new File(dir);
                ris = Registry.getRegistryStream(file);
                if (ris == null) continue;
                filename = dir;
                break;
            }
            catch (Throwable throwable) {
                filename = null;
                return null;
            }
        }
        try {
            if (filename == null || file == null) {
                return null;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return ris;
    }

    private static FileInputStream getRegistryStream(File file) throws IOException {
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12ReadFileAction.cons;
                return (FileInputStream)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(file.getPath()));
            }
            if (!file.exists()) {
                return null;
            }
            return new FileInputStream(file.getPath());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static final synchronized boolean readRegistry(InputStream ris) {
        try {
            if (ris == null) {
                byte[] data;
                try {
                    Class<?> c2 = Class.forName("com.sun.media.util.RegistryLib");
                    data = (byte[])c2.getMethod("getData", null).invoke(c2, null);
                }
                catch (Exception exception) {
                    return false;
                }
                if (data == null) {
                    return false;
                }
                ris = new ByteArrayInputStream(data);
            }
            ObjectInputStream ois = new ObjectInputStream(ris);
            int tableSize = ois.readInt();
            int version = ois.readInt();
            if (version > 200) {
                System.err.println("Version number mismatch.\nThere could be errors in reading the registry");
            }
            hash = new Hashtable();
            int i2 = 0;
            while (i2 < tableSize) {
                String key = ois.readUTF();
                boolean failed = false;
                try {
                    Object value = ois.readObject();
                    hash.put(key, value);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    failed = true;
                }
                catch (OptionalDataException optionalDataException) {
                    failed = true;
                }
                ++i2;
            }
            ois.close();
            ris.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException in readRegistry: " + ioe);
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = Registry.class$("java.lang.Class"))).getMethod("forName", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Registry.class$("java.lang.String")), Boolean.TYPE, class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = Registry.class$("java.lang.ClassLoader")));
            getSystemClassLoaderM = (class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = Registry.class$("java.lang.ClassLoader"))).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = Registry.class$("java.lang.ClassLoader"))), null);
            getContextClassLoaderM = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = Registry.class$("java.lang.Thread"))).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
    }

    static Class getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e2) {
                if (!Registry.checkIfJDK12()) {
                    throw new ClassNotFoundException(e2.getMessage());
                }
            }
            catch (Error e3) {
                if (Registry.checkIfJDK12()) break block9;
                throw e3;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = Registry.class$("java.lang.Class"))), className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = Registry.class$("java.lang.Class"))), className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e4) {
                throw new ClassNotFoundException(e4.getMessage());
            }
            catch (Error e5) {
                throw e5;
            }
        }
    }

    public static void main(String[] args) {
        Format f1 = new Format("crap", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Registry.class$("java.lang.Integer")));
        Integer bad = new Integer(5);
        try {
            Class<?> vfclass = Class.forName("javax.media.format.H261Format");
            bad = vfclass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("H261Format not found in main()");
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        Format f2 = new Format("crap2", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = Registry.class$("java.lang.Boolean")));
        Registry.set("obj1", f1);
        Registry.set("obj2", bad);
        Registry.set("obj3", f2);
        try {
            Registry.commit();
        }
        catch (IOException ioe) {
            System.err.println("main: IO error in commit " + ioe);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        jmfSecurity = null;
        m = new Method[1];
        cl = new Class[1];
        args = new Object[1][0];
        classpath = null;
        hash = new Hashtable();
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "read property";
                    jmfSecurity.requestPermission(m, cl, args, 1);
                    m[0].invoke((Object)cl[0], args[0]);
                    permission = "read file";
                    jmfSecurity.requestPermission(m, cl, args, 2);
                    m[0].invoke((Object)cl[0], args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                }
            }
            catch (Throwable e2) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = jdk12PropertyAction.cons;
                classpath = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(CLASSPATH));
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        } else {
            try {
                if (securityPrivelege) {
                    classpath = System.getProperty(CLASSPATH);
                }
            }
            catch (Exception exception) {
                filename = null;
                securityPrivelege = false;
            }
        }
        if (classpath == null) {
            securityPrivelege = false;
        }
        InputStream registryInputStream = null;
        if (securityPrivelege && (registryInputStream = Registry.findJMFPropertiesFile()) == null) {
            securityPrivelege = false;
        }
        if (!Registry.readRegistry(registryInputStream)) {
            hash = new Hashtable();
        }
    }
}

