/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

public class ContentType {
    public static String getCorrectedContentType(String contentType, String fileName) {
        String type;
        if (contentType != null) {
            if (contentType.equals("audio/wav")) {
                return "audio/x-wav";
            }
            if (contentType.equals("audio/aiff")) {
                return "audio/x-aiff";
            }
            if (contentType.equals("application/x-troff-msvideo")) {
                return "video/x-msvideo";
            }
            if (contentType.equals("video/msvideo")) {
                return "video/x-msvideo";
            }
            if (contentType.equals("video/avi")) {
                return "video/x-msvideo";
            }
            if (contentType.equals("audio/x-mpegaudio")) {
                return "audio/mpeg";
            }
        }
        if ((type = ContentType.guessContentType(fileName)) != null) {
            return type;
        }
        if (contentType != null) {
            return contentType;
        }
        return "content/unknown";
    }

    public static String guessContentType(String path) {
        int i2 = path.lastIndexOf(".");
        if (i2 != -1) {
            String ext = path.substring(i2 + 1).toLowerCase();
            if (ext.equals("mov")) {
                return "video/quicktime";
            }
            if (ext.equals("avi")) {
                return "video/x_msvideo";
            }
            if (ext.equals("mpg")) {
                return "video/mpeg";
            }
            if (ext.equals("mpv")) {
                return "video/mpeg";
            }
            if (ext.equals("viv")) {
                return "video/vivo";
            }
            if (ext.equals("au")) {
                return "audio/basic";
            }
            if (ext.equals("wav")) {
                return "audio/x_wav";
            }
            if (ext.startsWith("aif")) {
                return "audio/x_aiff";
            }
            if (ext.equals("mid") || ext.equals("midi")) {
                return "audio/midi";
            }
            if (ext.equals("rmf")) {
                return "audio/rmf";
            }
            if (ext.equals("gsm")) {
                return "audio/x_gsm";
            }
            if (ext.equals("mp2")) {
                return "audio/mpeg";
            }
            if (ext.equals("mp3")) {
                return "audio/mpeg";
            }
            if (ext.equals("mpa")) {
                return "audio/mpeg";
            }
            if (ext.equals("g728")) {
                return "audio/g728";
            }
            if (ext.equals("g729")) {
                return "audio/g729";
            }
            if (ext.equals("g729a")) {
                return "audio/g729a";
            }
            if (ext.equals("mvr")) {
                return "application/mvr";
            }
            if (ext.equals("swf")) {
                return "application/x-shockwave-flash";
            }
            if (ext.equals("spl")) {
                return "application/futuresplash";
            }
        }
        return null;
    }
}

