/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TextComp
extends BasicComp
implements ActionListener {
    String value;
    int size;
    boolean mutable;
    Label compLabel;
    TextField compText;

    public TextComp(String label, String initial, int size, boolean mutable) {
        super(label);
        this.value = initial;
        this.size = size;
        this.mutable = mutable;
        this.setLayout(new BorderLayout());
        Label lab = new Label(label, 0);
        this.add("West", lab);
        if (!mutable) {
            this.compLabel = new Label(initial, 0);
            this.add("Center", this.compLabel);
        } else {
            this.compText = new TextField(initial, size);
            this.add("Center", this.compText);
            this.compText.addActionListener(this);
        }
    }

    public float getFloatValue() {
        this.value = this.getValue();
        try {
            float retVal = Float.valueOf(this.value).floatValue();
            return retVal;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public int getIntValue() {
        this.value = this.getValue();
        try {
            int retVal = Integer.valueOf(this.value);
            return retVal;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getValue() {
        if (this.mutable) {
            return this.compText.getText();
        }
        return this.compLabel.getText();
    }

    public void setValue(String s) {
        this.value = s;
        if (this.mutable) {
            ((TextComponent)this.compText).setText(s);
        } else {
            this.compLabel.setText(s);
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        this.informListener();
    }
}

