/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.AtomicControl;
import com.sun.media.controls.BooleanControl;
import com.sun.media.controls.ControlChangeEvent;
import com.sun.media.controls.ControlChangeListener;
import com.sun.media.ui.AtomicComponent;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public abstract class BooleanComponent
extends AtomicComponent
implements ControlChangeListener,
MouseListener {
    boolean state = false;
    boolean mouseIn = false;
    boolean mouseDown = false;
    boolean mouseUp = false;
    boolean mouseClick = false;
    int visualState = 1;

    public BooleanComponent(String tip) {
        super(tip);
        this.addMouseListener(this);
    }

    public abstract void mouseActivity();

    public void setControl(BooleanControl bc) {
        super.setControl(bc);
        this.state = bc.getValue();
        bc.addControlChangeListener(this);
    }

    public void controlChanged(ControlChangeEvent e2) {
        this.state = ((BooleanControl)this.control).getValue();
        this.setEnabled(((AtomicControl)this.control).getEnabled());
        this.repaint();
    }

    public boolean getValue() {
        return this.state;
    }

    public void setValue(boolean newState) {
        if (this.state != newState) {
            this.state = newState;
            if (this.control != null) {
                ((BooleanControl)this.control).setValue(this.state);
            }
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e2) {
        this.mouseIn = true;
        this.mouseActivity();
    }

    public void mouseExited(MouseEvent e2) {
        this.mouseIn = false;
        this.mouseActivity();
    }

    public void mousePressed(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseDown = true;
            this.mouseUp = false;
            this.mouseActivity();
        }
    }

    public void mouseReleased(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseUp = true;
            this.mouseActivity();
            this.mouseUp = false;
            this.mouseDown = false;
        }
    }

    public void mouseClicked(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseClick = true;
            this.mouseActivity();
            this.mouseClick = false;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }
}

