/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class RelativeTimeConverter {
    private double last_timestamp;
    private long last_system_time;
    private long delta_acc;
    private long delta_acc_2;

    public RelativeTimeConverter() {
        this.init();
    }

    public void convert(Buffer buffer, Format format) {
        if (format instanceof VideoFormat) {
            if (this.last_timestamp == 0.0) {
                this.last_timestamp = buffer.getTimeStamp();
                this.last_system_time = System.currentTimeMillis();
                this.delta_acc = 0L;
            } else {
                double buffer_time = buffer.getTimeStamp();
                if (buffer_time > this.last_timestamp) {
                    double delta = (buffer_time - this.last_timestamp) / 90.0;
                    this.last_timestamp = buffer_time;
                    this.delta_acc = (long)((double)this.delta_acc + delta * 1000000.0);
                    long system_time = System.currentTimeMillis();
                    long delta_2 = system_time - this.last_system_time;
                    this.last_system_time = system_time;
                    this.delta_acc_2 += delta_2 * 1000000L;
                }
            }
            double drift = (this.delta_acc_2 - this.delta_acc) / 1000000L;
            if (drift < -50.0 || drift > 50.0) {
                this.delta_acc = this.delta_acc_2;
            }
            buffer.setTimeStamp(this.delta_acc);
            buffer.setFlags(buffer.getFlags() | 0x80);
        }
    }

    public void init() {
        this.last_timestamp = 0.0;
        this.last_system_time = 0L;
        this.delta_acc = 0L;
    }
}

