/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.rtp.BufferControlImpl;
import com.sun.media.rtp.RelativeTimeConverter;
import com.sun.media.rtp.util.RTPMediaThread;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

public class RTPSourceStream
extends BasicSourceStream
implements PushBufferStream,
Runnable {
    Buffer current;
    private Format format;
    BufferTransferHandler handler;
    boolean started = false;
    Vector bufferQ;
    Object startReq = new Integer(0);
    Object readReq = new Integer(1);
    private RTPMediaThread thread;
    private boolean read = true;
    private long sample_buffer_limit;
    private long sample_thresh_limit;
    private int total_sample;
    private long vid_buffer_limit;
    private long vid_threshold_limit;
    private int total_frame;
    private long total_packet;
    private long vid_packet_limit;
    private boolean estimated = false;
    private double DEFAULT_AUDIO_RATE = 8000.0;
    private double DEFAULT_VIDEO_RATE = 15.0;
    private BufferControlImpl bc;
    private long last_seq_sent = -1L;
    private static final int ADD = 1;
    private static final int DELETE = 2;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private static final int NOT_SPECIFIED = -1;
    private RelativeTimeConverter rtc;
    Vector freebufs = new Vector();

    public RTPSourceStream() {
        this.bufferQ = new Vector();
        this.createThread();
        this.rtc = new RelativeTimeConverter();
    }

    private Buffer getBuf() {
        Vector vector = this.freebufs;
        synchronized (vector) {
            if (this.freebufs.size() == 0) {
                Buffer buffer = new Buffer();
                Object var3_4 = null;
                return buffer;
            }
            Buffer b2 = (Buffer)this.freebufs.firstElement();
            this.freebufs.removeElementAt(0);
            Buffer buffer = b2;
            Object var3_5 = null;
            return buffer;
        }
    }

    private void releaseBuf(Buffer b2) {
        Vector vector = this.freebufs;
        synchronized (vector) {
            this.freebufs.addElement(b2);
        }
    }

    private void createThread() {
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        if (this.thread == null) {
            this.thread = new RTPMediaThread(this, "RTPStream");
            this.thread.useControlPriority();
            this.thread.start();
        }
    }

    public void setBufferControl(BufferControl b2) {
        this.bc = (BufferControlImpl)b2;
        this.updateBuffer(b2.getBufferLength());
        this.updateThreshold(b2.getMinimumThreshold());
    }

    private void CropBufferIfNeeded() {
        Vector vector;
        Object b2 = null;
        if (this.format instanceof AudioFormat) {
            vector = this.bufferQ;
            synchronized (vector) {
                while (this.total_sample < 0 || (long)this.total_sample > this.sample_buffer_limit) {
                    this.DropHeadPacket();
                }
                this.bufferQ.notifyAll();
            }
        }
        if (this.format instanceof VideoFormat) {
            vector = this.bufferQ;
            synchronized (vector) {
                while (this.total_packet > this.vid_packet_limit) {
                    System.out.println("cropping");
                    this.DropHeadPacket();
                }
                this.bufferQ.notifyAll();
            }
        }
    }

    private void DropHeadPacket() {
        if (this.bufferQ.size() == 0) {
            return;
        }
        Buffer buffer = (Buffer)this.bufferQ.elementAt(0);
        this.bufferQ.removeElementAt(0);
        this.updateCounter(buffer, 2);
        this.last_seq_sent = buffer.getSequenceNumber();
        this.releaseBuf(buffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Buffer filled, boolean wrapped) {
        long head;
        Buffer buffer = null;
        Vector vector = this.bufferQ;
        synchronized (vector) {
            if (this.last_seq_sent != -1L && filled.getSequenceNumber() < this.last_seq_sent) {
                if (!wrapped) {
                    return;
                }
                wrapped = false;
            }
            if ((head = this.getHead()) != -1L && filled.getSequenceNumber() < head && this.isBufferReached()) {
                return;
            }
            if (this.isBufferReached()) {
                this.DropHeadPacket();
                this.bufferQ.notifyAll();
            }
        }
        buffer = this.getBuf();
        if (buffer == null) {
            System.out.println("something strange");
            return;
        }
        buffer.setData(filled.getData());
        buffer.setHeader(filled.getHeader());
        buffer.setTimeStamp(filled.getTimeStamp());
        buffer.setFormat(filled.getFormat());
        buffer.setLength(filled.getLength());
        buffer.setOffset(filled.getOffset());
        buffer.setSequenceNumber(filled.getSequenceNumber());
        buffer.setFlags(filled.getFlags());
        vector = this.bufferQ;
        synchronized (vector) {
            head = this.getHead();
            long tail = this.getTail();
            if (head == -1L && tail == -1L) {
                this.bufferQ.addElement(buffer);
            } else if (buffer.getSequenceNumber() < head) {
                this.bufferQ.insertElementAt(buffer, 0);
            } else if (head < buffer.getSequenceNumber() && buffer.getSequenceNumber() < tail) {
                int index = this.FindLeastHighestIndex(buffer.getSequenceNumber());
                this.bufferQ.insertElementAt(buffer, index);
            } else if (buffer.getSequenceNumber() > tail) {
                this.bufferQ.addElement(buffer);
            }
            this.updateCounter(buffer, 1);
            this.bufferQ.notifyAll();
            return;
        }
    }

    private void updateCounter(Buffer b2, int mode) {
        if (this.format instanceof AudioFormat) {
            int s = this.calculateSampleCount(b2);
            if (s < 0) {
                this.total_sample = s;
            } else {
                if (mode == 2) {
                    this.total_sample -= this.calculateSampleCount(b2);
                }
                if (mode == 1) {
                    this.total_sample += this.calculateSampleCount(b2);
                }
            }
        }
        if (this.format instanceof VideoFormat) {
            if (mode == 1) {
                if (!this.estimated) {
                    ++this.vid_packet_limit;
                    if ((b2.getFlags() & 0x400) != 0) {
                        ++this.total_frame;
                        if ((long)this.total_frame == this.vid_buffer_limit + 1L) {
                            this.estimated = true;
                        }
                    }
                }
                ++this.total_packet;
            }
            if (mode == 2) {
                --this.total_packet;
            }
        }
    }

    private boolean isBufferReached() {
        if (this.format instanceof AudioFormat) {
            return this.total_sample < 0 || (long)this.total_sample >= this.sample_buffer_limit;
        }
        if (this.format instanceof VideoFormat) {
            if (!this.estimated) {
                return false;
            }
            return this.total_packet >= this.vid_packet_limit;
        }
        return true;
    }

    private boolean isThresholdReached() {
        if (!this.bc.getEnabledThreshold() || this.bc.getMinimumThreshold() == 0L) {
            return this.bufferQ.size() > 0;
        }
        if (this.format instanceof AudioFormat && (this.total_sample < 0 || (long)this.total_sample >= this.sample_thresh_limit)) {
            return this.bufferQ.size() > 0;
        }
        if (this.format instanceof VideoFormat && (long)this.total_frame >= this.vid_threshold_limit) {
            return this.bufferQ.size() > 0;
        }
        return false;
    }

    private int FindLeastHighestIndex(long seqno) {
        int i2 = 0;
        while (i2 < this.bufferQ.size()) {
            Buffer b2 = (Buffer)this.bufferQ.elementAt(i2);
            if (b2.getSequenceNumber() > seqno) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private int calculateSampleCount(Buffer b2) {
        if (this.format == null || this.format instanceof VideoFormat) {
            return -1;
        }
        if (this.format instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)this.format;
            int sampleSizeInBits = af.getSampleSizeInBits();
            int length = b2.getLength();
            if (this.format.getEncoding().equals("dvi/rtp")) {
                return (length -= 4) * 8 / sampleSizeInBits;
            }
            if ((this.format.getEncoding().equals("LINEAR") || this.format.getEncoding().equals("ULAW/rtp")) && sampleSizeInBits != -1) {
                return length * 8 / sampleSizeInBits;
            }
            if (this.format.getEncoding().equals("gsm/rtp")) {
                return length / 33 * 160;
            }
            if (this.format.getEncoding().equals("g723/rtp")) {
                return length / 24 * 240;
            }
            if (this.format.getEncoding().equals("g728/rtp")) {
                return length / 5 * 20;
            }
            if (this.format.getEncoding().equals("g729/rtp") || this.format.getEncoding().equals("g729a/rtp")) {
                return length / 10 * 80;
            }
            if (af.getFrameSizeInBits() != -1 && af.getFrameRate() != -1.0) {
                return length * 8 / af.getFrameSizeInBits();
            }
        }
        return -1;
    }

    private long getHead() {
        if (this.bufferQ.size() == 0) {
            return -1L;
        }
        Buffer b2 = (Buffer)this.bufferQ.firstElement();
        return b2.getSequenceNumber();
    }

    private long getTail() {
        if (this.bufferQ.size() == 0) {
            return -1L;
        }
        Buffer b2 = (Buffer)this.bufferQ.lastElement();
        return b2.getSequenceNumber();
    }

    private void reset() {
        if (this.format instanceof AudioFormat) {
            while (this.bufferQ.size() != 0) {
                this.DropHeadPacket();
            }
            this.total_sample = 0;
            this.last_seq_sent = -1L;
        }
        if (this.format instanceof VideoFormat) {
            while (this.bufferQ.size() != 0) {
                this.DropHeadPacket();
            }
            this.total_frame = 0;
            this.total_packet = 0L;
            this.vid_packet_limit = 0L;
            this.estimated = false;
            this.last_seq_sent = -1L;
        }
    }

    protected long updateBuffer(long buffer) {
        if (this.format == null || this.bc == null) {
            return buffer;
        }
        if (this.format instanceof AudioFormat) {
            double sampleRate = ((AudioFormat)this.format).getSampleRate();
            long new_sample_buffer_limit = (long)(sampleRate * (double)buffer / 1000.0);
            if (new_sample_buffer_limit >= this.sample_thresh_limit) {
                this.sample_buffer_limit = new_sample_buffer_limit;
            }
            System.out.println("Buffer Length= " + this.sample_buffer_limit + " samples");
            System.out.println("Threshold Length= " + this.sample_thresh_limit + "samples");
            this.CropBufferIfNeeded();
            return (long)((double)(this.sample_buffer_limit * 1000L) / sampleRate);
        }
        if (this.format instanceof VideoFormat) {
            long new_vid_buffer_limit = buffer * 15L / 1000L;
            if (this.vid_packet_limit != 0L) {
                this.vid_packet_limit *= new_vid_buffer_limit / this.vid_buffer_limit;
            }
            this.vid_buffer_limit = new_vid_buffer_limit;
            System.out.println("vid buffer limit in frames is " + this.vid_buffer_limit + " frames");
            this.CropBufferIfNeeded();
            return buffer;
        }
        return -1L;
    }

    public long updateThreshold(long threshold) {
        if (this.format == null || this.bc == null) {
            return threshold;
        }
        if (this.format instanceof AudioFormat) {
            double sampleRate = ((AudioFormat)this.format).getSampleRate();
            long new_sample_thresh_limit = (long)(sampleRate * (double)threshold / 1000.0);
            if (new_sample_thresh_limit <= this.sample_buffer_limit) {
                this.sample_thresh_limit = new_sample_thresh_limit;
            }
            System.out.println("Buffer Length= " + this.sample_buffer_limit + " samples");
            System.out.println("Threshold Length= " + this.sample_thresh_limit + "samples");
            return (long)((double)(this.sample_thresh_limit * 1000L) / sampleRate);
        }
        if (this.format instanceof VideoFormat) {
            long new_vid_threshold_limit = threshold * 15L / 1000L;
            if (new_vid_threshold_limit < this.vid_buffer_limit) {
                this.vid_threshold_limit = new_vid_threshold_limit;
            }
            return threshold;
        }
        return -1L;
    }

    public Format getFormat() {
        return this.format;
    }

    protected void setFormat(Format format) {
        this.format = format;
        if (this.bc == null) {
            return;
        }
        this.updateBuffer(this.bc.getBufferLength());
        this.updateThreshold(this.bc.getMinimumThreshold());
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.handler = transferHandler;
    }

    void setContentDescriptor(String contentType) {
        this.contentDescriptor = new ContentDescriptor(contentType);
    }

    public void read(Buffer buffer) {
        Buffer current = null;
        Object object = this.bufferQ;
        synchronized (object) {
            if (this.bufferQ.size() > 0) {
                current = (Buffer)this.bufferQ.elementAt(0);
                this.bufferQ.removeElementAt(0);
                this.updateCounter(current, 2);
                this.last_seq_sent = current.getSequenceNumber();
            }
        }
        if (current == null) {
            buffer.setDiscard(true);
            object = this.readReq;
            synchronized (object) {
                this.read = true;
                this.readReq.notifyAll();
            }
            return;
        }
        buffer.setFlags(current.getFlags() | 0x60);
        buffer.setFlags(current.getFlags());
        buffer.setData(current.getData());
        current.setData(null);
        buffer.setHeader(current.getHeader());
        current.setHeader(null);
        buffer.setTimeStamp(current.getTimeStamp());
        buffer.setFormat(current.getFormat());
        buffer.setLength(current.getLength());
        buffer.setOffset(current.getOffset());
        buffer.setSequenceNumber(current.getSequenceNumber());
        this.releaseBuf(current);
        object = this.readReq;
        synchronized (object) {
            this.read = true;
            this.readReq.notifyAll();
        }
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
    }

    public void stop() {
        this.started = false;
        Object object = this.startReq;
        synchronized (object) {
            Vector vector = this.bufferQ;
            synchronized (vector) {
                this.reset();
                this.bufferQ.notifyAll();
            }
            this.startReq.notifyAll();
        }
    }

    public void connect() {
        this.createThread();
    }

    public void close() {
        this.stop();
        try {
            if (this.thread != null) {
                this.thread.stop();
            }
            this.thread = null;
        }
        catch (Exception exception) {}
    }

    public void run() {
        try {
            while (true) {
                Object object = this.startReq;
                synchronized (object) {
                    while (!this.started) {
                        this.startReq.wait();
                    }
                }
                object = this.bufferQ;
                synchronized (object) {
                    while (!this.isThresholdReached()) {
                        this.bufferQ.wait();
                    }
                }
                object = this.readReq;
                synchronized (object) {
                    while (!this.read) {
                        this.readReq.wait();
                    }
                    this.read = false;
                }
                if (this.handler == null) continue;
                this.handler.transferData(this);
            }
        }
        catch (InterruptedException e2) {
            System.err.println("Thread " + e2.getMessage());
            return;
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

