/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.RTPTransmitter;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.util.RTPMediaThread;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.event.LocalPayloadChangeEvent;

public class RTPSinkStream
implements BufferTransferHandler {
    private RTPMediaThread thread;
    Buffer current = new Buffer();
    boolean started = false;
    Object startReq = new Integer(0);
    RTPTransmitter transmitter;
    SendSSRCInfo info;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    long startTime;
    long startPT = -1L;
    int rate;
    long audioPT;
    static int THRESHOLD;
    static int LEEWAY;

    public void startStream() {
        block6: {
            if (jmfSecurity == null) break block6;
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                    break block6;
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
    }

    protected void setSSRCInfo(SendSSRCInfo info) {
        this.info = info;
    }

    protected void setTransmitter(RTPTransmitter t) {
        this.transmitter = t;
    }

    public void transferData(PushBufferStream stream) {
        try {
            Object object = this.startReq;
            synchronized (object) {
                while (!this.started) {
                    this.startPT = -1L;
                    this.startReq.wait();
                }
            }
            stream.read(this.current);
            if (!this.current.getFormat().matches(this.info.myformat)) {
                int payload = this.transmitter.cache.sm.formatinfo.getPayload(this.current.getFormat());
                if (payload == -1) {
                    return;
                }
                LocalPayloadChangeEvent evt = new LocalPayloadChangeEvent(this.transmitter.cache.sm, this.info, this.info.payloadType, payload);
                this.transmitter.cache.eventhandler.postEvent(evt);
                this.info.payloadType = payload;
                this.info.myformat = this.current.getFormat();
            }
            if (this.info.myformat instanceof VideoFormat) {
                this.transmitVideo();
            }
            if (this.info.myformat instanceof AudioFormat) {
                this.transmitAudio();
            }
        }
        catch (Exception exception) {}
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
    }

    public void stop() {
        this.started = false;
        this.startPT = -1L;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
    }

    protected void close() {
        this.stop();
    }

    private void transmitVideo() {
        if (this.current.isEOM() || this.current.isDiscard()) {
            this.startPT = -1L;
            return;
        }
        if (this.startPT == -1L) {
            this.startTime = System.currentTimeMillis();
            this.startPT = this.current.getTimeStamp() / 1000000L;
        }
        if (this.current.getTimeStamp() > 0L && (this.current.getFlags() & 0x60) == 0 && (this.current.getFlags() & 0x400) != 0) {
            this.waitForPT(this.startTime, this.startPT, this.current.getTimeStamp() / 1000000L);
        }
        this.transmitter.TransmitPacket(this.current, this.info);
    }

    private void transmitAudio() {
        if (this.current.isEOM() || this.current.isDiscard()) {
            this.startPT = -1L;
            return;
        }
        if (this.startPT == -1L) {
            this.startTime = System.currentTimeMillis();
            this.audioPT = this.startPT = this.current.getTimeStamp() > 0L ? this.current.getTimeStamp() / 1000000L : 0L;
        }
        if ((this.current.getFlags() & 0x60) == 0) {
            this.audioPT += this.audioLenToTime((AudioFormat)this.info.myformat, this.current.getLength());
            this.waitForPT(this.startTime, this.startPT, this.audioPT);
        }
        this.transmitter.TransmitPacket(this.current, this.info);
    }

    long audioLenToTime(AudioFormat f2, int len) {
        if (f2.getEncoding().equals("LINEAR") || f2.getEncoding().equals("ULAW/rtp")) {
            long count = len * 8 / f2.getSampleSizeInBits() / f2.getChannels();
            return (long)((double)(count * 1000L) / f2.getSampleRate());
        }
        if (f2.getEncoding().equals("dvi/rtp")) {
            long count = (len - 4) * 8 / f2.getSampleSizeInBits();
            return (long)((double)(count * 1000L) / f2.getSampleRate());
        }
        if (f2.getEncoding().equals("gsm/rtp")) {
            long count = len / 33 * 160;
            return (long)((double)(count * 1000L) / f2.getSampleRate());
        }
        if (f2.getEncoding().equals("g723/rtp")) {
            long count = len / 24 * 240;
            return (long)((double)(count * 1000L) / f2.getSampleRate());
        }
        if (f2.getFrameSizeInBits() != -1 && f2.getFrameRate() != -1.0) {
            long count = len * 8 / f2.getFrameSizeInBits();
            return (long)((double)(count * 1000L) / f2.getFrameRate());
        }
        return 0L;
    }

    private void waitForPT(long start, long startPT, long pt) {
        long delay = pt - startPT - (System.currentTimeMillis() - start);
        while (delay > (long)LEEWAY) {
            if (delay > (long)THRESHOLD) {
                delay = THRESHOLD;
            }
            try {
                Thread.currentThread();
                Thread.sleep(delay);
            }
            catch (Exception exception) {
                break;
            }
            delay = pt - startPT - (System.currentTimeMillis() - start);
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
        THRESHOLD = 80;
        LEEWAY = 5;
    }
}

